package backend.base;

import backend.base.taxonomy.Subtype;
import backend.base.taxonomy.Type;

public class Change {

    public enum Category {
        EVOLVABILITY,
        FUNCTIONAL,
        UNKNOWN
    }

    public enum Triggered {
        TRIGGERED,
        UNDOCUMENTED,
        UNKNOWN
    }

    private String changeID;
    private String reviewID;
    private String revisionID;
    private String fileName;
    private LineBlock lineBlock;
    private Category category;
    private Type type;
    private Subtype subtype;
    private Triggered triggered;

    public Change (String changeID, String reviewID, String revisionID,
                   String fileName, LineBlock lineBlock, Category category, Type type, Subtype subtype, Triggered triggered) {
        this.changeID = changeID;
        this.reviewID = reviewID;
        this.revisionID = revisionID;
        this.fileName = fileName;
        this.lineBlock = lineBlock;
        this.category = category;
        this.type = type;
        this.subtype = subtype;
        this.triggered = triggered;
    }

    public String getChangeID() {
        return changeID;
    }

    public String getReviewID(){
        return reviewID;
    }

    public String getRevisionID(){
        return revisionID;
    }

    public String getFileName() { return  fileName; }

    public LineBlock getLineBlock(){
        return lineBlock;
    }

    public Category getCategory() {
        return category;
    }

    public Type getType() {
        return type;
    }

    public Subtype getSubtype() {
        return subtype;
    }

    public Triggered getTriggered() {
        return triggered;
    }

}
