package backend.analysis.textualSimilarities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TFIDFCalculator {

    private List<String> comments;
    private List<List<String>> documents;

    private static TFIDFCalculator instance = null;

    private TFIDFCalculator(){
        documents = new ArrayList<>();
    }

    public static TFIDFCalculator getInstance(){
        if(instance==null){
            instance = new TFIDFCalculator();
        }
        return instance;
    }


    public void setCommentsList(List<String> comments) {
        this.comments = comments;
        for (String c : comments) {
            String[] wordsInComment = c.split(" ");
                documents.add(Arrays.asList(wordsInComment));
        }
    }


    /**
     * @param doc  list of strings
     * @param term String represents a term
     * @return term frequency of term in document
     */
    public double tf(List<String> doc, String term) {
        double result = 0;
        for (String word : doc) {
            if (term.equalsIgnoreCase(word))
                result++;
        }
        return result / doc.size();
    }

    /**
     * @param docs list of list of strings represents the dataset
     * @param term String represents a term
     * @return the inverse term frequency of term in documents
     */
    public double idf(List<List<String>> docs, String term) {
        double n = 0;
        for (List<String> doc : docs) {
            for (String word : doc) {
                if (term.equalsIgnoreCase(word)) {
                    n++;
                    break;
                }
            }
        }
        return Math.log(docs.size() / n);
    }

    /**
     * @param doc  a text document
     * @param docs all documents
     * @param term term
     * @return the TF-IDF of term
     */
    public double tfIdf(List<String> doc, List<List<String>> docs, String term) {
        return tf(doc, term) * idf(docs, term);

    }


    public double computeTfIdf(String[] wordsInComment, String wordToEvaluate) {
        double tfidf = tfIdf(Arrays.asList(wordsInComment), documents, wordToEvaluate);
        return tfidf;
    }


}
