package backend.analysis.machineLearning;

import backend.analysis.textualSimilarities.Stopwords;
import backend.analysis.textualSimilarities.PorterStemmer;
import backend.analysis.textualSimilarities.TFIDFCalculator;
import backend.base.gerrit_data.Comment;
import backend.base.gerrit_data.Modification;


import java.util.ArrayList;
import java.util.List;

public class TextualFeatures {

    private final double THRESHOLD = 0.5;

    public List<String> computeTfiDf(String comment) {

        String commentToLowercase = comment.toLowerCase();

        String[] wordsInComment = commentToLowercase.split(" ");
        List<String> wordsFiltered = new ArrayList<>();

        for(String word : wordsInComment){
            if(!Stopwords.isStopWord(word)){
                wordsFiltered.add(word);
            }
        }

        List<String> stemmedWords = new ArrayList<>();
        PorterStemmer porterStemmer = new PorterStemmer();

        for(String wordToStem : wordsFiltered){
            stemmedWords.add(porterStemmer.stemString(wordToStem));
        }

        TFIDFCalculator tfidfCalculator = TFIDFCalculator.getInstance();
        List<String> importantWords = new ArrayList<>();

        for(String word : stemmedWords) {
            double tfidValue = tfidfCalculator.computeTfIdf(wordsInComment, word);
            if(tfidValue>THRESHOLD){
                importantWords.add(word);
            }
        }



        return importantWords;


    }

    public int numberOfWords(Modification modification){

        if(modification.getOldCodeChunk()==null){
            return 0;
        }
        if(modification.getOldCodeChunk().getComments()==null || modification.getOldCodeChunk().getComments().isEmpty()){
            return 0;
        }

        String s = "";
        for(Comment comment : modification.getOldCodeChunk().getComments()){
            s = s.concat(comment.getMessage());
        }
        int wordCount = 0;

        boolean word = false;
        int endOfLine = s.length() - 1;

        for (int i = 0; i < s.length(); i++) {
            if (Character.isLetter(s.charAt(i)) && i != endOfLine) {
                word = true;
            } else if (!Character.isLetter(s.charAt(i)) && word) {
                wordCount++;
                word = false;
                // last word of String; if it doesn't end with a non letter, it
                // wouldn't count without this.
            } else if (Character.isLetter(s.charAt(i)) && i == endOfLine) {
                wordCount++;
            }
        }
        return wordCount;
    }


    public int numberOfChars(Modification modification){
        if(modification.getOldCodeChunk()==null){
            return 0;
        }
        if(modification.getOldCodeChunk().getComments()==null || modification.getOldCodeChunk().getComments().isEmpty()){
            return 0;
        }
        String s = "";
        for(Comment comment : modification.getOldCodeChunk().getComments()){
            s = s.concat(comment.getMessage());
        }
        return s.length();
    }

}
