package backend.analysis.machineLearning;

import backend.analysis.StringDiffer;
import backend.base.gerrit_data.Comment;
import backend.base.gerrit_data.DiffLine;
import backend.base.gerrit_data.Modification;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;

import java.util.Properties;

public class POSCalculator {

    public int computePos(Modification modification) {

        StringDiffer stringDiffer = new StringDiffer();

        int countOldNouns = 0;
        int countNewNouns = 0;

        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                try {
                    Sentence sentence = new Sentence(diffLine.getDiffLine());

                    for (String pos : sentence.posTags()) {
                        if(pos.equals("NN")){
                           countOldNouns++;
                        }
                        // traversing the words in the current sentence
                        // a CoreLabel is a CoreMap with additional token-specific methods
                    }
                }
                catch(IllegalStateException e){
                    System.out.println("Empty String");
                }
            }
        }
        if (modification.getNewCodeChunk() != null) {
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                try {
                    Sentence sentence = new Sentence(diffLine.getDiffLine());

                    for (String pos : sentence.posTags()) {
                        if(pos.equals("NN")){
                            countNewNouns++;
                        }
                        // traversing the words in the current sentence
                        // a CoreLabel is a CoreMap with additional token-specific methods
                        //System.out.println("\n\n: Word:" + diff.text + " POS :" + pos);
                    }
                }
                catch(IllegalStateException e){
                    System.out.println("Empty String");
                }
            }
        }
        return countNewNouns - countOldNouns;
    }

    public int analyseSentiments(Modification modification){
        if(modification.getOldCodeChunk()==null){
            return -1;
        }
        if(modification.getOldCodeChunk().getComments()==null || modification.getOldCodeChunk().getComments().isEmpty()){
            return -1;
        }
        String s = "";
        for(Comment comment : modification.getOldCodeChunk().getComments()){
            s = s.concat(comment.getMessage());
        }

        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, parse, sentiment");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        int sumSentiment = 0;
        int numSentiments = 0;
        Annotation annotation = pipeline.process(s);
                pipeline.annotate(annotation);
        for (CoreMap sentence : annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            Tree tree = sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
            int sentiment = RNNCoreAnnotations.getPredictedClass(tree);
            sumSentiment = sumSentiment + sentiment;
            numSentiments++;
            String partText = sentence.toString();
            }
        return sumSentiment/numSentiments;
    }


}
