package backend.analysis.machineLearning;

import backend.analysis.LocalDiffMatchPatch;
import backend.analysis.StringDiffer;
import backend.base.gerrit_data.DiffLine;
import backend.base.gerrit_data.Modification;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionalFeaturesExtractor {


    String patternIf = ".*if\\s*\\(.*";

    String patternFor = ".*for\\s*\\(.*";
    String patternWhile = ".*while\\s*\\(.*";

    String patternFunction = "[a-zA-Z]+\\([^\\)]*\\)(\\.[^\\)]*\\))?";

    String patternBracketLeft = ".*\\(.*";
    String patternBrackeRight = ".*\\).*";

    public int countIfNumber(Modification modification) {
        Pattern p = Pattern.compile(patternIf);
        StringDiffer stringDiffer = new StringDiffer();
        String firstKeyWordFound = "";

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int numberOfKeyWords = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.INSERT)) {
                Matcher m = p.matcher(diff.text);
                    if (m.find()) {
                        numberOfKeyWords++;
                    }
            }

        }
        return numberOfKeyWords;

    }



    public int countFunctionAdded(Modification modification) {
        Pattern p = Pattern.compile(patternFunction);
        StringDiffer stringDiffer = new StringDiffer();
        String firstKeyWordFound = "";

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int numberOfKeyWords = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.INSERT)) {
                Matcher m = p.matcher(diff.text);
                if (m.find()) {
                    numberOfKeyWords++;
                }
            }

        }
        return numberOfKeyWords;

    }


    public int countAssignmentAdded(Modification modification) {
        String patternAssignment = ".*=[ˆ=].*";
        Pattern p = Pattern.compile(patternAssignment);
        StringDiffer stringDiffer = new StringDiffer();

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int numberOfKeyWords = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.INSERT)) {
                Matcher m = p.matcher(diff.text);
                if (m.find()) {
                    numberOfKeyWords++;
                }
            }

        }
        return numberOfKeyWords;

    }


    public int countFunctionsNew(Modification modification) {
        Pattern p = Pattern.compile(patternFunction);

        int countNew = 0;


        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew;

    }


    public int countIFDiff(Modification modification) {
        Pattern p = Pattern.compile(patternIf);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }

    public int countArithmeticDiff(Modification modification) {
        String patternAr = "\\+|-|/|\\*";
        Pattern p = Pattern.compile(patternAr);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }


    public int countFunctionsDiff(Modification modification) {
        Pattern p = Pattern.compile(patternFunction);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }


    public int countCyclesDiff(Modification modification) {
        Pattern p = Pattern.compile(patternFor);
        Pattern g = Pattern.compile(patternWhile);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                Matcher w = g.matcher(diffLine.getDiffLine());
                if(m.find() || w.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                Matcher w = g.matcher(diffLine.getDiffLine());
                if(m.find() || w.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }


    public int countAssignmentDiff(Modification modification) {
        String patternAssignment = ".*=[ˆ=].*";
        Pattern p = Pattern.compile(patternAssignment);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }


    public int countComparisonDiff(Modification modification) {
        String patternComp = ".*new\\s+";
        Pattern p = Pattern.compile(patternComp);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }

    public int countCommasDiff(Modification modification) {
        String patternComp = ",";
        Pattern p = Pattern.compile(patternComp);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }


    public int countThrowDiff(Modification modification) {
        String patternComp = "throw";
        Pattern p = Pattern.compile(patternComp);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }



    public int countBracketsDiff(Modification modification) {
        String patternComp = ".*\\(\\s+";
        Pattern p = Pattern.compile(patternComp);

        int countOld = 0;
        int countNew = 0;


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countOld++;
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    countNew++;
                }
            }
        }

        return countNew - countOld;

    }


    public int countBracketsAdded(Modification modification) {
        String patternComp = ".*\\(\\s+";
        Pattern p = Pattern.compile(patternComp);
        StringDiffer stringDiffer = new StringDiffer();

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int numberOfKeyWords = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.INSERT)) {
                Matcher m = p.matcher(diff.text);
                if (m.find()) {
                    numberOfKeyWords++;
                }
            }
        }
        return numberOfKeyWords;

    }


    public int countNewAdded(Modification modification) {
        String patternComp = ".*new\\s+";
        Pattern p = Pattern.compile(patternComp);
        StringDiffer stringDiffer = new StringDiffer();

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int numberOfKeyWords = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.INSERT)) {
                Matcher m = p.matcher(diff.text);
                if (m.find()) {
                    numberOfKeyWords++;
                }
            }
        }
        return numberOfKeyWords;

    }


    public int countNewDel(Modification modification) {
        String patternComp = ".*new\\s+";
        Pattern p = Pattern.compile(patternComp);
        StringDiffer stringDiffer = new StringDiffer();

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int numberOfKeyWords = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.DELETE)) {
                Matcher m = p.matcher(diff.text);
                if (m.find()) {
                    numberOfKeyWords++;
                }
            }
        }
        return numberOfKeyWords;

    }





    public int countCyclesNew(Modification modification) {
        Pattern p = Pattern.compile(patternFor);
        Pattern g = Pattern.compile(patternWhile);

        int countNew = 0;

        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                Matcher w = g.matcher(diffLine.getDiffLine());
                if(m.find() || w.find()){
                    countNew++;
                }
            }
        }

        return countNew;

    }


    public int countFunctionsChanged(Modification modification) {
        Pattern p = Pattern.compile(patternFunction);

        List<String> oldFunctions = new ArrayList<>();
        List<String> newFunctions = new ArrayList<>();


        if (modification.getOldCodeChunk() != null) {
            for(DiffLine diffLine : modification.getOldCodeChunk().getLines()){
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    oldFunctions.add(m.group());
                }
            }
        }

        if (modification.getNewCodeChunk() != null) {
            int count = 0;
            for(DiffLine diffLine : modification.getNewCodeChunk().getLines()){
                count++;
                Matcher m = p.matcher(diffLine.getDiffLine());
                if(m.find()){
                    newFunctions.add(m.group());
                }
            }
        }

        if(oldFunctions.isEmpty() || newFunctions.isEmpty()){
            return 0;
        }

        if(oldFunctions.size()!=newFunctions.size()){
            return 0;
        }

        int countDiff = 0;
        for(int i = 0; i<oldFunctions.size(); i++){
            if(!oldFunctions.get(i).equals(newFunctions.get(i))){
                countDiff++;
            }
        }

        return countDiff;

    }


    public int isModificationInBrackets(Modification modification) {
        StringDiffer stringDiffer = new StringDiffer();

        String oldChunk = "";
        String newChunk = "";

        if (modification.getOldCodeChunk() != null) {
            oldChunk = concatLines(modification.getOldCodeChunk().getLines());
        }
        else {
            return 0;
        }
        if (modification.getNewCodeChunk() != null) {
            newChunk = concatLines(modification.getNewCodeChunk().getLines());
        }
        else{
            return 0;
        }

        LinkedList<LocalDiffMatchPatch.Diff> diffLinkedList = stringDiffer.createDiffList(oldChunk, newChunk);

        int countInsert = 0;

        for (LocalDiffMatchPatch.Diff diff : diffLinkedList) {
            if (diff.operation.equals(LocalDiffMatchPatch.Operation.INSERT)) {
                countInsert++;
            }

        }

        if(countInsert==1){
            boolean found = false;
            int i = 0;
            while(i<diffLinkedList.size() && found == false){
                if(diffLinkedList.get(i).operation.equals(LocalDiffMatchPatch.Operation.INSERT)){
                    found = true;
                }
                else {
                    i++;
                }
            }

            LocalDiffMatchPatch.Diff leftDiff = searchCommonOnLeft(diffLinkedList, i);
            LocalDiffMatchPatch.Diff rightDiff = searchCommonOnRight(diffLinkedList, i);

            if(leftDiff==null || rightDiff==null){
                return 0;
            }
            else {
                if (Pattern.matches(patternBracketLeft, leftDiff.text) &&
                        Pattern.matches(patternBrackeRight, rightDiff.text)) {
                    return 1;
                }
            }
        }

        return 0;

    }


    private LocalDiffMatchPatch.Diff searchCommonOnLeft(LinkedList<LocalDiffMatchPatch.Diff> list, int index){
        if(index-1>=0) {
            for (int i = index - 1; i>=0; i--){
                if(list.get(i).operation.equals(LocalDiffMatchPatch.Operation.EQUAL)){
                    return list.get(i);
                }
            }
        }
        return null;
    }


    private LocalDiffMatchPatch.Diff searchCommonOnRight(LinkedList<LocalDiffMatchPatch.Diff> list, int index){
        if(index+1>=list.size()) {
            for (int i = index + 1; i<list.size(); i++){
                if(list.get(i).operation.equals(LocalDiffMatchPatch.Operation.EQUAL)){
                    return list.get(i);
                }
            }
        }
        return null;
    }


    private String concatLines(List<DiffLine> lines){
        String concatLine = "";
        for(DiffLine diffLine : lines){
            concatLine = concatLine.concat(diffLine.getDiffLine());
        }
        return concatLine;
    }


}
