package backend.analysis.machineLearning;

import backend.base.gerrit_data.*;

import java.security.InvalidAlgorithmParameterException;
import java.util.List;

public class CyclomaticComplexity {

    Modification modification;

    public CyclomaticComplexity(Modification modification){
        this.modification = modification;
    }

    public int calculateCyclomatic(CodeChunk chunk){
        int complexity = 0;

        if(chunk == null){
            return complexity;
        }

        List<DiffLine> lines = chunk.getLines();

        if (lines.get(0).getDiffLine().startsWith("/"))
            return  complexity;

        complexity++;

        for (DiffLine line : lines){
            String words[] = line.getDiffLine().split(" ");
            for(String word : words){
                if (word.equals("if") || word.equals("while") || word.equals("for") || word.equals("case") ||
                        word.equals("&&") || word.equals("||") || word.equals("?:") || word.equals("?."))
                    complexity++;
            }
        }

        return complexity;
    }

    public int getChunkCyclomatic(int side) throws InvalidAlgorithmParameterException {
        int cyclomaticScore = -1;
        CodeChunk toEvaluate = null;
        if (side == 0)
            toEvaluate = modification.getOldCodeChunk();
        else if (side == 1)
            toEvaluate = modification.getNewCodeChunk();
        else
            throw new InvalidAlgorithmParameterException();

        if (toEvaluate != null)
            cyclomaticScore = calculateCyclomatic(toEvaluate);

        return cyclomaticScore;
    }
}
