package backend.analysis;

import backend.base.Change;
import backend.base.gerrit_data.ReviewDiff;
import backend.base.taxonomy.Subtype;
import backend.db_connectors.Dataset;
import com.google.common.collect.Multimap;

import java.util.ArrayList;
import java.util.List;

public class SubtypeSelector {

    private String datasetPath;

    public SubtypeSelector(String datasetPath){
        this.datasetPath = datasetPath;
    }

    public List<ReviewDiff> select(Subtype subtype, Multimap<String, ReviewDiff> diffs){
        List<ReviewDiff> reviewDiffs = new ArrayList<>();
        for(String key : diffs.keySet()) {
            Change ch = findRelatedChange(key);
                if (ch.getSubtype().equals(subtype)) {
                    for (ReviewDiff reviewDiff : diffs.get(key)) {
                        reviewDiffs.add(reviewDiff);
                    }
                }
            }
        return reviewDiffs;
    }

    private Change findRelatedChange(String changeID) {
        Dataset dataset = new Dataset(datasetPath);
        Multimap<String, Change> changes = dataset.getChanges();
        if(changes.containsKey(changeID)){
           for(Change ch: changes.get(changeID)) {
               return ch;
           }
        }
        return null;
    }

}
