package backend.analysis;

import backend.base.gerrit_data.CodeChunk;
import backend.base.gerrit_data.DiffLine;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * A filter to remove chunks containing only imports
 */

public class ImportFilter {


    private final String patternString = ".*import.*";


    public List<CodeChunk> filterImports(List<CodeChunk> codeChunkList){
        List<CodeChunk> filteredCodeChunksList = new ArrayList<>();
        for(CodeChunk chunk : codeChunkList){
            if(!isChunkImport(chunk)){
                filteredCodeChunksList.add(chunk);
            }
        }
        return filteredCodeChunksList;
    }


    private boolean isChunkImport(CodeChunk chunk){
        Pattern pattern = Pattern.compile(patternString);
        for(DiffLine diffLine : chunk.getLines()){
            Matcher matcher = pattern.matcher(diffLine.getDiffLine());
            if(!matcher.matches() && !diffLine.getDiffLine().isEmpty()){
                return false;
            }
        }

        if(isOnlyBlankLines(chunk)){
            return false;
        }

        //System.out.println("=============");
        for(DiffLine diffLine : chunk.getLines()){
            //System.out.println(diffLine.getDiffLine());
        }

        return true;
    }


    private boolean isOnlyBlankLines(CodeChunk chunk){

        int blankLinesCounter = 0;

        for(DiffLine diffLine : chunk.getLines()){
            if(diffLine.getDiffLine().isEmpty()){
                blankLinesCounter++;
            }
        }
        if(blankLinesCounter == chunk.getLines().size()){
            return true;
        }
        return false;
    }

}
