package backend.analysis;

import backend.base.gerrit_data.DiffLine;
import backend.base.gerrit_data.CodeChunk;
import com.google.gerrit.extensions.common.DiffInfo;

import java.util.ArrayList;
import java.util.List;

public class DiffLineCounter {

    public List<CodeChunk> countNewDiffLines(DiffInfo diffInfo) {
            List<CodeChunk> codeChunks = new ArrayList<>();
            int counter = 1;
            if(diffInfo != null) {
                for (DiffInfo.ContentEntry contentEntry : diffInfo.content) {
                    List<DiffLine> newDiffLines = new ArrayList<>();
                    List<String> newRevLines = contentEntry.a;
                    List<String> commonLines = contentEntry.ab;
                    if (newRevLines != null) {
                        int beginLine = counter;
                        for (String sb : newRevLines) {
                            newDiffLines.add(new DiffLine(sb, counter, false));
                            counter++;
                        }
                        int endLine = counter;
                        codeChunks.add(new CodeChunk(beginLine, endLine, newDiffLines));
                    } else {
                        if (commonLines != null) {
                            for (String sab : commonLines) {
                                counter++;
                            }
                        }
                    }
                }
            }
            return codeChunks;
        }

    public List<CodeChunk> countOldDiffLines(DiffInfo diffInfo) {
        List<CodeChunk> codeChunks = new ArrayList<>();
        int counter = 1;
        if(diffInfo != null) {
            for (DiffInfo.ContentEntry contentEntry : diffInfo.content) {
                List<DiffLine> oldDiffLines = new ArrayList<>();
                List<String> oldRevLines = contentEntry.b;
                List<String> commonLines = contentEntry.ab;
                if (oldRevLines != null) {
                    int beginLine = counter;
                    for (String sa : oldRevLines) {
                        oldDiffLines.add(new DiffLine(sa, counter, false));
                        counter++;
                    }
                    int endLine = counter;
                    codeChunks.add(new CodeChunk(beginLine, endLine, oldDiffLines));
                } else {
                    if (commonLines != null) {
                        for (String sab : commonLines) {
                            counter++;
                        }
                    }
                }
            }
        }
        return codeChunks;
    }
}
