package backend.analysis;

import backend.base.Change;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

public class CategoryGrouper {

    public Multimap<Change.Category, Change> group(Multimap<String, Change> diffs){
        Multimap<Change.Category, Change> categoryMap = ArrayListMultimap.create();
        for(String key : diffs.keySet()){
            for(Change ch : diffs.get(key)) {
                categoryMap.put(ch.getCategory(), ch);
            }
        }
        return categoryMap;
    }

}
