SKIP_FOLDERS = [
    "/_tests/",
    "/_vendor/",
    "/__pycache__/",
    "/docs/",
    "/examples/",
    "/tools/",
    "/vendored/",
    "/qt_resources/",
]
SKIP_FILES = [
    'napari/_lazy.py',
    'napari/_qt/widgets/qt_theme_sample.py',
    'napari/_version.py',
    'napari/__main__.py',
    'napari/conftest.py',
    'napari/utils/_dtype.py',
    'napari/utils/_testsupport.py',
    'napari/utils/shortcuts.py',
    'napari/utils/stubgen.py',
]
SKIP_WORDS_GLOBAL = [", ", ".", '-', '|', '_', ':', '[', ']', 'napari']
SKIP_WORDS = {
    'napari/__init__.py': [
        '1',
        'SPARSE_AUTO_DENSIFY',
        'not-installed',
        '_event_loop',
        'plugins.io',
        'utils.notifications',
        'view_layers',
        'viewer',
    ],
    'napari/_event_loop.py': [],
    'napari/_qt/__init__.py': [
        '5.12.3',
        'No Qt bindings could be found',
        'PySide2',
        'QT_PLUGIN_PATH',
        'Qt',
        'plugins',
    ],
    'napari/_qt/_constants.py': [],
    'napari/_qt/containers/__init__.py': [],
    'napari/_qt/containers/_base_item_model.py': ['ItemType', '_root'],
    'napari/_qt/containers/_base_item_view.py': ['ItemType'],
    'napari/_qt/containers/_factory.py': [],
    'napari/_qt/containers/_layer_delegate.py': [
        'dark',
        'folder',
        'folder-open',
        'is_group',
        'light',
        'new_{layer._type_string}',
    ],
    'napari/_qt/containers/qt_layer_list.py': [],
    'napari/_qt/containers/qt_layer_model.py': [
        'index',
        'name',
        'thumbnail',
        'visible',
    ],
    'napari/_qt/containers/qt_list_model.py': [
        'ItemType',
        'QMimeData',
        'application/x-list-index',
        'dropMimeData: indices {moving_indices} ➡ {destRow}',
        'text/plain',
    ],
    'napari/_qt/containers/qt_list_view.py': ['ItemType'],
    'napari/_qt/containers/qt_tree_model.py': [
        'NodeMimeData',
        'NodeType',
        'application/x-tree-node',
        'dropMimeData: indices {moving_indices} ➡ {dest_idx}',
        'text/plain',
    ],
    'napari/_qt/containers/qt_tree_view.py': ['NodeType'],
    'napari/_qt/dialogs/__init__.py': [],
    'napari/_qt/dialogs/preferences_dialog.py': [
        'NapariConfig',
        'call_order',
        'highlight',
        'highlight_thickness',
        'json_schema',
        'model',
        'plugins',
        'properties',
        'title',
        'ui:widget',
        '$ref',
        '/',
        'allOf',
        'async_',
        'definitions',
        'enum',
        'experimental',
        'octree',
        'section',
        'string',
        'type',
    ],
    'napari/_qt/dialogs/qt_about.py': ['QtAbout', 'QtCopyToClipboardButton'],
    'napari/_qt/dialogs/qt_about_key_bindings.py': [
        'secondary',
        '{layer.__name__} layer',
    ],
    'napari/_qt/dialogs/qt_modal.py': [
        'QtModalPopup',
        'QtPopupFrame',
        '`position` argument must have length 4',
        'bottom',
        'left',
        'right',
        'screenAt',
        'top',
    ],
    'napari/_qt/dialogs/qt_notification.py': [
        '\nDebugging finished.  Napari active again.',
        '0',
        "Entering debugger. Type 'q' to return to napari.\n",
        'False',
        'NAPARI_CATCH_ERRORS',
        'QPushButton{',
        'WARNING',
        'close_button',
        'expand_button',
        'expanded',
        'font-size: 11px;',
        'min-height: 18px; border-radius: 0;}',
        'padding: 4px 12px 4px 12px; ',
        'severity_icon',
        'source_label',
        '_dispatcher',
    ],
    'napari/_qt/dialogs/qt_plugin_dialog.py': [
        '--no-warn-script-location',
        '--prefix',
        '--upgrade',
        '-m',
        '-y',
        'PATH',
        'PYTHONPATH',
        'UNKNOWN',
        '__main__',
        'author',
        'error_label',
        'license',
        'linux',
        'loading.gif',
        'napari_plugin_engine',
        'outdated',
        'pip',
        'pip_install_status',
        'remove_button',
        'small_text',
        'summary',
        'uninstall',
        'url',
        'version',
        'warning_icon',
        '{package_name} {version}',
    ],
    'napari/_qt/dialogs/qt_plugin_report.py': [
        '\n\n```\n{err}\n```\n</details>',
        '<!--Provide detail on the error here-->\n\n\n\n',
        '</span><a href="{url}" style="color:#999">{url}</a>',
        '<details>\n<summary>Traceback from napari</summary>',
        '<span style="color:#999;">plugin home page:&nbsp;&nbsp;',
        'QtCopyToClipboardButton',
        'github.com',
        'pluginInfo',
        'url',
        '{meta.get("url")}/issues/new?&body={err}',
    ],
    'napari/_qt/dialogs/screenshot_dialog.py': ['.png'],
    'napari/_qt/experimental/__init__.py': [],
    'napari/_qt/experimental/qt_chunk_receiver.py': [],
    'napari/_qt/experimental/qt_poll.py': [],
    'napari/_qt/layer_controls/__init__.py': [],
    'napari/_qt/layer_controls/qt_colormap_combobox.py': [],
    'napari/_qt/layer_controls/qt_image_controls.py': ['RGB', 'rgb'],
    'napari/_qt/layer_controls/qt_image_controls_base.py': [
        'colorbar',
        'colormapComboBox',
        'contrast_limits',
        'contrast_limits_range',
        'full range',
        'full_clim_range_button',
        'reset',
        'reset_clims_button',
        'top',
        '{attr}_range',
    ],
    'napari/_qt/layer_controls/qt_labels_controls.py': [
        'Alt',
        'Control',
        'erase',
        'fill',
        'fill_button',
        'paint',
        'paint_button',
        'pick_button',
        'picker',
        'shuffle',
        'zoom',
        'napari:activate_fill_mode',
        'napari:activate_label_erase_mode',
        'napari:activate_label_pan_zoom_mode',
        'napari:activate_label_picker_mode',
        'napari:activate_paint_mode',
    ],
    'napari/_qt/layer_controls/qt_layer_controls_base.py': ['close', 'layer'],
    'napari/_qt/layer_controls/qt_layer_controls_container.py': ['emphasized'],
    'napari/_qt/layer_controls/qt_points_controls.py': [
        'Backspace',
        'add_points',
        'addition_button',
        'delete_button',
        'delete_shape',
        'pan_zoom',
        'select_button',
        'select_points',
        'napari:activate_points_add_mode',
        'napari:activate_points_select_mode',
    ],
    'napari/_qt/layer_controls/qt_shapes_controls.py': [
        'Backspace',
        'delete_button',
        'delete_shape',
        'direct',
        'direct_button',
        'ellipse',
        'ellipse_button',
        'line',
        'line_button',
        'move_back',
        'move_back_button',
        'move_front',
        'move_front_button',
        'path',
        'path_button',
        'polygon',
        'polygon_button',
        'rectangle',
        'rectangle_button',
        'select',
        'select_button',
        'vertex_insert',
        'vertex_insert_button',
        'vertex_remove',
        'vertex_remove_button',
        'zoom',
        'activate_add_ellipse_mode',
        'activate_add_line_mode',
        'activate_add_path_mode',
        'activate_add_polygon_mode',
        'activate_add_rectangle_mode',
        'activate_direct_mode',
        'activate_select_mode',
        'activate_vertex_insert_mode',
        'activate_vertex_remove_mode',
        'napari:',
        'napari:activate_shape_pan_zoom_mode',
    ],
    'napari/_qt/layer_controls/qt_surface_controls.py': [],
    'napari/_qt/layer_controls/qt_tracks_controls.py': [],
    'napari/_qt/layer_controls/qt_vectors_controls.py': [
        'colormap',
        'cycle',
        'direct',
    ],
    'napari/_qt/perf/__init__.py': [],
    'napari/_qt/perf/qt_debug_menu.py': ['.json', 'Alt+T', 'Shift+Alt+T'],
    'napari/_qt/perf/qt_event_tracing.py': [
        'qt_event',
        '{event_str}:{object_name}',
    ],
    'napari/_qt/perf/qt_performance.py': [
        '%vms',
        '1',
        '10',
        '100',
        '15',
        '20',
        '200',
        '30',
        '40',
        '5',
        '50',
        'UpdateRequest',
    ],
    'napari/_qt/qprogress.py': [
        'self',
        'gui',
    ],
    'napari/_qt/qt_event_loop.py': [
        '..',
        '_dispatcher',
        'IPython',
        'app_id',
        'app_name',
        'app_version',
        'frozen',
        'gui_qt',
        'icon',
        'ipy_interactive',
        'logo.png',
        'napari',
        'napari.napari.viewer.{__version__}',
        'napari.org',
        'nt',
        'org_domain',
        'org_name',
        'qt',
        'resources',
        'run',
    ],
    'napari/_qt/qt_main_window.py': [
        'Alt+S',
        'Alt+Shift+S',
        'Ctrl+/',
        'Ctrl+Alt+/',
        'Ctrl+Alt+O',
        'Ctrl+Alt+P',
        'Ctrl+F',
        'Ctrl+M',
        'Ctrl+O',
        'Ctrl+Q',
        'Ctrl+S',
        'Ctrl+Shift+O',
        'Ctrl+Shift+P',
        'Ctrl+Shift+S',
        'Ctrl+W',
        '_',
        '_QtMainWindow',
        '_qt_window',
        'all',
        'auto_call',
        'bottom',
        'call_button',
        'display_name',
        'dock',
        'layout',
        'napari',
        'napari.viewer.Viewer',
        'napari_viewer',
        'reset_choices',
        'right',
        'run',
        'vertical',
        'plugins',
        '_magic_widget',
        'left',
        'ignore',
        '_parent',
        'name',
    ],
    'napari/_qt/qt_viewer.py': [
        'activityDock',
        'Show/Hide IPython console',
        'napari:toggle_console_visibility',
        'napari:toggle_console_visibility',
        '\nor use "Save all layers..."',
        ' "pip install napari_console"',
        'Ctrl+Shift+P',
        'Please select one or more layers to save,',
        'bottom',
        'canvas',
        'circle',
        'cross',
        'expanded',
        'forbidden',
        'layerList',
        'left',
        'napari-console not found. It can be installed with',
        'pointing',
        'right',
        'square',
        'standard',
        'top',
        '*',
        ';;',
        '_console',
        'action_manager',
        'image',
        'napari',
        'points',
    ],
    'napari/_qt/qthreading.py': [
        'WorkerBase',
        '_connect',
        '_ignore_errors',
        '_start_thread',
        '_worker_class',
        'always',
        'errored',
    ],
    'napari/_qt/utils.py': [
        '!QBYTE_',
        'PySide2',
        'native',
        'pyqtRemoveInputHook',
        'pyqtRestoreInputHook',
        'int',
    ],
    'napari/_qt/widgets/__init__.py': [],
    'napari/_qt/widgets/qt_color_swatch.py': [
        '#colorSwatch {background-color: ',
        ';}',
        'CustomColorDialog',
        'QColorSwatchEdit',
        'QtColorPopup',
        '\\(?([\\d.]+),\\s*([\\d.]+),\\s*([\\d.]+),?\\s*([\\d.]+)?\\)?',
        'colorSwatch',
        'int',
        'rgba({",".join(map(lambda x: str(int(x*255)), self._color))})',
        'transparent',
    ],
    'napari/_qt/widgets/qt_dict_table.py': [
        '\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)',
        '^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$',
        'https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}',
        'mailto:{text}',
    ],
    'napari/_qt/widgets/qt_dims.py': [
        '8',
        'axis_label',
        'last_used',
        'slice_label',
    ],
    'napari/_qt/widgets/qt_dims_slider.py': [
        'False',
        'True',
        '_',
        'axis_label',
        'fpsSpinBox',
        'frame_requested',
        'playDirectionCheckBox',
        'playing',
        'reverse',
        'setStepType',
        'slice_label',
        'slice_label_sep',
    ],
    'napari/_qt/widgets/qt_highlight_preview.py': [
        'border: 1px solid white;',
        'px',
        'white',
    ],
    'napari/_qt/widgets/qt_large_int_spinbox.py': [
        'horizontalAdvance',
    ],
    'napari/_qt/widgets/qt_mode_buttons.py': ['mode'],
    'napari/_qt/widgets/qt_plugin_sorter.py': [
        ':[a-z]+:`([^`]+)`',
        '<',
        '<a href="{_link.rstrip(">")}">{_text.strip()}</a>',
        '<br>',
        '<code>\\1</code>',
        '<em>\\1</em>',
        '<strong>\\1</strong>',
        'Parameters',
        '\\*([^\\*]+)\\*',
        '\\*\\*([^\\*]+)\\*\\*',
        '`([^`]+)`_',
        '``([^`]+)``',
        '``{_text}``',
        'enabled',
        'firstresult',
        'h3',
        'info_icon',
        'napari_',
        'small_text',
        '~',
    ],
    'napari/_qt/widgets/qt_range_slider_popup.py': [
        '8',
        'display_max',
        'display_min',
        'slice_label',
        '{:.{}f}',
    ],
    'napari/_qt/widgets/qt_scrollbar.py': [],
    'napari/_qt/widgets/qt_size_preview.py': [
        'm',
        'px',
        'horizontalAdvance',
    ],
    'napari/_qt/widgets/qt_splash_screen.py': [],
    'napari/_qt/widgets/qt_viewer_buttons.py': [
        'viewer',
        'napari:roll_axes',
        'napari:transpose_axes',
        'napari:reset_view',
        'napari:toggle_grid',
        'napari:toggle_ndisplay',
        'perspective',
        'Control-Backspace',
        'console',
        'enabled',
        'expanded',
        'grid_view_button',
        'home',
        'mode',
        'ndisplay',
        'ndisplay_button',
        'new_labels',
        'new_points',
        'new_shapes',
        'roll',
        'transpose',
        'layer',
    ],
    'napari/_qt/widgets/qt_viewer_dock_widget.py': [
        'QTitleBarCloseButton',
        'QTitleBarFloatButton',
        'QTitleBarHideButton',
        'QtCustomTitleBar',
        'QtCustomTitleBarLine',
        'bottom',
        'dockWidgetArea',
        'left',
        'right',
        'addStretch',
        'top',
        'vertical',
        '{shortcut}',
    ],
    'napari/_qt/widgets/qt_welcome.py': [
        'Ctrl+Alt+/',
        'Ctrl+O',
        'QEvent',
        'drag',
        'logo_silhouette',
    ],
    'napari/_vispy/__init__.py': ['vispy'],
    'napari/_vispy/_text_utils.py': [],
    'napari/_vispy/_vispy_tracks_shader.py': [
        '\n        varying vec4 v_track_color;\n        void apply_track_shading() {\n\n            // if the alpha is below the threshold, discard the fragment\n            if( v_track_color.a <= 0.0 ) {\n                discard;\n            }\n\n            // interpolate\n            gl_FragColor.a = clamp(v_track_color.a * gl_FragColor.a, 0.0, 1.0);\n        }\n    ',
        '\n        varying vec4 v_track_color;\n        void apply_track_shading() {\n\n            float alpha;\n\n            if ($a_vertex_time > $current_time) {\n                // this is a hack to minimize the frag shader rendering ahead\n                // of the current time point due to interpolation\n                if ($a_vertex_time <= $current_time + 1){\n                    alpha = -100.;\n                } else {\n                    alpha = 0.;\n                }\n            } else {\n                // fade the track into the temporal distance, scaled by the\n                // maximum tail length from the gui\n                float fade = ($current_time - $a_vertex_time) / $tail_length;\n                alpha = clamp(1.0-fade, 0.0, 1.0);\n            }\n\n            // when use_fade is disabled, the entire track is visible\n            if ($use_fade == 0) {\n                alpha = 1.0;\n            }\n\n            // set the vertex alpha according to the fade\n            v_track_color.a = alpha;\n        }\n    ',
        'a_vertex_time',
        'current_time',
        'tail_length',
        'use_fade',
    ],
    'napari/_vispy/experimental/__init__.py': [],
    'napari/_vispy/experimental/texture_atlas.py': [],
    'napari/_vispy/experimental/tile_grid.py': ['segments'],
    'napari/_vispy/experimental/tile_set.py': [],
    'napari/_vispy/experimental/tiled_image_visual.py': [
        'auto',
        'bilinear',
        'color_transform',
        'linear',
        'nearest',
        'texture',
        'texture2D_LUT',
        'texture_lut',
    ],
    'napari/_vispy/experimental/vispy_tiled_image_layer.py': [
        '_update_drawn_chunks',
        'napari.octree.visual',
        'tiles: %d -> %d create: %d delete: %d time: %.3fms',
    ],
    'napari/_vispy/image.py': [],
    'napari/_vispy/markers.py': ['a_position'],
    'napari/_vispy/quaternion.py': [],
    'napari/_vispy/utils.py': [],
    'napari/_vispy/utils_gl.py': [],
    'napari/_vispy/vispy_axes_visual.py': [
        '1',
        'canvas',
        'center',
        'gl',
        'segments',
    ],
    'napari/_vispy/vispy_base_layer.py': ['data2world'],
    'napari/_vispy/vispy_camera.py': ['first'],
    'napari/_vispy/vispy_canvas.py': ['canvas', 'lequal', 'mouse_wheel'],
    'napari/_vispy/vispy_image_layer.py': ['auto', 'tile2data'],
    'napari/_vispy/vispy_points_layer.py': ['center', 'transparent'],
    'napari/_vispy/vispy_scale_bar_visual.py': [
        'canvas',
        'center',
        'gl',
        'segments',
        '1px',
        '{new_dim:~}',
    ],
    'napari/_vispy/vispy_shapes_layer.py': ['center', 'constant', 'square'],
    'napari/_vispy/vispy_surface_layer.py': [
        'texture2D_LUT',
        'texture_lut',
        'none',
    ],
    'napari/_vispy/vispy_text_visual.py': [
        'bottom',
        'center',
        'left',
        'right',
        'top',
    ],
    'napari/_vispy/vispy_tracks_layer.py': ['white'],
    'napari/_vispy/vispy_vectors_layer.py': ['constant'],
    'napari/_vispy/vispy_welcome_visual.py': [
        '..',
        'background',
        'center',
        'gpu',
        'grays',
        'left',
        'logo.png',
        'primary',
        'resources',
    ],
    'napari/_vispy/volume.py': [
        '\n        // Apply colormap on mean value\n        gl_FragColor = applyColormap(meanval);\n        ',
        '\n        // Incremental mean value used for numerical stability\n        n += 1; // Increment the counter\n        prev_mean = meanval; // Update the mean for previous iteration\n        meanval = prev_mean + (val - prev_mean) / n; // Calculate the mean\n        ',
        '\n        // Refine search for min value\n        loc = start_loc + step * (float(mini) - 0.5);\n        for (int i=0; i<10; i++) {\n            minval = min(minval, $sample(u_volumetex, loc).g);\n            loc += step * 0.1;\n        }\n        gl_FragColor = applyColormap(minval);\n        ',
        '\n        float maxval = -99999.0; // The maximum encountered value\n        float sumval = 0.0; // The sum of the encountered values\n        float scaled = 0.0; // The scaled value\n        int maxi = 0;  // Where the maximum value was encountered\n        vec3 maxloc = vec3(0.0);  // Location where the maximum value was encountered\n        ',
        '\n        float minval = 99999.0; // The minimum encountered value\n        int mini = 0;  // Where the minimum value was encountered\n        ',
        '\n        float n = 0; // Counter for encountered values\n        float meanval = 0.0; // The mean of encountered values\n        float prev_mean = 0.0; // Variable to store the previous incremental mean\n        ',
        '\n        gl_FragColor = applyColormap(maxval);\n        ',
        '\n        if( val < minval ) {\n            minval = val;\n            mini = iter;\n        }\n        ',
        '\n        sumval = sumval + val;\n        scaled = val * exp(-u_attenuation * (sumval - 1) / u_relative_step_size);\n        if( scaled > maxval ) {\n            maxval = scaled;\n            maxi = iter;\n            maxloc = loc;\n        }\n        ',
        'attenuated_mip',
        'average',
        'cmap',
        'minip',
        'texture2D_LUT',
        'texture_lut',
        'u_attenuation',
        'u_threshold',
    ],
    'napari/benchmarks/__init__.py': [],
    'napari/benchmarks/benchmark_image_layer.py': [],
    'napari/benchmarks/benchmark_labels_layer.py': ['circle', 'square'],
    'napari/benchmarks/benchmark_points_layer.py': [],
    'napari/benchmarks/benchmark_qt_viewer.py': [],
    'napari/benchmarks/benchmark_qt_viewer_image.py': [],
    'napari/benchmarks/benchmark_qt_viewer_labels.py': [
        'Event',
        'is_dragging',
        'paint',
    ],
    'napari/benchmarks/benchmark_shapes_layer.py': [
        'Event',
        'is_dragging',
        'modifiers',
        'mouse_press',
        'mouse_release',
        'n_shapes',
        'polygon',
        'position',
        'select',
        'type',
    ],
    'napari/benchmarks/benchmark_surface_layer.py': [],
    'napari/benchmarks/benchmark_vectors_layer.py': [],
    'napari/components/__init__.py': [],
    'napari/components/_viewer_constants.py': [
        'bottom_left',
        'bottom_right',
        'circle',
        'cross',
        'forbidden',
        'pointing',
        'square',
        'standard',
        'top_left',
        'top_right',
        'top_center',
        'bottom_center',
    ],
    'napari/components/_viewer_key_bindings.py': [
        'napari:',
    ],
    'napari/components/_viewer_mouse_bindings.py': ['Control'],
    'napari/components/axes.py': [],
    'napari/components/camera.py': ['angles', 'center'],
    'napari/components/cursor.py': [],
    'napari/components/dims.py': [
        'axis_labels',
        'current_step',
        'ndim',
        'order',
        'range',
    ],
    'napari/components/experimental/__init__.py': [],
    'napari/components/experimental/chunk/__init__.py': [],
    'napari/components/experimental/chunk/_cache.py': [
        'ChunkCache.add_chunk: cache is disabled',
        'ChunkCache.get_chunk: disabled',
        'add_chunk: %s',
        'found',
        'get_chunk: %s %s',
        'napari.loader.cache',
        'not found',
    ],
    'napari/components/experimental/chunk/_commands/__init__.py': [],
    'napari/components/experimental/chunk/_commands/_loader.py': [
        '\n{highlight("Available Commands:")}\nloader.help\nloader.cache\nloader.config\nloader.layers\nloader.levels(index)\nloader.loads(index)\nloader.set_default(index)\nloader.set_sync(index)\nloader.set_async(index)\n',
        '--',
        '???',
        'AVG (ms)',
        'CHUNKS',
        'DATA',
        'DURATION (ms)',
        'ID',
        'INDEX',
        'LAYER',
        'LEVEL',
        'LEVELS',
        'LOADS',
        'Layer ID',
        'Layer index {layer_index} has no LayerInfo.',
        'Layer index {layer_index} is invalid.',
        'Levels',
        'MBIT/s',
        'MODE',
        'Mbit/s',
        'NAME',
        'NONE',
        'Name',
        'SHAPE',
        'SIZE',
        'Shape',
        'TOTAL',
        'TYPE',
        'align',
        'async',
        'auto',
        'auto_sync_ms',
        'currsize',
        'delay_queue_ms',
        'enabled',
        'left',
        'loader',
        'log_path',
        'maxsize',
        'name',
        'num_workers',
        'sync',
        'synchronous',
        'use_processes',
        '{data[0].shape}',
        '{load.duration_ms:.1f}',
        '{load.mbits:.1f}',
        '{stats.mbits:.1f}',
        '{stats.window_ms.average:.1f}',
    ],
    'napari/components/experimental/chunk/_commands/_tables.py': [
        'align',
        'left',
        'name',
        'right',
        'width',
        '{heading:>{heading_width}}',
        '{highlight(aligned)}: {value}',
        '{value:<{width}}',
        '{value_str:<{width}}',
        '{value_str:>{width}}',
    ],
    'napari/components/experimental/chunk/_commands/_utils.py': [
        '\x1b{_code(color)}{string}\x1b[0m',
        '[{num_str}m',
        'black',
        'blue',
        'cyan',
        'green',
        'magenta',
        'red',
        'white',
        'yellow',
    ],
    'napari/components/experimental/chunk/_delay_queue.py': [
        'DelayQueue.add: %s',
        'DelayQueue.submit: %s',
        'delay_queue',
        'napari.loader',
    ],
    'napari/components/experimental/chunk/_info.py': [
        'LayerInfo.get_layer: layer %d was deleted',
        'async',
        'load_chunk',
        'load_ms',
        'mixed',
        'napari.loader',
        'num_bytes',
        'sync',
        'time',
    ],
    'napari/components/experimental/chunk/_loader.py': [
        '\nThere is one global chunk_loader instance to handle async loading for all\nViewer instances. There are two main reasons we do this instead of one\nChunkLoader per Viewer:\n\n1. We size the ChunkCache as a fraction of RAM, so having more than one\n   cache would use too much RAM.\n\n2. We might size the thread pool for optimal performance, and having\n   multiple pools would result in more workers than we want.\n\nThink of the ChunkLoader as a shared resource like "the filesystem" where\nmultiple clients can be access it at the same time, but it is the interface\nto just one physical resource.\n',
        '%(levelname)s - %(name)s - %(message)s',
        '_done: load=%.3fms elapsed=%.3fms %s',
        'auto_sync_ms',
        'enabled',
        'force_synchronous',
        'loader_defaults',
        'log_path',
        'napari.loader',
        'napari.octree',
        'octree',
        'wait_for_data_id: no futures for data_id=%d',
        'wait_for_data_id: waiting on %d futures for data_id=%d',
    ],
    'napari/components/experimental/chunk/_pool.py': [
        'Process pool num_workers=%d',
        'Thread pool num_workers=%d',
        '_submit_async: %s elapsed=%.3fms num_futures=%d',
        'cancel_requests: %d -> %d futures (cancelled %d)',
        'delay_queue_ms',
        'napari.loader',
        'num_workers',
        'use_processes',
    ],
    'napari/components/experimental/chunk/_pool_group.py': [
        'loader_defaults',
        'loaders',
        'octree',
    ],
    'napari/components/experimental/chunk/_request.py': [
        'image',
        'napari.loader',
        'thumbnail_source',
    ],
    'napari/components/experimental/chunk/_utils.py': ['EMPTY', 'dask'],
    'napari/components/experimental/commands.py': [
        '\n{highlight("Available Commands:")}\nexperimental.cmds.loader\n',
        'Available Commands:\nexperimental.cmds.loader',
    ],
    'napari/components/experimental/monitor/__init__.py': [],
    'napari/components/experimental/monitor/_api.py': [
        '127.0.0.1',
        'Ignore message that was not a dict: %s',
        'client_data',
        'client_messages',
        'napari',
        'napari.monitor',
        'napari_data',
        'napari_messages',
        'napari_shutdown',
    ],
    'napari/components/experimental/monitor/_monitor.py': [
        '0',
        'Monitor: not starting, disabled',
        'Monitor: not starting, no usable config file',
        'Monitor: not starting, requires Python 3.9 or newer',
        'NAPARI_MON',
        'Writing to log path %s',
        'log_path',
        'napari.monitor',
    ],
    'napari/components/experimental/monitor/_service.py': [
        '<number>',
        'Listening on port %s',
        'MonitorService.stop',
        'NAPARI_MON_CLIENT',
        'Started %d clients.',
        'Starting %d clients...',
        'Starting client %s',
        'clients',
        'napari.monitor',
        'server_port',
    ],
    'napari/components/experimental/monitor/_utils.py': ['ascii'],
    'napari/components/experimental/remote/__init__.py': [],
    'napari/components/experimental/remote/_commands.py': [
        'Calling RemoteCommands.%s(%s)',
        'RemoteCommands.%s does not exist.',
        'RemoveCommands._process_command: %s',
        'napari.monitor',
    ],
    'napari/components/experimental/remote/_manager.py': ['napari.monitor'],
    'napari/components/experimental/remote/_messages.py': [
        'delta_ms',
        'frame_time',
        'layers',
        'napari.monitor',
        'poll',
        'time',
    ],
    'napari/components/grid.py': [],
    'napari/components/layerlist.py': ['Extent', 'data world step', 'ignore'],
    'napari/components/scale_bar.py': [],
    'napari/components/text_overlay.py': ['color'],
    'napari/components/viewer_model.py': [
        'Ready',
        '_mouse_drag_gen',
        '_mouse_wheel_gen',
        '_persisted_mouse_event',
        'active_layer',
        'add_',
        'affine',
        'attenuation',
        'axis_labels',
        'blending',
        'colormap',
        'contrast_limits',
        'dark',
        'data',
        'exclude',
        'gamma',
        'gray',
        'ignore',
        'int',
        'interpolation',
        'iso_threshold',
        'keymap',
        'keyword argument ',
        'kwargs',
        'layer',
        'layers',
        'metadata',
        'mip',
        'mouse_drag_callbacks',
        'mouse_move_callbacks',
        'mouse_wheel_callbacks',
        'multiscale',
        'name',
        'napari',
        'napari.Viewer: {self.title}',
        'ndisplay',
        'nearest',
        'opacity',
        'order',
        'rendering',
        'rgb',
        'rotate',
        'scale',
        'self',
        'shear',
        'standard',
        'theme',
        'translate',
        'translucent',
        'unexpected keyword argument',
        'visible',
        'ViewerModel',
        'valid_add_kwargs',
    ],
    'napari/experimental/__init__.py': [],
    'napari/layers/__init__.py': [],
    'napari/layers/_source.py': ['_LAYER_SOURCE'],
    'napari/layers/base/__init__.py': [],
    'napari/layers/base/_base_constants.py': [],
    'napari/layers/base/base.py': [
        '<{cls.__name__} layer {repr(self.name)} at {hex(id(self))}>',
        'Extent',
        'Ready',
        '_round_index',
        'blending',
        'constant',
        'data',
        'data world step',
        'data2world',
        'deselect',
        'ignore',
        'metadata',
        'name',
        'opacity',
        'rotate',
        'scale',
        'select',
        'shear',
        'standard',
        'tile2data',
        'translate',
        'translucent',
        'visible',
        'world2grid',
        '{cls.__name__}',
    ],
    'napari/layers/image/__init__.py': [],
    'napari/layers/image/_image_constants.py': [],
    'napari/layers/image/_image_loader.py': [],
    'napari/layers/image/_image_slice.py': [
        'ImageSlice.__init__',
        'f',
        'napari.loader',
    ],
    'napari/layers/image/_image_slice_data.py': [],
    'napari/layers/image/_image_utils.py': [
        'dtype',
        'image',
        'labels',
        'ndim',
    ],
    'napari/layers/image/_image_view.py': [],
    'napari/layers/image/experimental/__init__.py': [],
    'napari/layers/image/experimental/_chunk_set.py': [],
    'napari/layers/image/experimental/_chunked_image_loader.py': [
        'ChunkedImageLoader.load',
        'ChunkedImageLoader.match: accept %s',
        'ChunkedImageLoader.match: reject %s',
        'napari.loader',
    ],
    'napari/layers/image/experimental/_chunked_slice_data.py': [
        'image',
        'napari.loader',
        'thumbnail_slice',
        'thumbnail_source',
    ],
    'napari/layers/image/experimental/_image_location.py': [
        'location=({self.data_id}, {self.data_level}, {self.indices}) '
    ],
    'napari/layers/image/experimental/_octree_loader.py': [
        '_cancel_load: Chunk did not exist %s',
        'data',
        'get_drawable_chunks: Starting with draw_set=%d ideal_chunks=%d',
        'napari.loader.futures',
        'napari.octree.loader',
    ],
    'napari/layers/image/experimental/_octree_slice.py': [
        'data',
        'napari.octree.slice',
        'on_chunk_loaded: adding %s',
        'on_chunk_loaded: missing OctreeChunk: %s',
        'on_chunk_loaded: wrong slice_id: %s',
    ],
    'napari/layers/image/experimental/octree.py': [
        'Created %d additional levels in %.3fms',
        'Multiscale data has %d levels.',
        'Octree now has %d total levels:',
        '_create_extra_levels',
        'napari.octree',
        'size={level.size} shape={level.shape} base level',
        'size={level.size} shape={level.shape} downscale={downscale}',
    ],
    'napari/layers/image/experimental/octree_chunk.py': [
        '%s has %d chunks at %s',
        '%s has %d chunks:',
        'Chunk %d %s in_memory=%d loading=%d',
        'location=({self.level_index}, {self.row}, {self.col}) ',
        'napari.octree',
        '{self.location}',
    ],
    'napari/layers/image/experimental/octree_image.py': [
        'get_drawable_chunks: Intersection is empty',
        'get_drawable_chunks: No slice or view',
        'napari.octree.image',
        'on_chunk_loaded calling loaded()',
        'on_chunk_loaded: load=%.3fms elapsed=%.3fms location = %s',
        'tile_config',
        'tile_state',
    ],
    'napari/layers/image/experimental/octree_intersection.py': [
        'OctreeView',
        'base_shape',
        'corners',
        'image_shape',
        'level_index',
        'seen',
        'shape_in_tiles',
        'tile_size',
    ],
    'napari/layers/image/experimental/octree_level.py': [
        '({dim[0]}, {dim[1]}) = {intword(dim[0] * dim[1])}',
        'Level %d: %s pixels -> %s tiles',
        'napari.octree',
    ],
    'napari/layers/image/experimental/octree_tile_builder.py': [
        'Downsampling levels to a single tile...',
        'Level %d downsampled %s in %.3fms',
        'downsampling',
        'napari.octree',
        'nearest',
    ],
    'napari/layers/image/experimental/octree_util.py': ['octree', 'tile_size'],
    'napari/layers/image/image.py': [
        'Labels',
        'attenuation',
        'colormap',
        'contrast_limits',
        'data',
        'gamma',
        'gray',
        'ignore',
        'interpolation',
        'iso_threshold',
        'mip',
        'multiscale',
        'nearest',
        'rendering',
        'rgb',
        'tile2data',
        'translucent',
        'ndim',
    ],
    'napari/layers/intensity_mixin.py': ['_contrast_limits'],
    'napari/layers/labels/__init__.py': [],
    'napari/layers/labels/_labels_constants.py': [
        'backspace',
        'darwin',
        'delete',
    ],
    'napari/layers/labels/_labels_key_bindings.py': [
        'Alt',
        'Control',
        'Control-Shift-Z',
        'Control-Z',
        'D',
        'E',
        'F',
        'I',
        'L',
        'M',
        'P',
        'Shift',
        'Space',
        'Z',
    ],
    'napari/layers/labels/_labels_mouse_bindings.py': ['mouse_move'],
    'napari/layers/labels/_labels_utils.py': [
        'dtype',
    ],
    'napari/layers/labels/labels.py': [
        ', {k}: {v[idx]}',
        'black',
        'circle',
        'color',
        'cross',
        'data',
        'index',
        'multiscale',
        'nearest',
        'num_colors',
        'properties',
        'seed',
        'square',
        'standard',
        'translucent',
        'transparent',
        'n_dimensional',
    ],
    'napari/layers/points/__init__.py': [],
    'napari/layers/points/_points_constants.py': [
        '*',
        '+',
        '-',
        '->',
        '>',
        '^',
        'o',
        's',
        'tailed_arrow',
        'triangle_down',
        'triangle_up',
        'v',
        '|',
    ],
    'napari/layers/points/_points_key_bindings.py': [
        'A',
        'Backspace',
        'Control-C',
        'Control-V',
        'Delete',
        'P',
        'S',
        'Space',
        'Z',
    ],
    'napari/layers/points/_points_mouse_bindings.py': [
        'Control',
        'Shift',
        'mouse_move',
        'mouse_press',
        'mouse_release',
    ],
    'napari/layers/points/_points_utils.py': [],
    'napari/layers/points/points.py': [
        '_{attribute}',
        'black',
        'current_value',
        'data',
        'edge',
        'edge_color',
        'edge_color_cycle',
        'edge_colormap',
        'edge_contrast_limits',
        'edge_width',
        'face',
        'face_color',
        'face_color_cycle',
        'face_colormap',
        'face_contrast_limits',
        'indices',
        'n_dimensional',
        'n_text',
        'name',
        'ndim',
        'o',
        'pointing',
        'properties',
        'size',
        'standard',
        'symbol',
        'text',
        'translucent',
        'values',
        'viridis',
        'white',
        'DataFrame',
        'property_choices',
    ],
    'napari/layers/shapes/__init__.py': [],
    'napari/layers/shapes/_mesh.py': ['edge', 'face'],
    'napari/layers/shapes/_shape_list.py': [
        'edge',
        'face',
        'int',
        'update_{attribute}_color',
    ],
    'napari/layers/shapes/_shapes_constants.py': [
        'backspace',
        'darwin',
        'delete',
    ],
    'napari/layers/shapes/_shapes_key_bindings.py': [
        'A',
        'Backspace',
        'Control-C',
        'Control-V',
        'D',
        'E',
        'Escape',
        'I',
        'L',
        'P',
        'R',
        'S',
        'Shift',
        'Space',
        'T',
        'X',
        'Z',
    ],
    'napari/layers/shapes/_shapes_models/__init__.py': [],
    'napari/layers/shapes/_shapes_models/_polgyon_base.py': ['int', 'polygon'],
    'napari/layers/shapes/_shapes_models/ellipse.py': ['ellipse', 'int'],
    'napari/layers/shapes/_shapes_models/line.py': ['int', 'line'],
    'napari/layers/shapes/_shapes_models/path.py': ['path'],
    'napari/layers/shapes/_shapes_models/polygon.py': ['polygon'],
    'napari/layers/shapes/_shapes_models/rectangle.py': ['int', 'rectangle'],
    'napari/layers/shapes/_shapes_models/shape.py': ['int', 'rectangle'],
    'napari/layers/shapes/_shapes_mouse_bindings.py': [
        'Shift',
        'ellipse',
        'line',
        'mouse_move',
        'path',
        'rectangle',
    ],
    'napari/layers/shapes/_shapes_utils.py': [
        'int',
        'rectangle',
    ],
    'napari/layers/shapes/shapes.py': [
        '_current_{attribute}_color',
        '_{attribute}_color_cycle',
        '_{attribute}_color_cycle_values',
        '_{attribute}_color_mode',
        '_{attribute}_color_property',
        '_{attribute}_contrast_limits',
        'black',
        'cross',
        'data',
        'edge',
        'edge_color',
        'edge_color_cycle',
        'edge_colormap',
        'edge_contrast_limits',
        'edge_width',
        'face',
        'face_color',
        'face_color_cycle',
        'face_colormap',
        'face_contrast_limits',
        'indices',
        'int',
        'n_text',
        'ndim',
        'opacity',
        'pointing',
        'properties',
        'rectangle',
        'shape_type',
        'standard',
        'text',
        'translucent',
        'viridis',
        'white',
        'z_index',
        '{attribute}_color',
        '{attribute}_color_cycle',
        '{attribute}_color_cycle_map',
        '{attribute}_colormap',
        '{attribute}_contrast_limits',
    ],
    'napari/layers/surface/__init__.py': [],
    'napari/layers/surface/surface.py': [
        'colormap',
        'contrast_limits',
        'data',
        'gamma',
        'gray',
        'int',
        'translucent',
        'flat',
        'shading',
    ],
    'napari/layers/tracks/__init__.py': [],
    'napari/layers/tracks/_track_utils.py': ['ID:{i}', 'track_id'],
    'napari/layers/tracks/tracks.py': [
        'additive',
        'color_by',
        'colormap',
        'colormaps_dict',
        'constant',
        'data',
        'graph',
        'properties',
        'tail_length',
        'tail_width',
        'track_id',
        'turbo',
    ],
    'napari/layers/utils/__init__.py': [],
    'napari/layers/utils/_color_manager_constants.py': [
        'colormap',
        'cycle',
        'direct',
    ],
    'napari/layers/utils/_link_layers.py': [
        'Set {attr!r} on {l1} to that of {l2}',
        '_',
        'data',
        'name',
        'set_{attr}_on_layer_{id(l2)}',
        'status',
        'thumbnail',
    ],
    'napari/layers/utils/_text_constants.py': [],
    'napari/layers/utils/_text_utils.py': [
        ':',
        'bottom',
        'center',
        'left',
        'right',
        'top',
        '{',
        '{(.*?)}',
        '}',
    ],
    'napari/layers/utils/color_manager.py': [
        'categorical_colormap',
        'color',
        'color_mode',
        'color_properties',
        'colors',
        'continuous_colormap',
        'contrast_limits',
        'current_color',
        'current_value',
        'n_colors',
        'name',
        'values',
        'viridis',
        'white',
    ],
    'napari/layers/utils/color_manager_utils.py': [
        'categorical_colormap',
        'color_properties',
        'continuous_colormap',
        'contrast_limits',
        'current_color',
    ],
    'napari/layers/utils/color_transformations.py': [],
    'napari/layers/utils/layer_utils.py': [
        'b',
        'f',
        'index',
        'u',
        'ui',
        'napari:',
    ],
    'napari/layers/utils/stack_utils.py': [
        'additive',
        'affine',
        'blending',
        'colormap',
        'contrast_limits',
        'gray',
        'image',
        'metadata',
        'multiscale',
        'name',
        'rgb',
        'rotate',
        'scale',
        'shear',
        'translate',
        '{name} layer {i}',
    ],
    'napari/layers/utils/text.py': [
        'center',
        'color',
        'cyan',
        'rotation',
        'size',
        'text',
        'translation',
        'translucent',
        'visible',
    ],
    'napari/layers/vectors/__init__.py': [],
    'napari/layers/vectors/_vector_utils.py': [],
    'napari/layers/vectors/vectors.py': [
        'current_value',
        'data',
        'edge_color',
        'edge_color_cycle',
        'edge_colormap',
        'edge_contrast_limits',
        'edge_width',
        'int',
        'length',
        'name',
        'properties',
        'red',
        'translucent',
        'values',
        'viridis',
    ],
    'napari/plugins/__init__.py': [
        '{}: {}',
    ],
    'napari/plugins/_builtins.py': [
        '.csv',
        '.tif',
        'axis-',
        'builtins',
        'index',
        'name',
        'napari_write_{layer_type}',
        'properties',
        'rectangle',
        'shape-type',
        'shape_type',
        'vertex-index',
    ],
    'napari/plugins/_plugin_manager.py': [
        '`napari_experimental_provide_dock_widget`',
        '`napari_experimental_provide_function`',
        'builtins',
        'data',
        'display_name',
        'dock',
        'enabled',
        'func',
        'linux',
        'name',
        'napari',
        'napari.plugin',
        'napari_provide_sample_data',
        'plugin',
        'scikit-image',
        'skimage',
    ],
    'napari/plugins/_skimage_data.py': [
        'WGA',
        'actin',
        'astronaut',
        'binary_blobs',
        'binary_blobs_3D',
        'blue',
        'brain',
        'brick',
        'camera',
        'cat',
        'cell',
        'cells3d',
        'channel_axis',
        'checkerboard',
        'clock',
        'coffee',
        'coins',
        'colormap',
        'colorwheel',
        'contrast_limits',
        'data',
        'display_name',
        'eagle',
        'grass',
        'gravel',
        'gray',
        'green',
        'horse',
        'hubble_deep_field',
        'human_mitosis',
        'immunohistochemistry',
        'kidney',
        'length',
        'lfw_subset',
        'lily',
        'lily-B',
        'lily-G',
        'lily-R',
        'lily-W',
        'membrane',
        'microaneurysms',
        'moon',
        'n_dim',
        'name',
        'nuclei',
        'page',
        'red',
        'retina',
        'rocket',
        'shepp_logan_phantom',
        'skin',
        'text',
        'volume_fraction',
    ],
    'napari/plugins/exceptions.py': [
        '<br>',
        '=',
        'ERROR #{n + 1}:  {str(err)} {"-" * _pad}',
        '{"module": >16}: {err0.plugin}',
        '{"napari version": >16}: {__version__}',
        '{"plugin package": >16}: {package_meta["package"]}',
        '{"version": >16}: {package_meta["version"]}',
    ],
    'napari/plugins/hook_specifications.py': [],
    'napari/plugins/io.py': [
        "({len(errors)}) error{'s' if len(errors) > 1 else ''} ",
        'See full error logs in "Plugins → Plugin Errors..."',
        'napari_write_{layer._type_string}',
        "occurred in plugins: {', '.join(names)}. ",
    ],
    'napari/plugins/pypi.py': [
        '-',
        '<a href="/simple/(.+)">({prefix}.*)</a>',
        '>{name}-(.+).tar',
        'Development Status :: 1',
        'Framework :: napari',
        'UNKNOWN',
        '[-_.]+',
        'author',
        'class="package-snippet__name">(.+)</span>',
        'classifiers',
        'entry_points\\s?=\\s?([^}]*napari.plugin[^}]*)}',
        'home_page',
        'https://pypi.org/pypi/{name}/json',
        'https://pypi.org/search/?c={parse.quote_plus(classifier)}&page=',
        'https://pypi.org/simple/',
        'info',
        'license',
        'name',
        'napari-plugin-engine',
        'setup\\s?\\(.*name\\s?=\\s?[\'\\"]([^\'\\"]+)[\'\\"]',
        'summary',
        'version',
        '{url}{page}',
    ],
    'napari/qt/__init__.py': ['ndisplay', 'ndisplay_button'],
    'napari/qt/threading.py': [],
    'napari/resources/__init__.py': [],
    'napari/resources/_icons.py': [
        '(<svg[^>]*>)',
        '.svg',
        '</svg>',
        '<style type="text/css">\npath {{fill: {0}; opacity: {1};}}\npolygon {{fill: {0}; opacity: {1};}}\ncircle {{fill: {0}; opacity: {1};}}\nrect {{fill: {0}; opacity: {1};}}\n</style>',
        '\\1{svg_style.format(color, opacity)}',
        'icons',
    ],
    'napari/types.py': [
        '1',
        '20',
        'FunctionGui',
        'ImageData',
        'LabelsData',
        'LayerDataTuple',
        'PointsData',
        'QWidget',
        'ShapesData',
        'SurfaceData',
        'TracksData',
        'VectorsData',
        'dask.array.Array',
        'zarr.Array',
    ],
    'napari/utils/__init__.py': [],
    'napari/utils/_appdirs.py': [
        'Lib',
        'darwin',
        'lib',
        'napari',
        'nt',
        'plugins',
        'site-packages',
        'python3.8',
    ],
    'napari/utils/_base.py': ['Napari', 'en', 'settings.yaml'],
    'napari/utils/_magicgui.py': [
        'CategoricalWidget',
        'Data',
        'add_{layer_type}',
        'name',
        'native',
        'parent',
        'qt_viewer',
        'widget',
        '{layer.name} (data)',
        '{layer_name.title()}Data',
        '_called',
    ],
    'napari/utils/_octree.py': [
        '0',
        '1',
        'auto_sync_ms',
        'delay_queue_ms',
        'enabled',
        'force_synchronous',
        'loader_defaults',
        'loaders',
        'log_path',
        'napari.loader',
        'num_workers',
        'octree',
        'tile_size',
        'use_processes',
    ],
    'napari/utils/_register.py': [
        '\n\tThe newly-created {cls_name.lower()} layer.',
        '\n\nParameters\n----------\n',
        '\n\nReturns\n-------\n',
        'Add a{n} {cls_name} layer to the layer list. ',
        'add_',
        'aeiou',
        "def {name}{signature}:\n    kwargs = locals()\n    kwargs.pop('self', None)\n    layer = {cls_name}(**kwargs)\n    self.layers.append(layer)\n    return layer\n",
        'layer',
        'layer : :class:`napari.layers.{cls_name}`',
        'n',
        'self',
    ],
    'napari/utils/_tracebacks.py': [
        '\x1b\\[',
        '&nbsp;',
        '(<tr><td><small.*</tr>)',
        '([\\d;]*)',
        '([a-zA-z])',
        ';',
        '; ',
        '</span>',
        '<br>',
        '<br>\n',
        '<br><br><font color="#51B432">During handling of the ',
        '<br><br><font color="#51B432">The above exception was ',
        '<br>\\1<br>',
        '<p>A problem occurred in a Python script.  ',
        '<span style="%s">',
        "<span style='font-family: monaco,courier,monospace;'>",
        'Format exception with cgitb.html.',
        'Here is the sequence of',
        'Neutral',
        'Recurse through exception stack and chain cgitb_html calls.',
        'above exception, another exception occurred:</font><br>',
        'bgcolor="#.*"',
        'black',
        'blink',
        'blue',
        'bold',
        'color',
        'cyan',
        'face="helvetica, arial"',
        'font_weight',
        'function calls leading up to the error, ',
        'green',
        'hidden',
        'in the order they occurred.</p>',
        'italic',
        'lighter',
        'line-through',
        'mM',
        'magenta',
        'red',
        'text_decoration',
        'the direct cause of the following exception:</font><br>',
        'underline',
        'visibility',
        'white',
        'yellow',
        '{k}: {v}',
    ],
    'napari/utils/action_manager.py': [
        '_command_with_context',
        ' ({Shortcut(shortcut).platform})',
        'bind_key',
        'change',
        'name',
        'bind_key',
    ],
    'napari/utils/colormaps/__init__.py': [],
    'napari/utils/colormaps/bop_colors.py': [],
    'napari/utils/colormaps/categorical_colormap.py': [
        'colormap',
        'fallback_color',
        'white',
    ],
    'napari/utils/colormaps/categorical_colormap_utils.py': [
        'color_cycle',
        'cycle',
        'values',
        'white',
    ],
    'napari/utils/colormaps/colorbars.py': ['C'],
    'napari/utils/colormaps/colormap.py': [
        'colors',
        'controls',
        'custom',
        'interpolation',
        'linear',
        'name',
        'zero',
    ],
    'napari/utils/colormaps/colormap_utils.py': [
        '[unnamed colormap',
        '[unnamed colormap {len(past_names)}]',
        '_controls',
        'colors',
        'ij',
        'interpolation',
        'lab',
        'label_colormap',
        'light_blues',
        'linear',
        'luv',
        'rgb',
        'single_hue',
        'vispy',
        'zero',
        '"{cm}"',
    ],
    'napari/utils/colormaps/standardize_color.py': [
        '#%02x%02x%02x%02x',
        '#00000000',
        'O',
        'U',
        'f',
        'i',
        'transparent',
        'u',
        '{v.lower()}ff',
        '|U9',
    ],
    'napari/utils/config.py': [
        '\nExperimental Features\n\nAsync Loading\n-------------\nImage layers will use the ChunkLoader to load data instead of loading\nthe data directly. Image layers will not call np.asarray() in the GUI\nthread. The ChunkLoader will call np.asarray() in a worker thread. That\nmeans any IO or computation done as part of the load will not block the\nGUI thread.\n\nSet NAPARI_ASYNC=1 to turn on async loading with default settings.\n\nOctree Rendering\n----------------\nImage layers use an octree for rendering. The octree organizes the image\ninto chunks/tiles. Only a subset of those chunks/tiles are loaded and\ndrawn at a time. Octree rendering is a work in progress.\n\nEnabled one of two ways:\n\n1) Set NAPARI_OCTREE=1 to enabled octree rendering with defaults.\n\n2) Set NAPARI_OCTREE=/tmp/config.json use a config file.\n\nSee napari/utils/_octree.py for the config file format.\n\nShared Memory Server\n--------------------\nExperimental shared memory service. Only enabled if NAPARI_MON is set to\nthe path of a config file. See this PR for more info:\nhttps://github.com/napari/napari/pull/1909.\n',
        '\nOther Config Options\n',
        '0',
        'NAPARI_MON',
        'enabled',
        'octree',
    ],
    'napari/utils/events/__init__.py': [],
    'napari/utils/events/containers/__init__.py': [],
    'napari/utils/events/containers/_evented_list.py': [
        'EventedList[_T]',
        'changed',
        'events',
        'index',
        'inserted',
        'inserting',
        'move_multiple(sources={sources}, dest_index={dest_index})',
        'moved',
        'moving',
        'removed',
        'removing',
        'reordered',
    ],
    'napari/utils/events/containers/_nested_list.py': [
        'ParentIndex',
        '_T',
        'index',
        'move(src_index={src_index}, dest_index={dest_index})',
        'new_index',
    ],
    'napari/utils/events/containers/_selectable_list.py': ['_T'],
    'napari/utils/events/containers/_selection.py': [
        'ModelField',
        '[{i}]',
        '_S',
        '_T',
        '_current',
        'current',
        'selection',
        '{type(self).__name__}({repr(self._set)})',
    ],
    'napari/utils/events/containers/_set.py': [
        '[{i}]',
        '_T',
        'changed',
        'events',
        '{type(self).__name__}({repr(self._set)})',
    ],
    'napari/utils/events/containers/_typed.py': [
        'TypedMutableSequence[_T]',
        '_L',
        '_T',
    ],
    'napari/utils/events/custom_types.py': ['Array', '__dtype__'],
    'napari/utils/events/event.py': [
        '<...>',
        '<{} {}>',
        'EmitterGroup',
        'EventBlockerAll',
        '_',
        '__name__',
        'always',
        'first',
        'last',
        'never',
        'on_%s',
        'reminders',
        'type',
        'weakref.ReferenceType[Any]',
        '{name}={attr}',
    ],
    'napari/utils/events/event_utils.py': [],
    'napari/utils/events/evented_model.py': [
        'PySide2',
        '__weakref__',
        '_json_encode',
        'events',
    ],
    'napari/utils/events/types.py': [],
    'napari/utils/history.py': [],
    'napari/utils/info.py': [
        '  - failed to load screen information {e}',
        '  - failed to load vispy',
        '  - screen {i}: resolution {screen.geometry().width()}x{screen.geometry().height()}, scale {screen.devicePixelRatio()}<br>',
        '  - {plugin_name}{version_string}',
        '  - {sys_info_text}<br>',
        '  None',
        '"',
        "'",
        '-d',
        '-productVersion',
        '-r',
        '/etc/os-release',
        ':',
        ': {version}',
        '</b>',
        '<b>',
        '<b>Platform</b>: {platform.platform()}<br>',
        '<b>Python</b>: {sys_version}<br>',
        '<b>Qt</b>: Import failed ({e})<br>',
        '<b>Qt</b>: {QtCore.__version__}<br>',
        '<b>System</b>: {__sys_name}<br>',
        '<b>napari</b>: {napari.__version__}<br>',
        '<b>{API_NAME}</b>: {API_VERSION}<br>',
        '<b>{name}</b>: Import failed ({e})<br>',
        '<b>{name}</b>: {loaded[module].__version__}<br>',
        '<br>',
        '<br>  - ',
        '<br><b>OpenGL:</b><br>',
        '<br><b>Plugins</b>:',
        '<br><b>Screens:</b><br>',
        '=',
        'Dask',
        'Description',
        'MacOS {res.stdout.decode().strip()}',
        'NAME',
        'NumPy',
        'PRETTY_NAME',
        'PyQt5',
        'PySide2',
        'Release',
        'SciPy',
        'VERSION',
        'VERSION_ID',
        'VisPy',
        'builtins',
        'c',
        'darwin',
        'dask',
        'doi:10.5281/zenodo.3555620',
        'linux',
        'lsb_release',
        'multi-dimensional image viewer for python. ',
        'napari contributors (2019). napari: a ',
        'numpy',
        'plugin_name',
        'scipy',
        'sw_vers',
        'version',
        'vispy',
        '{data["NAME"]} (no version)',
        '{data["NAME"]} {data["VERSION"]}',
        '{data["NAME"]} {data["VERSION_ID"]}',
    ],
    'napari/utils/interactions.py': [
        '⌦',
        '+',
        '-',
        '</table>',
        "<span style='color: rgb(66, 72, 80)'>{keycodes}</span></td>",
        "<span style='color: {col}'><b>{k}</b></span>",
        '<table border="0" width="100%">',
        "<td style='text-align: left; padding: 4px; color: #CCC;'>",
        "<tr><td width='80' style='text-align: right; padding: 4px;'>",
        'Alt',
        'Backspace',
        'Control',
        'Ctrl',
        'Delete',
        'Down',
        'Enter',
        'Esc',
        'Escape',
        'Left',
        'Meta',
        'Opt',
        'Option',
        'Return',
        'Right',
        'Shift',
        'Summary',
        'Super',
        'Tab',
        'Up',
        '__wrapped__',
        'darwin',
        'linux',
        'rgb(134, 142, 147)',
        '{get_function_summary(keymap[key])}</td></tr>',
        '←',
        '↑',
        '→',
        '↓',
        '↵',
        '↹',
        '⇧',
        '⊞',
        '⌃',
        '⌘',
        '⌥',
        '⌫',
        '⏎',
        '-(?=.+)',
        'Space',
        '␣',
    ],
    'napari/utils/io.py': [
        '"',
        '([0-9]+)',
        '*.*',
        ',',
        '.bmp',
        '.bsdf',
        '.bw',
        '.eps',
        '.gif',
        '.icns',
        '.ico',
        '.im',
        '.j2c',
        '.j2k',
        '.jfif',
        '.jp2',
        '.jpc',
        '.jpe',
        '.jpeg',
        '.jpf',
        '.jpg',
        '.jpx',
        '.lsm',
        '.mpo',
        '.npz',
        '.pbm',
        '.pcx',
        '.pgm',
        '.png',
        '.ppm',
        '.ps',
        '.rgb',
        '.rgba',
        '.sgi',
        '.stk',
        '.tga',
        '.tif',
        '.tiff',
        '.zarr',
        '.zarray',
        '.zgroup',
        'any',
        'axis-',
        'axis-0',
        'axis-1',
        'float',
        'index',
        'input arrays must have the same shape',
        'int',
        'points',
        'properties',
        'shape-type',
        'shape_type',
        'shapes',
        'vertex-index',
        'w',
    ],
    'napari/utils/key_bindings.py': [
        '-',
        '-(?=.+)',
        'Control',
        'Down',
        'Left',
        'Right',
        'Shift',
        'Up',
        'class_keymap',
    ],
    'napari/utils/misc.py': [
        ' \\1',
        '((?<=[a-z])[A-Z]|(?<!\\A)[A-R,T-Z](?=[a-z]))',
        '(.)([A-Z][a-z]+)',
        '*',
        '**',
        'Briefcase-Version',
        'T',
        'TerminalInteractiveShell',
        'ZMQInteractiveShell',
        '\\1_\\2',
        '__main__',
        'app_packages',
        'bin',
        'dask.Array',
        'n must be greater than 0',
        'numpy.ndarray',
        'packaging.version._BaseVersion',
        'rgb\\((\\d+),\\s*(\\d+),\\s*(\\d+)\\)',
        'xarray.DataArray',
        'zarr.Array',
        '{base.__module__.split(".", maxsplit=1)[0]}.{base.__name__}',
        '{formatted}={formatted}',
    ],
    'napari/utils/mouse_bindings.py': [],
    'napari/utils/naming.py': [
        '((?<=\\A\\[)|(?<=\\s\\[))(?:\\d+|)(?=\\]$)|$',
        '<string>',
        '{count + 1}',
        '{sep}[{start}]',
    ],
    'napari/utils/notebook_display.py': [
        'png',
        '<img src="{url}"></img>',
        'data:image/png;base64,',
        'utf-8',
    ],
    'napari/utils/notifications.py': [
        '1',
        'Closed by KeyboardInterrupt',
        'Exit on error',
        'INFO',
        'NAPARI_EXIT_ON_ERROR',
        'True',
        'actions',
        'debug',
        'error',
        'excepthook',
        'info',
        'message',
        'none',
        'warning',
        '{self.filename}:{self.lineno}: {category}: {self.warning}!',
        'ⓘ',
        'ⓧ',
        '⚠️',
        '🐛',
    ],
    'napari/utils/perf/__init__.py': ['0', 'NAPARI_PERFMON'],
    'napari/utils/perf/_compat.py': [],
    'napari/utils/perf/_config.py': [
        '0',
        '1',
        'NAPARI_PERFMON',
        'callable_lists',
        'trace_callables',
        'trace_file_on_start',
        'trace_qt_events',
        '{label}',
    ],
    'napari/utils/perf/_event.py': [
        'Origin',
        'Span',
        'X',
        'process_id thread_id',
        'start_ns end_ns',
    ],
    'napari/utils/perf/_patcher.py': [
        'Patcher: [ERROR] {exc}',
        'Patcher: [WARN] skipping duplicate {target_str}',
        'Patcher: patching {module.__name__}.{label}',
        '{class_str}.{callable_str}',
    ],
    'napari/utils/perf/_stat.py': ['no values'],
    'napari/utils/perf/_timers.py': [
        '0',
        'C',
        'I',
        'NAPARI_PERFMON',
        'X',
        '{name} {event.duration_ms:.3f}ms',
    ],
    'napari/utils/perf/_trace_file.py': [
        'C',
        'I',
        'X',
        'args',
        'cat',
        'dur',
        'name',
        'none',
        'p',
        'ph',
        'pid',
        's',
        'tid',
        'ts',
        'w',
    ],
    'napari/utils/settings/__init__.py': [],
    'napari/utils/settings/_defaults.py': [
        'ipy_interactive',
        '"{self._value}"',
        'SchemaVersion("{self._value}")',
        'dark',
        'first_time',
        'napari_',
        'open_history',
        'preferences_size',
        'pyqt5',
        'pyside2',
        'save_history',
        'schema_version',
        'window_fullscreen',
        'window_maximized',
        'window_position',
        'window_size',
        'window_state',
        'window_statusbar',
        'appearance',
        'application',
        'boolean',
        'default',
        'description',
        'disabled_plugins',
        'experimental',
        'loc',
        'napari_async',
        'plugins',
        'properties',
        'section',
        'title',
    ],
    'napari/utils/settings/_manager.py': [
        'json_schema',
        'model',
        'w',
        '_env_settings',
        'default',
        'properties',
        'section',
    ],
    'napari/utils/status_messages.py': [
        ', {status_format(value[1])}',
        ': {status_format(value)}',
        ': {status_format(value[0])}',
        '[',
        ']',
        '{name} {full_coord}',
        '{value:0.3g}',
    ],
    'napari/utils/temporary_file.py': [],
    'napari/utils/theme.py': [
        '([vh])gradient\\((.+)\\)',
        ')',
        '-',
        'background',
        'black',
        'canvas',
        'console',
        'current',
        'dark',
        'default',
        'folder',
        'foreground',
        'h',
        'highlight',
        'icon',
        'light',
        'native',
        'palettes',
        'primary',
        'qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, ',
        'qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0, ',
        'rgb(',
        'rgb(0, 0, 0)',
        'rgb(0, 122, 204)',
        'rgb(106, 115, 128)',
        'rgb(107, 105, 103)',
        'rgb(134, 142, 147)',
        'rgb(150, 146, 144)',
        'rgb(153, 18, 31)',
        'rgb(163, 158, 156)',
        'rgb(188, 184, 181)',
        'rgb(209, 210, 212)',
        'rgb(214, 208, 206)',
        'rgb(239, 235, 233)',
        'rgb(240, 241, 242)',
        'rgb(253, 240, 148)',
        'rgb(255, 18, 31)',
        'rgb(255, 255, 255)',
        'rgb(38, 41, 48)',
        'rgb(59, 58, 57)',
        'rgb(65, 72, 81)',
        'rgb(90, 98, 108)',
        'rgb({red}, {green}, {blue})',
        'rgba({red}, {green}, {blue}, {max(min(int(value), 255), 0)})',
        'secondary',
        'stop: {n} {stop}',
        'syntax_style',
        'text',
        'warning',
        'white',
        '{{ %s }}',
        '{{\\s?darken\\((\\w+),?\\s?([-\\d]+)?\\)\\s?}}',
        '{{\\s?lighten\\((\\w+),?\\s?([-\\d]+)?\\)\\s?}}',
        '{{\\s?opacity\\((\\w+),?\\s?([-\\d]+)?\\)\\s?}}',
    ],
    'napari/utils/transforms/__init__.py': [],
    'napari/utils/transforms/transform_utils.py': [],
    'napari/utils/transforms/transforms.py': [
        'Affine',
        'CompositeAffine',
        'ScaleTranslate',
        'Transform',
        'TransformChain',
    ],
    'napari/utils/translations.py': [
        'LANG',
        'LANGUAGE',
        'NAPARI_LANGUAGE',
        '_',
        'application',
        'displayName',
        'language',
        'locale',
        'n',
        'napari',
        'napari.languagepack',
        'nativeName',
        '{locale}.UTF-8',
        'The `language` setting defined in the napari ',
        'configuration file could not be read.\n\n',
        'The default language will be used.\n\n',
        'Error:\n{err}',
    ],
    'napari/utils/tree/__init__.py': [],
    'napari/utils/tree/group.py': [
        '  {bul}',
        '  │',
        'Group',
        'NodeType',
        '└──',
        '├──',
    ],
    'napari/utils/tree/node.py': ['Node'],
    'napari/utils/validators.py': ['__getitem__'],
    'napari/view_layers.py': [
        'Create a viewer and add a{n} {layer_string} layer.\n\n{params}\n\nReturns\n-------\nviewer : :class:`napari.Viewer`\n    The newly-created viewer.\n',
        'Parameters',
        'add_{layer_string}',
        'aeiou',
        'n',
        'open',
        'path',
        'add_image',
        'add_labels',
        'add_points',
        'add_shapes',
        'add_surface',
        'add_tracks',
        'add_vectors',
        'kwargs',
        'return',
        'self',
        'view_',
    ],
    'napari/viewer.py': ['Window', 'napari'],
    'napari/window.py': [],
}
