# Guides

If you'd like to start customizing the behavior of napari, it pays to
familiarize yourself with the concept of an Event Loop. For an introduction to
event loops and connecting your own functions to events in napari, see the
{ref}`intro-to-event-loop`.

If you use napari to view and interact with the results of long-running
computations, and would like to avoid having the viewer become unresponsive
while you wait for a computation to finish, you may benefit from reading about
{ref}`multithreading-in-napari`.

Performance is a core feature of napari. To learn how to monitor
performance and diagnose and fix performance problems, see {ref}`perfmon`.

See {ref}`rendering` for two experimental features than can optionally
be enabled to add non-blocking rendering to napari.

See {ref}`preferences` for the list of preferences that can be set via the
preferences dialog.

Finally, see {ref}`translations` to learn more about how to make strings
within the napari codebase localizable.
