import numpy as np, logging
import h5py
import NLSA
import myio
import warnings
warnings.simplefilter(action='ignore',category=FutureWarning)
import os
import p

'''
Copyright (c) UWM, Ali Dashti 2016 (original matlab version)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
CCopyright (c) Columbia University Hstau Liao 2018 (python version) 
Copyright (c) Columbia University Evan Seitz 2019 (python version) 	
Copyright (c) Columbia University Suvrajit Maji 2020 (python version)  
'''

def corr(a,b,n,m):
    A = a[:,n]
    B = b[:,m]
    A = A - np.mean(A)
    B = B - np.mean(B)
    try:
        co = np.dot(A,B) / (np.std(A)*np.std(B))
    except:
        print("flat image")
        return 1
    return co

def diff_corr(a,b,max):

     return corr(a,b,0,0)+corr(a,b,max,max)- \
         (corr(a,b,0,max)+corr(a,b,max,0))

def fileCheck(N):
    fin_PDs = np.zeros(shape=(N,p.num_psis), dtype=int) #zeros signify PD_psi entry not complete
    for root, dirs, files in os.walk(p.psi2_prog):
        for file in sorted(files):
            if not file.startswith('.'): #ignore hidden files
                fin_PD, fin_psi = file.split('_')
                fin_PDs[int(fin_PD),int(fin_psi)] = int(1)
    return fin_PDs


def op(input_data,conOrderRange,traj_name,isFull,psiTrunc,*argv):
    dist_file = input_data[0]
    psi_file = input_data[1] #15-dim diffusion map coordinates
    psi2_file = input_data[2] #output to be generated by Psi Analysis
    EL_file = input_data[3]
    psinums = input_data[4]
    senses = input_data[5]
    prD = input_data[6]
    if len(input_data) == 8:
        psi_list = input_data[7]
    else:
        psi_list = psinums
    data_IMG = myio.fin1(dist_file)
    data_psi = myio.fin1(psi_file)

    D = np.array(data_IMG['D']) #distance matrix
    imgAll = np.array(data_IMG['imgAll']) #every image in PD (and dimensions): e.g., shape=(numPDs,boxSize,boxSize)

    msk2 = np.array(data_IMG['msk2']) # April 2020, vol mask to be used after ctf has been applied

    CTF = np.array(data_IMG['CTF'])
    psi = data_psi['psi'] #coordinates of all images in 15-dim space from diffusion map: e.g., shape=(numPDs,15)
    posPath = data_psi['posPath'] #indices of every image in PD: e.g., shape=(numPDs,); [0,1,2,...(numPDs-1)]
    nS = len(posPath) #number of images in PD
    ConOrder = int(np.floor(float(nS) / conOrderRange))
    # if ConOrder is large, noise-free 2D frames expected w/ small range of conformations, \
    # while losing snapshots at edges

    dim = int(np.sqrt(imgAll.size/D.shape[0]))
    CTF = CTF.reshape(D.shape[0],dim,dim) #needed only if read from matlab
    posPath = np.squeeze(posPath)
    D = D[posPath][:, posPath]

    ExtPar = dict(outDir='',prD=prD)

    for psinum in psi_list: #for each reaction coordinates do the following:
        if psinum == -1:
            continue
        psiSortedInd = np.argsort(psi[:,psinum]) #e.g., shape=(numPDs,): reordering image indices along each diff map coord
        PosPsi1 = psiSortedInd #duplicate of above...

        psi1 = psi[PosPsi1,:]
        CC = range(0,max(psi1.shape))

        DD = D[PosPsi1]
        DD = DD[:,PosPsi1] #distance matrix with indices of images re-arranged along current diffusion map coordinate
        num = DD.shape[1] #number of images in PD (duplicate of nS?)
        k = num - ConOrder

        NLSAPar = dict(num=num,ConOrder=ConOrder,k=k,tune=p.tune,nS=nS,save=False,psiTrunc=psiTrunc)
        #IMGT,Topo_mean,psirec,psiC1,sdiag,VX,mu,tau = NLSA.op(NLSAPar, DD, posPath,PosPsi1,imgAll,CTF, ExtPar)
        IMGT,Topo_mean,psirec,psiC1,sdiag,VX,mu,tau = NLSA.op(NLSAPar, DD, posPath,PosPsi1,imgAll,msk2,CTF, ExtPar) # April 2020, pass the msk2 var also
        kk = 10
        #if np.median(tau[:kk] > 0.8): this doesn't do it
        #    tau = 1-tau
            #print 'yes'
        nSrecon = min(IMGT.shape)
        numclass = int(min(p.nClass, np.floor(nSrecon / 2.)))

        tau = (tau - min(tau))/ (max(tau) - min(tau))
        tauinds = []
        i1 = 0
        i2 = IMGT.shape[0]

        IMG1 = np.zeros((i2, numclass),dtype='float64')
        for i in range(numclass):
            ind1 = float(i) / numclass
            ind2 = ind1 + 1. / numclass;
            if (i == numclass-1):
                tauind = ((tau >= ind1) & (tau <= ind2)).nonzero()[0]
            else:
                tauind = ((tau >= ind1) & (tau < ind2)).nonzero()[0]
            while (tauind.size == 0):
                sc = 1. / (numclass * 2.)
                ind1 = ind1 - sc * ind1
                ind2 = ind2 + sc * ind2
                tauind = ((tau >= ind1) & (tau < ind2)).nonzero()[0]

            IMG1[i1:i2, i] = IMGT[:, tauind[0]]
            tauinds.append(tauind[0])

        if isFull: # second pass for EL1D

            # adjust tau by comparing the IMG1s
            psi2_file = '{}_psi_{}'.format(psi2_file, psinum)
            data = myio.fin1(psi2_file)
            IMG1a= data['IMG1']

            dc = diff_corr(IMG1,IMG1a,numclass-1)
            if (senses[0]==-1 and dc > 0) or senses[0]==1 and dc < 0:
                tau = 1-tau
            # output result

            outFile = '{}_{}_1'.format(EL_file,traj_name)
            myio.fout1(outFile, ['IMG1','IMGT','posPath','PosPsi1','psirec','tau','psiC1','mu',
                                 'VX','sdiag','Topo_mean','tauinds'],
                                [IMG1,IMGT,posPath,PosPsi1,psirec,tau,psiC1,mu,
                                 VX,sdiag,Topo_mean,tauinds])

            #######################################################
            # create empty PD files after each Pickle dump to...
            # ...be used to resume (avoiding corrupt Pickle files):
            progress_fname = os.path.join(p.EL_prog, '%s' % (prD))
            open(progress_fname, 'a').close() #create empty file to signify non-corrupted Pickle dump
            #######################################################

        else: # first pass
            outFile = '{}_psi_{}'.format(psi2_file,psinum)
            myio.fout1(outFile,['IMG1','psirec','tau','psiC1','mu','VX','sdiag',
                            'Topo_mean','tauinds'],[IMG1,psirec,tau,psiC1,mu,VX,sdiag,
                                                    Topo_mean,tauinds])

            #######################################################
            # create empty PD files after each Pickle dump to...
            # ...be used to resume (avoiding corrupt Pickle files):
            progress_fname = os.path.join(p.psi2_prog, '%s_%s' % (prD, psinum))
            open(progress_fname, 'a').close() #create empty file to signify non-corrupted Pickle dump
            #######################################################
            if argv:
                progress3 = argv[0]
                fin_PDs = fileCheck(p.numberofJobs) #array of finished PDs (0's are unfinished, 1's are finished)
                offset = np.count_nonzero(fin_PDs==1)
                progress3.emit(int((offset / float((p.numberofJobs)*p.num_psis)) * 100))

    res = 'ok'
    return res

if __name__ == '__main__':
   #align_param_file = 'data/refine_005.tls'
   op()
