<p align="center">
  <img src="https://github.com/biopragmatics/biomappings/raw/master/docs/source/logo.png" height="150">
</p>

<h1 align="center">
  Biomappings
</h1>

<p align="center">
    <a href="https://github.com/biopragmatics/biomappings/actions?query=workflow%3A%22Check+mappings%22">
        <img alt="Check mappings" src="https://github.com/biopragmatics/biomappings/workflows/Check%20mappings/badge.svg" />
    </a>
    <a href="https://pypi.org/project/biomappings">
        <img alt="PyPI" src="https://img.shields.io/pypi/v/biomappings" />
    </a>
    <a href="https://pypi.org/project/biomappings">
        <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/biomappings" />
    </a>
    <a href="https://github.com/biopragmatics/biomappings/blob/main/LICENSE">
        <img alt="PyPI - License" src="https://img.shields.io/pypi/l/biomappings" />
    </a>
    <a href="https://zenodo.org/badge/latestdoi/285352907">
        <img src="https://zenodo.org/badge/285352907.svg" alt="DOI">
    </a>
    <a href="https://github.com/psf/black">
        <img src="https://img.shields.io/badge/code%20style-black-000000.svg" alt="Code style: black">
    </a>
    <a href="https://github.com/biopragmatics/bioregistry">
        <img alt="Powered by the Bioregistry" src="https://img.shields.io/static/v1?label=Powered%20by&message=Bioregistry&color=BA274A&style=flat&logo=image/png;base64,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" />
    </a>  
</p>

Biomappings is a repository of community curated and predicted equivalences and
related mappings between named biological entities that are not available from
primary sources. It's also a place where anyone can contribute curations
of predicted mappings or their own novel mappings. Ultimately, we hope that
primary resources will integrate these mappings and distribute them themselves.

Mappings are stored in a simple TSV file that looks like this:

![](docs/img/mappings_screenshot.png)

## 💾 Data

The data are available through the following four files on
the [biopragmatics/biomappings](https://github.com/biopragmatics/biomappings) GitHub repository.

| Curated | Description                      | Link |
| ------- | -------------------------------- | ----------- |
|  Yes    | Human-curated true mappings      | [`src/biomappings/resources/mappings.tsv`](https://github.com/biopragmatics/biomappings/raw/master/src/biomappings/resources/mappings.tsv) |
|  Yes    | Human-curated *non-trivial* false (i.e., incorrect) mappings | [`src/biomappings/resources/incorrect.tsv`](https://github.com/biopragmatics/biomappings/raw/master/src/biomappings/resources/incorrect.tsv) |
|  Yes    | Mappings that have been checked but not yet decided | [`src/biomappings/resources/unsure.tsv`](https://github.com/biopragmatics/biomappings/raw/master/src/biomappings/resources/unsure.tsv) |
|  No     | Automatically predicted mappings | [`src/biomappings/resources/predictions.tsv`](https://github.com/biopragmatics/biomappings/raw/master/src/biomappings/resources/predictions.tsv) |

The primary and derived data in this repository are both available under
the [CC0 1.0 Universal License](https://github.com/biopragmatics/biomappings/blob/master/LICENSE).

Predictions are generated by scripts in the [`scripts/`](scripts) folder. Each
uses the utilities from the `biomappings.resources` module to programmatically
interact with the mappings files, e.g., to add predictions.

### 🥒 Derived

The mappings are distributed in the [Simple Standard for Sharing Ontology Mappings
(SSSOM)](https://github.com/mapping-commons/sssom) format
([here](https://github.com/biopragmatics/biomappings/blob/master/docs/_data/sssom)).
The positive mappings are also available as a network through
[NDEx](https://www.ndexbio.org/#/network/402d1fd6-49d6-11eb-9e72-0ac135e8bacf).

Equivalences and related mappings that are available from the OBO Foundry and other primary sources can be accessed
through [Inspector Javert's Xref Database](https://zenodo.org/record/3757266)
on Zenodo which was described in [this blog post](https://cthoyt.com/2020/04/19/inspector-javerts-xref-database.html).

### 📊 Summary

Summary statistics of the manually curated mappings and predicted mappings
are automatically generated nightly and deployed as a website with GitHub
Actions to https://biopragmatics.github.io/biomappings.

[![Summary statistics](docs/img/summary.svg)](https://biopragmatics.github.io/biomappings)

## 🙏 Contributing

We welcome contributions in the form of curations to any of the four primary TSV
files in this repository via a pull request to the main Biomappings repository
at https://github.com/biopragmatics/biomappings.

Predicted mappings can be curated by moving a row in the `predictions.tsv` file
into either the positive mappings file (`mappings.tsv`), negative mappings file
(`incorrect.tsv`), or the unsure mappings file (`unsure.tsv`). Additionally,
the `confidence` column should be removed, a `type` column should be added with
the value `manually_reviewed`, and the `source` column should be changed from
the prediction script's URI to your ORCiD identifier written as a CURIE
(e.g., `orcid:0000-0003-1307-2508`).

Novel mappings can be curated by adding a full row to the positive mappings
file (`mappings.tsv`) following the format of the previous lines.

While Biomappings is generally able to use any predicate written as a [compact URI (CURIE)](http://www.w3.org/TR/curie),
it's preferred to use predicates from the [Simple Knowledge Organization System (SKOS)](https://www.w3.org/2004/02/skos/)
to denote hierarchical relationships. The three most common predicates that are
useful for curating mappings are:

| Predicate                                                                             | Description                                     |
|---------------------------------------------------------------------------------------|-------------------------------------------------|
| [`skos:exactMatch`](https://www.w3.org/2009/08/skos-reference/skos.html#exactMatch)   | The two terms can be used interchangeably       |
| [`skos:broadMatch`](https://www.w3.org/2009/08/skos-reference/skos.html#broadMatch)   | The object term is a super-class of the subject |
| [`skos:narrowMatch`](https://www.w3.org/2009/08/skos-reference/skos.html#narrowMatch) | The object term is a sub-class of the subject   |

### Online via GitHub Web Interface

GitHub has an interface for editing files directly in the browser. It will take care of creating a branch for you and
creating a pull request. After logging into GitHub, click one of the following links to be brought to the editing
interface:

- [True Mappings](https://github.com/biopragmatics/biomappings/edit/master/src/biomappings/resources/mappings.tsv)
- [False Mappings](https://github.com/biopragmatics/biomappings/edit/master/src/biomappings/resources/incorrect.tsv)
- [Unsure Mappings](https://github.com/biopragmatics/biomappings/edit/master/src/biomappings/resources/unsure.tsv)
- [Predictions](https://github.com/biopragmatics/biomappings/edit/master/src/biomappings/resources/predictions.tsv)

This has the caveat that you can only edit one file at a time. It's possible to navigate to your own forked version of
the repository after, to the correct branch (will not be the default one), then edit other files in the web interface as
well. However, if you would like to do this, then it's probably better to see the following instructions on contributing
locally.

### ✍️ Local via a Text Editor

1. Fork the repository at https://github.com/biopragmatics/biomappings, clone locally, and make a new branch (see below)
2. Edit one or more of the resource files (`mappings.tsv`, `incorrect.tsv`, `unsure.tsv`, `predictions.tsv`)
3. Commit to your branch, push, and create a pull request back to the upstream repository.

### 🌐 Local via the Web Curation Interface

Rather than editing files locally, this repository also comes with a web-based curation interface. Install the code in
development mode with the `web` option (which installs `flask` and `flask-bootstrap`) using:

```bash
$ git clone git+https://github.com/biopragmatics/biomappings.git
$ cd biomappings
$ pip install -e .[web]
```

The web application can be run with:

```bash
$ biomappings web
```

It can be accessed by navigating to http://localhost:5000/ in your browser.
After you do some curations, the web application takes care of interacting with
the git repository from which you installed `biomappings` via the "commit and
push" button.

**Note** if you've installed `biomappings` via [PyPI](https://pypi.org/project/biomappings/),
then running the web curation interface doesn't make much sense,
since it's non-trivial for most users to find the location of the resources within your Python installation's
`site-packages` folder, and you won't be able to contribute them back.

### Curation Attribution

There are three places where curators of Biomappings are credited:

1. ORCiD identifiers of curators are stored in each mapping
2. The [summary website](https://biopragmatics.github.io/biomappings) groups
   and counts contributions curator
3. A curation leaderboard is automatically uploaded to [APICURON](https://apicuron.org/database?resource_uri=https:%2F%2Fbiomappings.github.io%2Fbiomappings%2F).

## ⬇️ Installation

The most recent release can be installed from
[PyPI](https://pypi.org/project/biomappings/) with:

```bash
$ pip install biomappings
```

The most recent code and data can be installed directly from GitHub with:

```bash
$ pip install git+https://github.com/biopragmatics/biomappings.git
```

To install in development mode, use the following:

```bash
$ git clone git+https://github.com/biopragmatics/biomappings.git
$ cd biomappings
$ pip install -e .
```

## 💪 Usage

There are three main functions exposed from `biomappings`. Each loads a list of dictionaries with the mappings in each.

```python
import biomappings

true_mappings = biomappings.load_mappings()

false_mappings = biomappings.load_false_mappings()

predictions = biomappings.load_predictions()
```

Alternatively, you can use the above links to the TSVs on GitHub in with the library or programming language of your
choice.

The data can also be loaded as [networkx](https://networkx.org/) graphs with the following functions:

```python
import biomappings

true_graph = biomappings.get_true_graph()

false_graph = biomappings.get_false_graph()

predictions_graph = biomappings.get_predictions_graph()
```

## 👋 Attribution

### ⚖️ License

Code is licensed under the MIT License. Data are licensed under the CC0 License.

### 🎁 Support

Biomappings was developed by the [INDRA Lab](https://indralab.github.io), a part of the
[Laboratory of Systems Pharmacology](https://hits.harvard.edu/the-program/laboratory-of-systems-pharmacology/about/)
and the [Harvard Program in Therapeutic Science (HiTS)](https://hits.harvard.edu)
at [Harvard Medical School](https://hms.harvard.edu/).

### 💰 Funding

The development of the Bioregistry is funded by the DARPA Young Faculty Award W911NF2010255 (PI:
Benjamin M. Gyori).
