*Qr represents a variable Q in the reactor, e.g. xr('MA','t2') is the mole fraction of MA in the reactor outlet
*Qc represents a variable Q in the crystalliser, e.g. xc('MA','t4') is the mole fraction of MA in the crystalliser outlet (liquid)
*===================================================================================================================================
SETS

s 'candidate solvents'
/1-2-dimethoxyethane,1-2-propanediol,1-4-dioxane,Acetic-acid,Acetone,Acetonitrile,Chlorobenzene,Chloroform,Cyclohexane,Diethoxymethane,DMAC,Ethanol,
Ethylacetate,Formic-acid,i-butylacetate,i-propylacetate,Isobutanol,Isopropanol,Methylacetate,MIBK,MEK,MTBE,n-butanol,2-butanol,n-heptane,n-hexane,Nitromethane,o-xylene,t-AmOH,t-butanol,Toluene,Triethylamine,Water,Anisole,n-butylacetate,trifluoroethanol,trifluoroacetic-acid,1-propanol
n-pentane,carbon-tetrachloride,diethyl-ether,Cyclohexanone,Ethyl-formate,Nitrobenzene,Dimethyl-sulfide,2-Methylpentane,2-Pentanol,2-Pentanone,3-Pentanone,CyclopentylMethylEther,2-2-4-Trimethylpentane,Methylcyclohexane,Methylcyclopentane,Propyl-acetate,
t-Amyl-methyl-ether,t-Butyl-acetate,t-Butyl-ethyl-ether,DMF/

i 'components in reaction and crystallisation mixtures'
/MA, CBA, DMA, s1, s2/

ii(i) 'selected solvents'
/s1, s2/

jj(i)  'solid solutes in reaction mixture'
/MA, CBA, DMA/

*mm(i) 'solid impurities'
*/CBA,DMA/

t 'process streams'
/t1, t2, t3, t4, t5/
*t1 = reactor inlet; t2 = reactor outlet; t3 = antisolvent stream; t4 = crystalliser outlet (liquid); t5 = crystalliser outlet (solid)

strM(t) 'streams with miscibility calculations'
/t1,t4/

k 'groups'
/CH3,CH2,CH,C,CH2dCH,CHdCH,CH2dC,CHdC,CdC,ACH,AC,ACCH3,ACCH2,ACCH,OH,CH3OH,H2O,ACOH,CH3CO,CH2CO,CHO,CH3COO,CH2COO,HCOO,CH3O,CH2O,CH-O,THF,CH3NH2,CH2NH2,CHNH2,CH3NH,CH2NH,
CHNH,CH3N,CH2N,ACNH2,ACNH,C5H5N,C5H4N,C5H3N,CH3CN,CH2CN,COOH,HCOOH,CH2CL,CHCL,CCL,CH2CL2,CHCL2,CCL2,CHCL3,CCL3,CCL4,ACCL,CH3NO2,CH2NO2,CHNO2,ACNO2,CS2,CH3SH,CH2SH,FURFURAL,
DOH,I,BR,CHtC,CtC,DMSO,ACRY,CL-CdC,ACF,DMF,HCONCH2CH2,CF3,CF2,CF,COO,SiH3,SiH2,SiH,Si,SiH2O,SiHO,SiO,NMP,CCL3F,CCL2F,HCCL2F,HCCLF,CCLF2,HCCLF2,CCLF3,CCL2F2,CONH2,
CONHCH3,CONHCH2,CONCH3CH3,CONCH3CH2,CONCH2CH2,C2H5O2,C2H4O2,CH3S,CH2S,CHS,MORFOLIN,C4H4S,C4H3S,C4H2S,tert-N,CH2SuCH2/

prp  'melting/boiling T; molar mass, density'
/p1,p2,p3,p4/

f  'gsk safety indicators'
/f1*f4/

ic 'integer cut iterations'
/1*3/
set din(ic);
alias(ic,ics);

alias(k,m);
alias(k,p);
alias(s,ss);

Set
pr       properties
/R,Q/ ;

*===============================================================================
*Table for group specifications
*===============================================================================
*aCNH UNIFAC group parameters do not exist in UNIFAC database so Q & R parameters are approximated based on the parameters of group aCNH2
Table GS(k, pr) Group Specifications (R = volume Q = surface area)
                   R              Q
CH3                0.9011         0.848
CH2                0.6744         0.54
CH                 0.4469         0.228
C                  0.2195         0
CH2dCH             1.3454         1.176
CHdCH              1.1167         0.867
CH2dC              1.1173         0.988
CHdC               0.8886         0.676
CdC                0.6605         0.485
ACH                0.5313         0.4
AC                 0.3652         0.12
ACCH3              1.2663         0.968
ACCH2              1.0396         0.66
ACCH               0.8121         0.348
OH                 1              1.2
CH3OH              1.4311         1.432
H2O                0.92           1.4
ACOH               0.8952         0.68
CH3CO              1.6724         1.488
CH2CO              1.4457         1.18
CHO                0.998          0.948
CH3COO             1.9031         1.728
CH2COO             1.6764         1.42
HCOO               1.242          1.188
CH3O               1.145          1.088
CH2O               0.9183         0.78
CH-O               0.6908         0.468
THF                0.9183         1.1
CH3NH2             1.5959         1.544
CH2NH2             1.3692         1.236
CHNH2              1.1417         0.924
CH3NH              1.4337         1.244
CH2NH              1.207          0.936
CHNH               0.9795         0.624
CH3N               1.1865         0.94
CH2N               0.9597         0.632
ACNH2              1.06           0.816
*R(aCNH)=R(aCNH2)-R(H)=1.06-0.1622=0.8978  and   Q(aCNH)=Q(aCNH2)-Q(H)=0.816-0.3=0.516 --> R(H)=R(CH3CNH2)-R(CH3NH)=1.5959-1.4337=0.1622   and   Q(H)=Q(CH3CNH2)-Q(CH3NH)=1.544-1.244= 0.3
ACNH               0.8978         0.516
C5H5N              2.9993         2.113
C5H4N              2.8332         1.833
C5H3N              2.667          1.553
CH3CN              1.8701         1.724
CH2CN              1.6434         1.416
COOH               1.3013         1.224
HCOOH              1.528          1.532
CH2CL              1.4654         1.264
CHCL               1.238          0.952
CCL                1.0106         0.724
CH2CL2             2.2564         1.988
CHCL2              2.0606         1.684
CCL2               1.8016         1.448
CHCL3              2.87           2.41
CCL3               2.6401         2.184
CCL4               3.39           2.91
ACCL               1.1562         0.844
CH3NO2             2.0086         1.868
CH2NO2             1.7818         1.56
CHNO2              1.5544         1.248
ACNO2              1.4199         1.104
CS2                2.057          1.65
CH3SH              1.877          1.676
CH2SH              1.651          1.368
FURFURAL           3.168          2.484
DOH                2.4088         2.248
I                  1.264          0.992
BR                 0.9492         0.832
CHtC               1.292          1.088
CtC                1.0613         0.784
DMSO               2.8266         2.472
ACRY               2.3144         2.052
CL-CdC             0.791          0.724
ACF                0.6948         0.524
DMF                3.0856         2.736
HCONCH2CH2         2.6322         2.12
CF3                1.406          1.38
CF2                1.0105         0.92
CF                 0.615          0.46
COO                1.38           1.2
SIH3               1.6035         1.2632
SIH2               1.4443         1.0063
SIH                1.2853         0.7494
SI                 1.047          0.4099
SIH2O              1.4838         1.0621
SIHO               1.303          0.7639
SIO                1.1044         0.4657
NMP                3.981          3.2
CCL3F              3.0356         2.644
CCL2F              2.2287         1.916
HCCL2F             2.406          2.116
HCCLF              1.6493         1.416
CCLF2              1.8174         1.648
HCCLF2             1.967          1.828
CCLF3              2.1721         2.1
CCL2F2             2.6243         2.376
CONH2              1.4515         1.248
CONHCH3            2.1905         1.796
CONHCH2            1.9637         1.488
CONCH3CH3          2.8589         2.428
CONCH3CH2          2.6322         2.12
CONCH2CH2          2.4054         1.812
C2H5O2             2.1226         1.904
C2H4O2             1.8952         1.592
CH3S               1.613          1.368
CH2S               1.3863         1.06
CHS                1.1589         0.748
MORFOLIN           3.474          2.796
C4H4S              2.8569         2.14
C4H3S              2.6908         1.86
C4H2S              2.5247         1.58
tert-N             0.2854         0.092
CH2SuCH2           2.6869         2.120
;


table tb(s,k) 'number of groups in molecule i'

                         CH3  CH2  CH  C  CH2dCH  CHdCH  CH2dC  CHdC  CdC  ACH  AC  ACCH3  ACCH2  ACCH  OH  CH3OH  H2O  ACOH  CH3CO  CH2CO  CHO  CH3COO  CH2COO  HCOO  CH3O  CH2O  CH-O  THF  CH3NH2  CH2NH2  CHNH2  CH3NH  CH2NH  CHNH  CH3N  CH2N  ACNH2  C5H5N  C5H4N  C5H3N  CH3CN  CH2CN  COOH  HCOOH  CH2CL  CHCL  CCL  CH2CL2  CHCL2  CCL2  CHCL3  CCL3   CCL4  ACCL  CH3NO2  CH2NO2  CHNO2  ACNO2  CS2  CH3SH  CH2SH  FURFURAL  DOH  I  BR  CHtC  CtC  DMSO  ACRY  CL-CdC    ACF  DMF  HCONCH2CH2  CF3  CF2  CF  COO  SiH3  SiH2  SiH  Si  SiH2O  SiHO  SiO  NMP  CCL3F  CCL2F  HCCL2F  HCCLF  CCLF2  HCCLF2  CCLF3  CCL2F2  CONH2  CONHCH3  CONHCH2  CONCH3CH3  CONCH3CH2  CONCH2CH2  C2H5O2  C2H4O2  CH3S  CH2S  CHS  MORFOLIN  C4H4S  C4H3S  C4H2S  tert-N    CH2SuCH2
1-2-dimethoxyethane      0    2    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     2     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
1-2-propanediol          1    1    1   0  0       0      0      0     0    0    0   0      0      0     2   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
1-4-dioxane              0    2    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     2     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Acetic-acid              1    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      1     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Acetone                  1    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     1      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Acetonitrile             0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      1      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Chlorobenzene            0    0    0   0  0       0      0      0     0    5    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     1     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Chloroform               0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     1      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Cyclohexane              0    6    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Diethoxymethane          2    1    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     2     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
DMAC                     1    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        1          0          0          0       0       0     0     0    0         0      0      0      0         0
Ethanol                  1    1    0   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Ethylacetate             1    1    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Formic-acid              0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     1      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
i-butylacetate           2    1    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
i-propylacetate          2    0    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Isobutanol               2    1    1   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Isopropanol              2    0    1   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Methylacetate            1    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
MIBK                     2    1    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     1      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
MEK                      1    1    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     1      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
MTBE                     3    0    0   1  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     1     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
n-butanol                1    3    0   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
2-Butanol                2    1    1   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
n-heptane                2    5    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
n-hexane                 2    4    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Nitromethane             0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     1       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
o-xylene                 0    0    0   0  0       0      0      0     0    4    0   2      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
t-AmOH                   3    1    0   1  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
t-butanol                3    0    0   1  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Toluene                  0    0    0   0  0       0      0      0     0    5    0   1      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Triethylamine            3    2    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     1     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Water                    0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      1    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Anisole                  0    0    0   0  0       0      0      0     0    5    1   0      0      0     0   0      0    0     0      0      0    0       0       0     1     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
n-butylacetate           1    3    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
trifluoroethanol         0    1    0   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           1    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
trifluoroacetic-acid     0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      1     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           1    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
1-propanol               1    2    0   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
n-pentane                2    3    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
carbon-tetrachloride     0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      1      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
diethyl-ether            2    1    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     1     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Cyclohexanone            0    4    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      1      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Ethyl-formate            1    1    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      1     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Nitrobenzene             0    0    0   0  0       0      0      0     0    5    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      1      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Dimethyl-sulfide         1    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       1     0     0    0         0      0      0      0         0
2-Methylpentane          3    2    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
2-Pentanol               2    2    1   0  0       0      0      0     0    0    0   0      0      0     1   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
2-Pentanone              1    2    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     1      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
3-Pentanone              2    1    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      1      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
CyclopentylMethylEther   0    4    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     1     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
2-2-4-Trimethylpentane   5    1    1   1  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Methylcyclohexane        1    5    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Methylcyclopentane       1    4    1   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
Propyl-acetate           1    2    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
t-Amyl-methyl-ether      3    1    0   1  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     1     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
t-Butyl-acetate          3    0    0   1  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    1       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
t-Butyl-ethyl-ether      4    0    0   1  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     1     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    0    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
DMF                      0    0    0   0  0       0      0      0     0    0    0   0      0      0     0   0      0    0     0      0      0    0       0       0     0     0     0     0    0       0       0      0      0      0     0     0     0      0      0      0      0      0      0     0      0      0     0    0       0      0     0      0      0     0     0       0       0      0      0    0      0      0         0    0  0   0     0    0     0     0         0    1    0           0    0    0   0    0     0     0    0   0      0     0    0    0      0      0       0      0      0       0      0       0      0        0        0          0          0          0       0       0     0     0    0         0      0      0      0         0
;

table vma(jj,k)'identity of MA, CBA and DMA'
       aCH    aCCH3   aC  ACNH   cooh   aCCl ACNH2
MA     7      2       2   1      1      0     0
CBA    4      0       1   0      1      1     0
DMA    3      2       0   0      0      0     1
;

*===============================================================================
*group interaction parameters
*===============================================================================
*Conduct a sensitivity analysis on the UNIFAC interaction parameters --> a(ACNH2,k)+x & a(k,ACNH2)+x
*k=CH3,CH2,CH,C -> x=-300;  k=OH -> x=-250;  k=CH3COO,CH2COO -> x=-100;  k=CH3O,CH2O,CHO,THF -> x=-400;  k=CONCH3CH3 -> x=-400;  k=DMF -> x=+150;   k=CH2SuCH2 -> x=-50
table a(k,m) 'group interaction parameters'
                                                       (CH3,CH2,CH,C)  (CH2dCH,CHdCH,CH2dC,CHdC,CdC)  (ACH,AC)  (ACCH3,ACCH2,ACCH)   OH         CH3OH      H2O        ACOH       (CH3CO,CH2CO)  CHO       (CH3COO,CH2COO)  HCOO     (CH3O,CH2O,CH-O,THF)  (CH3NH2,CH2NH2,CHNH2)  (CH3NH,CH2NH,CHNH)  (CH3N,CH2N)  (ACNH2)    ACNH      (C5H5N,C5H4N,C5H3N)  (CH3CN,CH2CN)  (COOH,HCOOH)  (CH2CL,CHCL,CCL)  (CH2CL2,CHCL2,CCL2)  (CHCL3,CCL3)  CCL4      ACCL      (CH3NO2,CH2NO2,CHNO2)  ACNO2    CS2       (CH3SH,CH2SH)  FURFURAL  DOH        I         BR      (CHtC,CtC)   DMSO     ACRY     CL-CdC     ACF       (DMF,HCONCH2CH2)  (CF3,CF2,CF)  COO        (SiH3,SiH2,SiH,Si)  (SiH2O,SiHO,SiO)  NMP       (CCL3F,CCL2F,HCCL2F,HCCLF,CCLF2,HCCLF2,CCLF3,CCL2F2)  (CONH2,CONHCH3,CONHCH2,CONCH3CH3,CONCH3CH2,CONCH2CH2)  (C2H5O2,C2H4O2)  (CH3S,CH2S,CHS)  MORFOLIN   (C4H4S,C4H3S,C4H2S)  tert-N     CH2SuCH2
(CH3,CH2,CH,C)                                         0               86.02                          61.13     76.5                 986.5      697.2      1318       1333       476.3999       677       232.1            507      251.5                 391.5                  255.7               206.6        920.7      620.7     287.77               597            663.5         35.93             53.76                24.9          104.3     11.44     661.5                  543      153.6     184.4          354.55    3025       335.8     479.5   298.8999     526.5    689      -4.189     125.8     485.3             -2.859        387.1001   -450.3999           252.7             220.3     -5.869                                                390.9                                                  553.3            187              216.1      92.99                383        808.59
(CH2dCH,CHdCH,CH2dC,CHdC,CdC)                          -35.36          0                              38.81     74.15                524.1001   787.6001   270.6001   526.1001   182.6          448.7998  37.85            333.5    214.5                 240.9                  163.9               61.11        749.3      749.3     280.5                336.8999       318.8999      -36.87            58.55                -13.99        -109.7    100.1     357.5                  0        76.3      0              262.9     0          0         183.8   31.14        179      -52.87   -66.46     359.3     -70.45            449.4         48.33      0                   0                 86.46     0                                                     200.2                                                  268.1            -617             62.56      0                    0          200.94
(ACH,AC)                                               -11.12          3.446                          0         167                  636.1001   637.3999   903.8      1329       25.77          347.2998  5.994            287.1    32.14                 161.7                  122.8               90.49        648.2      648.2     -4.449               212.5          537.3999      -18.81            -144.4               -231.9        3         187       168                    194.9    52.07     -10.43         -64.69    210.4      113.3     261.3   154.26       169.9    383.9    -259.1001  389.3     245.6             22.67         103.5      -432.2998           238.9             30.04     -88.11                                                0                                                      333.3            0                -59.58     -39.16               109        360.82
(ACCH3,ACCH2,ACCH)                                     -69.7           -113.6                         -146.8    0                    803.2      603.3      5695       884.8999   -52.1          586.5999  5688             197.8    213.1                 19.02                  -49.29              23.5         664.2      664.2     52.8                 6096           872.3         -114.1            -111                 -80.25        -141.3    -211      3629                   4448     -9.451    393.6          48.49     4975       259       210     -152.55      4284     -119.2   -282.5     101.4     5629              -245.39       69.26      0                   0                 46.38     0                                                     0                                                      421.9            0                -203.6     184.9                1320       233.51
OH                                                     156.4           457                            89.6      25.82                0          -137.1     353.5      -259.7     84             -203.6    101.1            267.8    28.06                 8.642                  42.7                -323         -52.39     -302.39   170                  6.712          199           75.62             65.28                -98.12        143.1     123.5     256.5                  157.1    488.9     147.5          -120.5    -318.8999  313.5     202.1   727.8        -202.1   74.27    225.8      44.78     -143.9            0             190.3      -817.7              0                 -504.2    72.96                                                 -382.7                                                 -248.3           0                104.7      57.65                0          215.81
CH3OH                                                  16.51           -12.52                         -50       -44.5                249.1      0          -181       -101.7     23.39          306.3999  -10.72           179.7    -128.6                359.3                  -20.98              53.9         489.7      489.7     580.5                53.28          -202          -38.32            -102.5               -139.4        -44.76    -28.25    75.14                  457.88   -31.09    17.5           -61.76    -119.2     212.1     106.3   -119.1       -399.3   -5.224   33.47      -48.25    -172.4            0             165.7      0                   0                 0         -52.1                                                 0                                                      0                37.63            -59.4      -46.01               214        150.02
H2O                                                    300             496.1001                       362.3     377.6001             -229.1     289.6001   0          324.5      -195.4         -116      72.87            233.87   540.5                 48.89                  168                 304          243.2      243.2     459                  112.6          -14.09        325.3999          370.3999             353.7         497.5     133.9     220.6                  399.5    887.1001  0              188       12.72      0         777.1   0            -139     160.8    0          0         319               0             -197.5     -363.8              0                 -452.2    0                                                     835.6                                                  139.6            0                407.9        0                  365        -255.63
ACOH                                                   275.8           217.5                          25.34     244.2                -451.6001  -265.2     -601.8     0          -356.1001      -271.1    -449.3999        -32.52   -162.9                -832.97                0                   0            119.9      119.9     -305.5               0              408.9         0                 517.27               0             1827      6915      0                      -413.48  8484      0              0         -687.1001  0         0       0            0        0        0          0         0                 0             -494.2     0                   0                 -659      0                                                     0                                                      0                0                0          1005                 0          0
(CH3CO,CH2CO)                                          26.76           42.92                          140.1     365.8                164.5      108.7      472.5      -133.1     0              -37.36    -213.7           -190.4   -103.6                0                      -174.2              -169         6201       6201      7.341                481.7          669.3999      -191.7            -130.3               -354.6001     -39.2     -119.8    137.5                  548.5    216.1     -46.28         -163.7    71.46      53.59     245.2   -246.6       -44.58   -63.5    -34.57     0        -61.7              0             -18.8      -588.8999           0                 0         0                                                     0                                                      37.54            0                0          -162.6               135        0
CHO                                                    505.7           56.3                           23.39     106                  529        -340.2     480.8      -155.6     128            0         -110.3           766      304.1001              0                      0                   0            0          0         0                    -106.4         497.5         751.8999          67.52                -483.7        0         0         0                      0        0         0              0         0          117       0       2.21         0        -339.2   172.4      0        -268.8             0             -275.5     0                   0                 0         0                                                     0                                                      0                0                0          0                    -7.18      0
(CH3COO,CH2COO)                                        114.8           132.1                          85.84     -170                 245.4      249.6      200.8      -36.72     372.2          185.1     0                -241.8   -235.7                0                      -73.5               -196.7       475.5      375.5     -0.13                494.6001       660.2         -34.74            108.9                -209.7        54.57     442.4     -81.13                 0        183       0              202.3     -101.7     148.3     18.88   71.48        52.08    -28.61   -275.2     0        85.33              0             560.2      0                   0                 0         0                                                     0                                                      151.8            0                0          0                    -56.4      0
HCOO                                                   329.3           110.4                          18.12     428                  139.4      227.8      124.63     -234.25    385.4          -236.5    1167             0        -234                  0                      0                   0            0          0         -233.4               -47.25         -268.1        0                 31                   -126.2        179.7     24.28     0                      0        0         103.9          0         0          0         298.13  0            0        0        -11.4      0        308.9              0             -122.3     0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CH3O,CH2O,CH-O,THF)                                   83.36           26.51                          52.13     65.69                237.7      238.4      -314.7     -178.5     191.1          -7.838    461.3            457.3    0                     -78.36                 251.5               5422         -46.39     -446.39   213.2                -18.51         664.6001      301.1001          137.8                -154.3        47.67     134.8     95.18                  155.11   140.9     -8.538         170.1     -20.11     -149.5    -202.3  -156.57      128.8    0        240.2      -274     254.8              -172.51       417        1338                0                 0         0                                                     0                                                      0                0                0          0                    5780       0
(CH3NH2,CH2NH2,CHNH2)                                  -30.48          1.163                          -44.85    296.4                -242.8     -481.7     -330.3999  -870.8     0              0         0                0        222.1                 0                      -107.2              -41.11       -200.7     -200.7    0                    358.9          0             -82.92            0                    0             -99.81    30.05     0                      0        0         -70.14         0         0          0         0       0            874.19   0        0          0        -164               0             0          -664.4              275.9             0         0                                                     0                                                      0                0                0          0                    0          0
(CH3NH,CH2NH,CHNH)                                     65.33           -28.7                          -22.31    223                  -150       -370.3     -448.2     0          394.6          0         136              0        -56.08                127.4                  0                   -189.2       138.54     138.54    431.49               147.1          0             0                 0                    0             71.23     -18.93    0                      0        0         0              0         939.07     0         0       0            0        0        0          570.9    -255.22            0             -38.77     448.1               -1327             0         0                                                     0                                                      0                0                0          0                    0          0
(CH3N,CH2N)                                            -83.98          -25.38                         -223.9    109.9                28.6       -406.8     -598.8     0          225.3          0         2889             0        -194.1                38.89                  865.8999            0            287.43     287.43    0                    1255.1         0             -182.91           -73.85               -352.8999     -262      -181.9    0                      0        0         0              0         0          0         0       0            243.1    0        0          -196.3   22.05              0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
ACNH2                                                  1139            2000                           247.5     762.8                -17.4      -118.1     -341.6     -253.1     -450.3         0         -294.8           0        285.36                -15.07                 64.3                -24.46       0          0         89.7                 -281.6001      -396          287               -111                 0             882       617.5     0                      -139.3   0         0              0         0.1004     0         0       0            0        0        0          0        -334.3999          0             -89.42     0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
*Obtained after sensitivity analysis on parameters for ACNH2
ACNH                                                   839             2000                           247.5     762.8                -267.4     -118.1     -341.6     -253.1     -450.3         0         -394.8           0        -114.64               -15.07                 64.3                -24.46       0          0         89.7                 -281.6001      -396          287               -111                 0             882       617.5     0                      -139.3   0         0              0         0.1004     0         0       0            0        0        0          0        -184.3999          0             -89.42     0                   0                 0         0                                                     -400                                                   0                0                0          0                    0          -50
(C5H5N,C5H4N,C5H3N)                                    -101.6          -47.63                         31.87     49.8                 -132.3     -378.2     -332.8999  -341.6001  29.1           0         8.87             554.     -156.1                0                      -207.66             0            117.4      117.4     0                    -169.7         -153.7        0                 -351.6001            -114.7        -205.3    -2.17     0                      2845     0         0              0         0          0         -60.78  0            0        0        160.7      -158.8   0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          -136.6               0          0
(CH3CN,CH2CN)                                          24.82           -40.62                         -22.97    -138.4               185.4      162.6      242.8      0          -287.5         224.66    -266.6001        99.37    38.81                 -157.3                 -108.5              -446.86      777.3999   777.3999  134.3                0              205.27        4.933             -152.7               -15.62        -54.86    -4.624    -0.515                 0        230.9     0.4604         0         177.5      0         -62.17  -203         0        81.57    -55.77     0        -151.5             0             120.3      0                   0                 0         0                                                     0                                                      16.23            0                0          0                    0          0
(COOH,HCOOH)                                           315.3           1264                           62.32     89.86                -151       339.8      -66.17     -11        -297.8         -165.5    -256.3           193.9    -338.5                0                      0                   0            493.8      493.8     -313.5               92.07          0             13.41             -44.7                39.63         183.4     -79.08    0                      0        0         0              -208.9    0          228.4     -95     0            -463.6   0        -11.16     0        -228               0             -337       169.3               0                 0         0                                                     -322.3                                                 0                0                0          0                    0          0
(CH2CL,CHCL,CCL)                                       91.46           40.25                          4.68      122.9                562.2      529        698.2      0          286.3          -47.51    35.38            0        225.4                 131.2                  0                   151.38       429.7      429.7     0                    54.32          519.1         0                 108.3                249.6         62.42     153       32.73                  86.2     450.1     59.02          65.56     0          2.22      -344.4  0            0        0        -168.2     0        6.57               0             63.67      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CH2CL2,CHCL2,CCL2)                                    34.01           -23.5                          121.3     140.8                527.6      669.8999   708.7      1633.5     82.86          190.6     -133             80.99    -197.7                0                      0                   -141.4       140.8      140.8     587.3                258.6001       543.3         -84.53            0                    0             56.33     223.1     108.9                  0        0         0              149.56    0          177.6     315.9   0            215      0        -91.8      0        -160.28            0             -96.87     0                   0                 0         0                                                     0                                                      361.1            0                0          0                    0          0
(CHCL3,CCL3)                                           36.7            51.06                          288.5     69.9                 742.1001   649.1001   826.8      0          552.1001       242.8     176.5            235.6    -20.93                0                      0                   -293.7       0          0         18.98                74.04          504.2         -157.1            0                    0             -30.1     192.1     0                      0        116.6     0              -64.38    0          86.4      168.8   0            363.7    0        111.2      0        0                  0             255.8      0                   0                 -35.68    0                                                     0                                                      0                565.9            0          0                    0          0
CCL4                                                   -78.45          160.9                          -4.7      134.7                856.3      709.6      1201       10000      372            0         129.5            351.9    113.9                 261.1001               91.13               316.9        898.2      898.2     368.5                492            631           11.8              17.97                51.9          0         -75.97    490.8999               534.7    132.2     0              546.7     0          247.8     146.6   0            337.7    369.5    187.1      215.2    498.6001           0             256.5      0                   233.1             0         0                                                     0                                                      423.1            63.95            0          108.5                0          585.19
ACCL                                                   106.8           70.32                          -97.27    402.5                325.7      612.8      -274.5     622.3      518.4          0         -171.1           383.3    -25.15                108.5                  102.2               2951         334.9      334.9     20.18                363.5          993.4         -129.7            -8.309               -0.2266       248.4     0         132.7                  2213     0         0              0         0          0         593.4   0            1337.37  0        0          0        5143.14            309.58        -71.18     0                   0                 -209.7    0                                                     0                                                      434.1            0                0          0                    0          0
(CH3NO2,CH2NO2,CHNO2)                                  -32.69          -1.996                         10.38     -97.05               261.6001   252.6      417.8999   0          -142.6         0         129.3            0        -94.49                0                      0                   0            0          0         0                    0.283          0             113               -9.639               0             -34.68    132.9     0                      533.2    320.2     0              0         139.8      304.3     10.17   -27.7        0        0        10.76      0        -223.1             0             248.4      0                   0                 0         -218.9                                                0                                                      0                0                0          -4.565               0          0
ACNO2                                                  5541            0                              1824      -127.8               561.6001   511.29     360.7      815.12     -101.5         0         0                0        220.66                0                      0                   0            134.9      134.9     2475                 0              0             1971              0                    0             514.6001  -123.1    -85.12                 0        0         0              0         0          2990      -124    0            0        0        0          0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
CS2                                                    -52.65          16.62                          21.5      40.68                609.8      914.2      1081       1421       303.7          0         243.8            0        112.4                 0                      0                   0            0          0         0                    335.7          0             -73.09            0                    -26.06        -60.71    0         277.8                  0        0         0              0         0          292.7     0       0            0        0        -47.37     0        0                  0             469.8      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CH3SH,CH2SH)                                          -7.481          0                              28.41     19.56                461.6001   448.6      0          0          160.6          0         0                201.5    63.71                 106.7                  0                   0            0          0         0                    161            0             -27.94            0                    0             0         0         0                      0        0         0              0         0          0         0       0            31.66    0        0          0        78.92              0             0          0                   0                 1004      0                                                     0                                                      0                -18.27           0          0                    0          0
FURFURAL                                               -25.31          82.64                          157.3     128.8                521.6001   287        23.48      0          317.5          0         -146.3           0        -87.31                0                      0                   0            0          0         0                    0              570.6         -39.46            -116.21              48.48         -133.2    0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             43.37      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
DOH                                                    139.9           0                              221.4     150.6                267.6001   240.8      -137.4     838.3999   135.4          0         152              0        9.207                 0                      -213.74             0            192.3      192.3     0                    169.6          0             0                 0                    0             0         0         481.3                  0        0         0              0         0          0         0       0            -417.2   0        0          0        302.2              0             347.8      0                   0                 -262      0                                                     0                                                      -353.5           0                0          0                    0          0
I                                                      128             0                              58.68     26.41                501.3      431.3      0          0          138            245.9     21.92            0        476.6001              0                      0                   0            0          0         0                    0              616.6         179.25            -40.82               21.76         48.49     0         64.28                  2448     -27.45    0              0         0          0         6.37    0            0        0        0          0        0                  0             68.55      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
BR                                                     -31.52          174.6                          -154.2    1112                 524.8999   494.7      79.18      0          -142.6         0         24.37            -92.26   736.3999              0                      0                   0            0          0         -42.71               136.9          5256          -262.3            -174.5               -46.8         77.55     -185.3    125.3                  4288     0         0              0         0          37.1      0       0            32.9     0        -48.33     0        336.25             0             -195.1     0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CHtC,CtC)                                             -72.88          41.38                          -101.12   614.52               68.95      967.71     0          0          443.6001       -55.87    -111.45          0        173.77                0                      0                   0            0          0         0                    329.1001       0             0                 0                    0             0         0         174.4                  0        0         0              0         0          0         0       0            0        0        2073       0        -119.8             0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
DMSO                                                   50.49           64.07                          -2.504    -143.2               -25.87     695        -240       0          110.4          0         41.57            0        -93.51                -366.51                0                   -257.2       0          0         0                    0              -180.2        0                 -215                 -343.6001     -58.43    -334.12   0                      0        0         85.7           0         535.8      0         -111.2  0            0        0        0          0        -97.71             0             153.7      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
ACRY                                                   -165.9          573                            -123.6    397.4                389.3      218.8      386.6001   0          114.55         354       175.5            0        0                     0                      0                   0            0          0         0                    -42.31         0             0                 0                    0             -85.15    0         0                      0        0         0              0         0          0         0       0            0        0        -208.8     0        -8.804             0             423.3999   0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
CL-CdC                                                 47.41           124.2                          395.8     419.1                738.8999   528        0          0          -40.9          183.8     611.3            134.5    -217.9                0                      0                   0            0          0         281.6                335.2          898.2         383.2             301.9                -149.8        -134.2    0         379.3999               0        167.9     0              0         0          0         322.42  631.5        0        837.2    0          0        255                0             730.8      0                   0                 26.35     0                                                     0                                                      0                2429             0          0                    0          0
ACF                                                    -5.132          -131.7                         -237.2    -157.3               649.7      645.8999   0          0          0              0         0                0        167.3                 0                      -198.8              116.5        0          0         159.8                0              0             0                 0                    0             -124.6    0         0                      0        0         0              0         0          0         0       0            0        0        0          0        -110.65            -117.2        0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(DMF,HCONCH2CH2)                                       -31.95          249                            -133.9    -240.2               64.16      172.2      -287.1001  0          97.04          13.89     -82.12           -116.7   -158.2                49.7                   10.03               -185.2       343.7      493.7     0                    150.6          -97.77        -55.21            397.24               0             -186.7    -374.16   223.6                  0        0         -71            0         -191.7     0         -176.26 6.699        136.6    5.15     -137.7     50.06    0                  -5.579        72.31      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CF3,CF2,CF)                                           147.3           62.4                           140.6     839.83               0          0          0          0          0              0         0                0        278.15                0                      0                   0            0          0         0                    0              0             0                 0                    0             0         33.95     0                      0        0         0              0         0          0         0       0            0        0        0          185.6    55.8               0             0          0                   0                 0         111.8                                                 0                                                      0                0                0          0                    0          0
COO                                                    529             1397                           317.6001  615.8                88.63      171        284.3999   -167.3     123.4          577.5     -234.9           145.4    -247.8                0                      284.5               0            -22.1      -22.1     0                    -61.6          1179          182.2             305.3999             -193          335.7     956.1     -124.7                 0        885.5     0              -64.28    -264.3     288.1001  627.7   0            -29.34   -53.91   -198       0        -28.65             0             0          0                   0                 0         0                                                     0                                                      122.4            0                0          0                    0          0
(SiH3,SiH2,SiH,Si)                                     -34.36          0                              787.8999  0                    1913       0          180.2      0          992.3999       0         0                0        448.5                 961.8                  1464                0            0          0         0                    0              2450          0                 0                    0             0         0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          0                   -2166             0         0                                                     0                                                      0                0                0          0                    0          0
(SiH2O,SiHO,SiO)                                       110.2           0                              234.4     0                    0          0          0          0          0              0         0                0        0                     -125.2                 1604                0            0          0         0                    0              2496          0                 0                    0             70.81     0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          745.2998            0                 0         0                                                     0                                                      0                0                0          0                    0          0
NMP                                                    13.89           -16.11                         -23.88    6.214                796.8999   0          832.2      -234.7     0              0         0                0        0                     0                      0                   0            0          0         0                    0              0             0                 0                    -196.2        0         161.5     0                      0        0         -274.1         0         262        0         0       0            0        0        -66.31     0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CCL3F,CCL2F,HCCL2F,HCCLF,CCLF2,HCCLF2,CCLF3,CCL2F2)   30.74           0                              167.9     0                    794.4      762.7      0          0          0              0         0                0        0                     0                      0                   0            0          0         0                    0              0             0                 0                    0             0         0         844                    0        0         0              0         0          0         0       0            0        0        0          0        0                  -32.17        0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CONH2,CONHCH3,CONHCH2,CONCH3CH3,CONCH3CH2,CONCH2CH2)  27.97           9.755                          0         0                    394.8      0          -509.3     0          0              0         0                0        0                     0                      0                   0            0          -400      0                    0              -70.25        0                 0                    0             0         0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(C2H5O2,C2H4O2)                                        -11.92         132.4                           -86.88    -19.45               517.5      0          -205.7     0          156.4          0         -3.444           0        0                     0                      0                   0            0          0         0                    119.2          0             0                 -194.7               0             3.163     7.082     0                      0        0         0              0         515.8      0         0       0            0        0        0          0        0                  0             101.2      0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(CH3S,CH2S,CHS)                                        39.93          543.6                           0         0                    0          420        0          0          0              0         0                0        0                     0                      0                   0            0          0         0                    0              0             0                 0                    -363.1        -11.3     0         0                      0        0         6.971          0         0          0         0       0            0        0        148.9      0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
MORFOLIN                                               -23.61         161.1                           142.9     274.1                -61.2      -89.24     -384.3     0          0              0         0                0        0                     0                      0                   0            0          0         0                    0              0             0                 0                    0             0         0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
(C4H4S,C4H3S,C4H2S)                                    -8.479         0                               23.93     2.845                682.5      597.8      0          810.5      278.8          0         0                0        0                     0                      0                   0            0          0         221.4                0              0             0                 0                    0             -79.34    0         176.3                  0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
tert-N                                                 272            0                               -288      1020                 0          -668       -1080      0          -435           -686      -463             0        2880                  0                      0                   0            0          0         0                    0              0             0                 0                    0             0         0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
CH2SuCH2                                               245.21         384.45                          47.05     347.13               72.19      265.75     627.39     0          0              0         0                0        0                     0                      0                   0            0          -50       0                    0              0             0                 0                    0             75.04     0         0                      0        0         0              0         0          0         0       0            0        0        0          0        0                  0             0          0                   0                 0         0                                                     0                                                      0                0                0          0                    0          0
;

*===============================================================================
*Table for boiling/melting temperatures
*===============================================================================
*Data from NIST Database (https://webbook.nist.gov/chemistry/name-ser/)
*or Chemical Book Database (https://www.chemicalbook.com/)
table
prop(s,prp)                Boiling Melting(K)   MolarMass(g_mol)   Density (g_mL at 25oC)
                           p1      p2           p3                 p4
1-2-dimethoxyethane        358.15  204.15       90.12              0.867
1-2-propanediol            460.15  213.15       76.09              1.036
1-4-dioxane                374.15  285.15       88.11              1.034
Acetic-acid                391     289          60.052             1.049
Acetone                    329.2   178.5        58.08              0.791
Acetonitrile               355     228          41.053             0.78
Chlorobenzene              404     228          112.559            1.1075
Chloroform                 334.4   209.7        119.378            1.492
Cyclohexane                353.89  279.62       84.162             0.779
Diethoxymethane            361.15  206.65       104.15             0.831
DMAC                       438.2   253          87.12              0.937
Ethanol                    351.39  159.01       46.069             0.789
Ethylacetate               350.2   189.6        88.107             0.902
Formic-acid                373.9   281.5        46.025             1.22
i-butylacetate             399.2   195          116.16             0.873
i-propylacetate            362     200          102.13             0.872
Isobutanol                 381.04  165          74.123             0.803
Isopropanol                355.8   184          60.096             0.785
Methylacetate              330     175          74.08              0.932
MIBK                       390     188.5        100.161            0.801
MEK                        353.15  186.15       72.11              0.806
MTBE                       328.3   164          88.15              0.7404
n-butanol                  390.8   183.3        74.123             0.81
2-Butanol                  373     158          74.123             0.808
n-heptane                  371.53  182.6        100.205            0.684
n-hexane                   342     178          86.178             0.659
Nitromethane               374.3   244.5        61.041             1.127
o-xylene                   417.5   249          106.168            0.879
t-AmOH                     375     264          88.15              0.805
t-butanol                  355     298          74.123             0.81
Toluene                    384     178          92.141             0.866
Triethylamine              362     158.45       101.193            0.728
Water                      373.15  273.15       18.015             0.998
Anisole                    427     236          108.14             0.995
n-butylacetate             399.2   195          116.15828          0.88
trifluoroethanol           347.1   229.7        100.04             1.391
trifluoroacetic-acid       345.5   257.8        114.024            1.535
1-propanol                 370     147          60.096             0.804
n-pentane                  309     143          72.151             0.626
carbon-tetrachloride       349.87  250.23       153.82             1.594
diethyl-ether              307.8   256.8        74.123             0.714
Cyclohexanone              420.8   226          98.14              0.947
Ethyl-formate              327.1   193          74.079             0.921
Nitrobenzene               484     278.8        123.11             1.205
Dimethyl-sulfide           311     175          62.13              0.846
2-Methylpentane            334     120          86.178             0.66
2-Pentanol                 392     200          88.1482            0.812
2-Pentanone                375     196          86.1323            0.809
3-Pentanone                375     234.2        86.1323            0.815
CyclopentylMethylEther     379     133          100.1589           0.86
2-2-4-Trimethylpentane     372.4   165.77       114.2285           0.692
Methylcyclohexane          374     146.6        98.1861            0.77
Methylcyclopentane         345     131          84.1595            0.749
Propyl-acetate             374.7   178.15       102.1317           0.888
t-Amyl-methyl-ether        359.4   193          102.1748           0.77
t-Butyl-acetate            369.8   211.15       116.1583           0.866
t-Butyl-ethyl-ether        346     179.15       102.1748           0.742
DMF                        426.15  212.15       73.09              0.948
;

*===============================================================================
*Table for GSK Safety Data (http://www.rsc.org/suppdata/gc/c0/c0gc00918k/c0gc00918k.pdf)
*comounds not included in the GSK solvent list, values (1,1,1,1) are assigned
*===============================================================================
table
gsk(s,f)              Flammability Reactivity  Environ  Health
                           f1          f2        f3       f4
1-2-dimethoxyethane        4           4         5        2
1-2-propanediol            10          10        6        10
1-4-dioxane                4           5         4        4
Acetic-acid                8           7         8        6
Acetone                    4           9         9        8
Acetonitrile               6           10        6        6
Chlorobenzene              8           10        6        4
Chloroform                 6           9         6        3
Cyclohexane                2           10        5        7
Diethoxymethane            4           8         5        3
DMAC                       10          8         6        2
Ethanol                    6           9         8        8
Ethylacetate               4           8         8        8
Formic-acid                7           7         8        4
i-butylacetate             8           10        7        8
i-propylacetate            6           9         7        7
Isobutanol                 8           9         8        7
Isopropanol                6           8         9        8
Methylacetate              4           9         9        7
MIBK                       7           8         6        6
MEK                        4           8         7        8
MTBE                       3           9         5        5
n-butanol                  8           9         7        5
2-butanol                  7           9         6        8
n-heptane                  3           10        3        8
n-hexane                   2           10        3        4
Nitromethane               7           2         8        4
o-xylene                   5           10        2        6
t-AmOH                     8           10        7        6
t-butanol                  6           10        9        6
Toluene                    4           10        3        4
Triethylamine              4           8         5        3
Water                      10          10        10       10
Anisole                    7           6         6        7
n-butylacetate             8           10        7        8
trifluoroethanol           6           9         5        2
trifluoroacetic-acid       7           8         5        6
1-propanol                 7           10        7        5
n-pentane                  2           10        6        8
carbon-tetrachloride       4           10        5        3
diethyl-ether              2           4         4        5
Cyclohexanone              8           9         8        6
Ethyl-formate              4           9         6        5
Nitrobenzene               1           1         1        1
Dimethyl-sulfide           1           1         1        1
2-Methylpentane            2           10        4        7
2-Pentanol                 8           8         6        6
2-Pentanone                7           10        6        6
3-Pentanone                7           6         6        8
CyclopentylMethylEther     5           8         4        4
2-2-4-Trimethylpentane     8           3         6        4
Methylcyclohexane          3           10        5        8
Methylcyclopentane         2           9         4        5
Propyl-acetate             6           10        7        8
t-Amyl-methyl-ether        5           9         5        5
t-Butyl-acetate            6           10        9        8
t-Butyl-ethyl-ether        4           9         5        4
;

set ep 'GSK criteria (sc) lower bound'
/1*10/
;
set din2(ep);

Parameter GSK_lob     "lower GSK safety criteria values" ;

Parameter GSK_lo(ep)
/
1  0
2  1
3  2
4  3
5  4
6  5
7  6
8  7
9  8
10 9
/
;
alias (ep,epp);

PARAMETERS
*NIST Database (https://webbook.nist.gov/cgi/cbook.cgi?ID=C61687&Mask=4#Thermo-Phase)
Hm(jj) 'enthalpy of fusion of MA, CBA and DMA in J/mol for reaction stage calculations'
/MA    38700
 CBA   26290
 DMA   14940  /

Tm(jj) 'melting point of MA, CBA and DMA in J/mol for reaction stage calculations'
/MA    503.5
 CBA   414.1
 DMA   276.7   /

Rg 'gas constant' /8.3144/   ;

parameter nma(jj,k);
nma(jj,k)= vma(jj,k);
parameter qma(jj);
qma(jj) = sum(k,nma(jj,k)*GS(k,'Q'));
parameter rma(jj);
rma(jj) = sum(k,nma(jj,k)*GS(k,'R'));
parameter qs(s);
qs(s) = sum(k,tb(s,k)*GS(k,'Q'));
parameter rs(s);
rs(s) = sum(k,tb(s,k)*GS(k,'R'));
parameter ema(jj,k);
ema(jj,k)=vma(jj,k)*GS(k,'Q')/qma(jj);

Parameter MwMA(jj) 'molas mass of solids in g/mol'
/MA    241.285
 CBA   156.566
 DMA   121.18    /;

*Define parameters to perform integer cuts
Parameter
nk(ic,ii,k)
yk(ic,ii,s)
xk(ic,i,t)

zk1(ep,ic)
yk1(ep,ic,ii,s)
xk1(ep,ic,i),xk2(ep,ic,i),
xk4(ep,ic,i)
nm1(ep,ic,i),nm2(ep,ic,i),nm3(ep,ic,i),nm4(ep,ic,i),nm5(ep,ic,i)
mass1(ep,ic,i),mass2(ep,ic,i),mass3(ep,ic,i),mass4(ep,ic,i),mass5(ep,ic,i)
Yield1(ep,ic,jj),
T1(ep,ic)
T4(ep,ic)
xa1(ep,ic,i)
xb1(ep,ic,i)
xb3(ep,ic,i)
xc1(ep,ic,i)
R11(ep,ic,i)
R21(ep,ic,i)
R31(ep,ic,i)
Mass_total1(ep,ic)
Ratio_react11(ep,ic)
Ratio_react21(ep,ic)
PEF1(ep,ic);

POSITIVE VARIABLES
x(i,t)            'liquid phase mole fraction of component i in stream t'
Mw(i)             'molecular mass of component i [g/mol]'
mass(i,t)         'mass of component i in stream t [g]'
nm(i,t)           'moles of component i in stream t [mol]'
nmt(t)            'total moles in stream t [mol]'
Tp(t)             'process temperature in stream t [K]'
Tbs(ii)           'boiling point of solvent ii [K]'
Tms(ii)           'melting point of solvent ii [K]'

rc(i)             'van der waals volume of component i'
qc(i)             'van der waals area of component i'
th(k,strM)
w(k,strM)

Yield(jj)         'crystal yield of MA, CBA and DMA'

**************Hypothetical Stream Variables*************************************
xra1(i)
Jra1,Lra1,thra1(k),wra1(k)
xra2(i)
Jra2,Lra2,thra2(k),wra2(k)
xrb1(i)
Jrb1,Lrb1,thrb1(k),wrb1(k)
xrb2(i)
Jrb2,Lrb2,thrb2(k),wrb2(k)
xrb3(i)
Jrb3,Lrb3,thrb3(k),wrb3(k)

JcMA,LcMA,thcMA(k),wcMA(k)

xcc1(i)
Jcc1,Lcc1,thcc1(k),wcc1(k)
xcc2(i)
Jcc2,Lcc2,thcc2(k),wcc2(k)
********************************************************************************

*Miscibility of solvents in relevant streams, i.e. stream 1 and 4
x12(ii,strM)
th12(k,strM)
w12(k,strM)
sumr12(strM)
sumq12(strM)
b12(ii,k,strM)

*Variables to be reported
Mass_total
Ratio_react1
Ratio_react2
R1(i)
R2(i)
R3(i)

z

sc(ii,f)    GSK environmental & safety index

FREE VARIABLES
PEF
ps(k,m,strM)
bmra1(k)
bmra2(k)
bmrb1(k)
bmrb2(k)
bmrb3(k)

bmcMA(k)
bmcc1(k)
bmcc2(k)
**************Hypothetical Stream Variables*************************************
lngc_ra1,lngr_ra1,lng_ra1
lngc_ra2,lngr_ra2,lng_ra2
lngc_rb1,lngr_rb1,lng_rb1
lngc_rb2,lngr_rb2,lng_rb2
lngc_rb3,lngr_rb3,lng_rb3

lngc_cMA,lngr_cMA,lng_cMA
lngc_cc1,lngr_cc1,lng_cc1
lngc_cc2,lngr_cc2,lng_cc2
********************************************************************************
d_lngc12(ii,strM)  'differention of combinatorial act_coeff'
d_lngr12(ii,strM)  'differention of residual act_coeff'
d_lng12(ii,strM)   'differentiation of act_coef wrt to x(ii)'
d_th12(k,strM)     'diff of intermediate'
d_w12(k,strM)      'diff of intermediate'
a12(k,strM)        'intermediate'
c12(k,strM)        'intermediate'

BINARY VARIABLES
y(ii,s)     'solvent choice'

INTEGER VARIABLE
n(i,k)    'number of groups k in component i';

EQUATIONS
*Reaction Equations
eq_rs
eq_cs
eq_T1(ii),eq_T2(ii),eq_T3(ii)
eq_Tb(ii)
eq_Tm(ii)
eq_T4
eq_T5

eq_n1(ii,k),eq_n2(jj,k),
eq_nt(t)
eq_n(i,t)
eq_m(i,t)
eq_Mw(ii),eq_MwMA(jj)

eq_qc1(ii),eq_qc2(jj)
eq_rc1(ii),eq_rc2(jj)
eq_ps(k,m,strM)

*Crystallisation Equations
eq_z                          'objective function minimise solvent use'
eq_yield(jj),
eq_s1
eq_s2
eq_API

*Variables to be reported
eq_var1, eq_var2, eq_var3, eq_var4, eq_var5(i), eq_var6(i), eq_var7(i)

**************Hypothetical Stream Equations*************************************
eq_Jra1,eq_Lra1,eq_lngcra1,eq_bmra1(k),eq_thra1(k),eq_wra1(k),eq_lngrra1,eq_lngra1
eq_ratioa11(i),
*eq_Jra2,eq_Lra2,eq_lngcra2,eq_bmra2(k),eq_thra2(k),eq_wra2(k),eq_lngrra2,eq_lngra2
*eq_ratioa21(i)
eq_Jrb1,eq_Lrb1,eq_lngcrb1,eq_bmrb1(k),eq_thrb1(k),eq_wrb1(k),eq_lngrrb1,eq_lngrb1
eq_ratiob11(i),
*eq_Jrb2,eq_Lrb2,eq_lngcrb2,eq_bmrb2(k),eq_thrb2(k),eq_wrb2(k),eq_lngrrb2,eq_lngrb2
*eq_ratiob21(i)
eq_Jrb3,eq_Lrb3,eq_lngcrb3,eq_bmrb3(k),eq_thrb3(k),eq_wrb3(k),eq_lngrrb3,eq_lngrb3
eq_ratiob31(i),

eq_xra1sum
*eq_xra2sum
eq_xrb1sum
*eq_xrb2sum
eq_xrb3sum,eq_xcc1sum
*eq_xcc2sum

eq_JcMA,eq_LcMA,eq_lngccMA,eq_bmcMA(k),eq_thcMA(k),eq_wcMA(k),eq_lngrcMA,eq_lngcMA
eq_Jcc1,eq_Lcc1,eq_lngccc1,eq_bmcc1(k),eq_thcc1(k),eq_wcc1(k),eq_lngrcc1,eq_lngcc1
eq_ratioc11(i)
*eq_Jcc2,eq_Lcc2,eq_lngccc2,eq_bmcc2(k),eq_thcc2(k),eq_wcc2(k),eq_lngrcc2,eq_lngcc2
*eq_ratioc21(i)
********************************************************************************

eq_soluba1
*eq_soluba21
*eq_soluba22
eq_solubb1,
*eq_solubb21
*eq_solubb22
eq_solubb3
eq_solubc1
*eq_solubc21
*eq_solubc22
eq_solub1r,eq_solub2r,eq_solub3r
eq_solub1c
eq_rb1, eq_rb2, eq_rb3, eq_rb4, eq_cb(i)
eq_solubMA

*Equations for logical conditions
logic1a
logic1b
logic2(s)
logic3(t)
*logic4(t)

cut1(ic),cut2(ic)

*Safety Constraint
eq_sc(ii,f)
eq_safety(ii,f)

*Miscibility equations
eq_misc1(strM),eq_misc2(strM), eq_misc3(strM), eq_misc4(strM), eq_misc5(strM), eq_misc6(strM), eq_misc7(strM), eq_misc8(strM), eq_misc9(strM), eq_misc10(strM)
eq_misc11(k,strM),eq_misc12(k,strM),eq_misc13(k,strM),eq_misc14(k,strM),eq_misc15(k,strM),eq_misc16(k,strM),eq_misc17(k,strM),eq_misc18(k,strM),eq_misc19(strM),eq_misc20(strM)
eq_misc21(strM),eq_misc22(strM), eq_misc23(strM);

*Logic Equations
logic1a..sum(s,y('s1',s))=e=1;
logic1b..sum(s,y('s2',s))=l=1;
logic2(s)..y('s1',s)+y('s2',s)=l=1;

logic3(t)$(not sameas(t,'t5'))..x('s2',t) =l= sum(s,y('s2',s));
*logic4(t)$(not sameas(t,'t5'))..x('s2',t) =g= 0.001*sum(s,y('s2',s));

*Reaction Equations
eq_T1(ii)..Tp('t1') =l= Tbs(ii)-10 + 600*(1-sum(s,y(ii,s)));
eq_T2(ii)..Tp('t1') =g= Tms(ii)+10 - 600*(1-sum(s,y(ii,s)));
eq_T3(ii)..Tp('t4')  =g= Tms(ii)+10 - 600*(1-sum(s,y(ii,s)));
eq_T4..Tp('t1')=e=Tp('t2');
eq_T5..Tp('t2')=g=Tp('t4');

eq_Tb(ii)..Tbs(ii)=e=sum(s,prop(s,'p1')*y(ii,s));
eq_Tm(ii)..Tms(ii)=e=sum(s,prop(s,'p2')*y(ii,s));

eq_rs..nm('s1','t1')=e=nm('s1','t2');
eq_cs..nm('s2','t1')=e=nm('s2','t2');
eq_nt(t)..nmt(t)=e= sum(i,nm(i,t));
eq_n(i,t)..x(i,t)*nmt(t)=e=nm(i,t);
eq_m(i,t)..mass(i,t)=e=nm(i,t)*Mw(i);

eq_Mw(ii)..Mw(ii)=e=sum(s,prop(s,'p3')*y(ii,s));
eq_MwMA(jj)..Mw(jj)=e=MwMA(jj);
eq_n1(ii,k)..n(ii,k)=e=sum(s,tb(s,k)*y(ii,s));
eq_n2(jj,k)..n(jj,k)=e=vma(jj,k);

eq_rb1..nm('MA','t2')=e=0.9*nm('CBA','t1');
eq_rb2..nm('DMA','t2')=e=nm('DMA','t1') - nm('MA','t2');
eq_rb3..nm('CBA','t2')=e=nm('CBA','t1') - nm('MA','t2');
eq_rb4..nm('CBA','t1')=e=0.5*nm('DMA','t1');
eq_cb(i)..nm(i,'t2')+nm(i,'t3')=e=nm(i,'t4')+nm(i,'t5');

*Crystallisation Equations
eq_z.. z*mass('MA','t5') =e= mass('s1','t4') + mass('s2','t4');
eq_yield(jj)..Yield(jj)*nm(jj,'t2')=e=nm(jj,'t5');
eq_s1.. nm('s1','t2')=e=nm('s1','t4');
eq_s2.. nm('s2','t2')=l=nm('s2','t4');
eq_API(jj).. nm(jj,'t2')=g=nm(jj,'t4');

*UNIFAC Equations
eq_qc1(ii)..qc(ii)=e= sum(s,qs(s)*y(ii,s));
eq_rc1(ii)..rc(ii)=e= sum(s,rs(s)*y(ii,s));
eq_qc2(jj)..qc(jj)=e=qma(jj);
eq_rc2(jj)..rc(jj)=e=rma(jj);
eq_ps(k,m,strM)..ps(k,m,strM)=e= exp(-a(k,m)/Tp(strM));

*Variables to be reported
eq_var1..Mass_total =e= mass('s1','t4') + mass('s2','t4');
eq_var2..Ratio_react1*nm('s2','t1') =e= nm('s1','t1');
eq_var3..Ratio_react2*nm('s2','t4') =e= nm('s1','t4');
eq_var4..PEF*mass('MA','t5') =e= mass('MA','t4') + mass('DMA','t4') + mass('CBA','t4') + mass('s1','t4') + mass('s2','t4');

eq_var5(i)$(not sameas(i,'DMA') and not sameas(i,'s1'))..R1(i)*x('s1','t1') =e= x(i,'t1');
eq_var6(i)$(not sameas(i,'DMA') and not sameas(i,'s1'))..R2(i)*x('s1','t2') =e= x(i,'t2');
eq_var7(i)$(not sameas(i,'DMA') and not sameas(i,'s1'))..R3(i)*x('s1','t4') =e= x(i,'t4');

*combinatorial part of activity coefficient
*eq_Jr(jj,strR)..Jr(jj,strR)*sum(i,xr(i,strR)*rc(i))=e=rma(jj);
*eq_Lr(jj,strR)..Lr(jj,strR)*sum(i,xr(i,strR)*qc(i))=e=qma(jj);
*eq_lngcr(jj,strR)..lngc_r(jj,strR)=e=1-Jr(jj,strR)+log(Jr(jj,strR))-5*qma(jj)*(1-Jr(jj,strR)/Lr(jj,strR)+log(Jr(jj,strR))-log(Lr(jj,strR)));
*residual part of activity coefficient
*eq_bmr(jj,k,strR)..bmr(jj,k,strR) =e= sum(m,ema(jj,m)*psr(m,k,strR));
*eq_thr(k,strR)..thr(k,strR)*sum(i,xr(i,strR)*qc(i))=e=sum(i,xr(i,strR)*GS(k,'Q')*n(i,k));
*eq_wr(k,strR)..wr(k,strR)=e=sum(m,thr(m,strR)*psr(m,k,strR));
*eq_lngrr(jj,strR)..lngr_r(jj,strR)=e=qma(jj)*(1-sum(k,thr(k,strR)*bmr(jj,k,strR)/wr(k,strR)-ema(jj,k)*(log(bmr(jj,k,strR))-log(wr(k,strR)))));
*activity coefficient
*eq_lngr(jj,strR)..lng_r(jj,strR) =e=  lngc_r(jj,strR) + lngr_r(jj,strR);

*eq_psr1(k,m)..psr1(k,m)=e= exp(-a(k,m)/Tr('t1'));
*eq_psr2(k,m)..psr2(k,m)=e= exp(-a(k,m)/Tr('t2'));

*Hypothetical a1
eq_Jra1..Jra1*sum(i,xra1(i)*rc(i))=e=rma('CBA');
eq_Lra1..Lra1*sum(i,xra1(i)*qc(i))=e=qma('CBA');
eq_lngcra1..lngc_ra1=e=1-Jra1+log(Jra1)-5*qma('CBA')*(1-Jra1/Lra1+log(Jra1)-log(Lra1));
eq_bmra1(k)..bmra1(k) =e= sum(m,ema('CBA',m)*ps(m,k,'t1'));
eq_thra1(k)..thra1(k)*sum(i,xra1(i)*qc(i))=e=sum(i,xra1(i)*GS(k,'Q')*n(i,k));
eq_wra1(k)..wra1(k)=e=sum(m,thra1(m)*ps(m,k,'t1'));
eq_lngrra1..lngr_ra1=e=qma('CBA')*(1-sum(k,thra1(k)*bmra1(k)/wra1(k)-ema('CBA',k)*(log(bmra1(k))-log(wra1(k)))));
eq_lngra1..lng_ra1 =e=  lngc_ra1 + lngr_ra1;

eq_ratioa11(i)$(not sameas(i,'CBA') and not sameas(i,'s1'))..x(i,'t1')*xra1('s1') =e= x('s1','t1')*xra1(i);
eq_xra1sum..sum(i,xra1(i))=e=1;

*Hypothetical a2
*eq_Jra2..Jra2*sum(i,xra2(i)*rc(i))=e=rma('DMA');
*eq_Lra2..Lra2*sum(i,xra2(i)*qc(i))=e=qma('DMA');
*eq_lngcra2..lngc_ra2=e=1-Jra2+log(Jra2)-5*qma('DMA')*(1-Jra2/Lra2+log(Jra2)-log(Lra2));
*eq_bmra2(k)..bmra2(k) =e= sum(m,ema('DMA',m)*ps(m,k,'t1'));
*eq_thra2(k)..thra2(k)*sum(i,xra2(i)*qc(i))=e=sum(i,xra2(i)*GS(k,'Q')*n(i,k));
*eq_wra2(k)..wra2(k)=e=sum(m,thra2(m)*ps(m,k,'t1'));
*eq_lngrra2..lngr_ra2=e=qma('DMA')*(1-sum(k,thra2(k)*bmra2(k)/wra2(k)-ema('DMA',k)*(log(bmra2(k))-log(wra2(k)))));
*eq_lngra2..lng_ra2 =e=  lngc_ra2 + lngr_ra2;

*eq_ratioa21(i)$(not sameas(i,'DMA') and not sameas(i,'s1'))..x(i,'t1')*xra2('s1') =e= x('s1','t1')*xra2(i);
*eq_xra2sum..sum(i,xra2(i))=e=1;

*Hypothetical b1
eq_Jrb1..Jrb1*sum(i,xrb1(i)*rc(i))=e=rma('CBA');
eq_Lrb1..Lrb1*sum(i,xrb1(i)*qc(i))=e=qma('CBA');
eq_lngcrb1..lngc_rb1=e=1-Jrb1+log(Jrb1)-5*qma('CBA')*(1-Jrb1/Lrb1+log(Jrb1)-log(Lrb1));
eq_bmrb1(k)..bmrb1(k) =e= sum(m,ema('CBA',m)*ps(m,k,'t1'));
eq_thrb1(k)..thrb1(k)*sum(i,xrb1(i)*qc(i))=e=sum(i,xrb1(i)*GS(k,'Q')*n(i,k));
eq_wrb1(k)..wrb1(k)=e=sum(m,thrb1(m)*ps(m,k,'t1'));
eq_lngrrb1..lngr_rb1=e=qma('CBA')*(1-sum(k,thrb1(k)*bmrb1(k)/wrb1(k)-ema('CBA',k)*(log(bmrb1(k))-log(wrb1(k)))));
eq_lngrb1..lng_rb1 =e=  lngc_rb1 + lngr_rb1;

eq_ratiob11(i)$(not sameas(i,'CBA') and not sameas(i,'s1'))..x(i,'t2')*xrb1('s1') =e= x('s1','t2')*xrb1(i);
eq_xrb1sum..sum(i,xrb1(i))=e=1;

*Hypothetical b2
*eq_Jrb2..Jrb2*sum(i,xrb2(i)*rc(i))=e=rma('DMA');
*eq_Lrb2..Lrb2*sum(i,xrb2(i)*qc(i))=e=qma('DMA');
*eq_lngcrb2..lngc_rb2=e=1-Jrb2+log(Jrb2)-5*qma('DMA')*(1-Jrb2/Lrb2+log(Jrb2)-log(Lrb2));
*eq_bmrb2(k)..bmrb2(k) =e= sum(m,ema('DMA',m)*ps(m,k,'t1'));
*eq_thrb2(k)..thrb2(k)*sum(i,xrb2(i)*qc(i))=e=sum(i,xrb2(i)*GS(k,'Q')*n(i,k));
*eq_wrb2(k)..wrb2(k)=e=sum(m,thrb2(m)*ps(m,k,'t1'));
*eq_lngrrb2..lngr_rb2=e=qma('DMA')*(1-sum(k,thrb2(k)*bmrb2(k)/wrb2(k)-ema('DMA',k)*(log(bmrb2(k))-log(wrb2(k)))));
*eq_lngrb2..lng_rb2 =e=  lngc_rb2 + lngr_rb2;

*eq_ratiob21(i)$(not sameas(i,'DMA') and not sameas(i,'s1'))..x(i,'t2')*xrb2('s1') =e= x('s1','t2')*xrb2(i);
*eq_xrb2sum..sum(i,xrb2(i))=e=1;

*Hypothetical b3
eq_Jrb3..Jrb3*sum(i,xrb3(i)*rc(i))=e=rma('MA');
eq_Lrb3..Lrb3*sum(i,xrb3(i)*qc(i))=e=qma('MA');
eq_lngcrb3..lngc_rb3=e=1-Jrb3+log(Jrb3)-5*qma('MA')*(1-Jrb3/Lrb3+log(Jrb3)-log(Lrb3));
eq_bmrb3(k)..bmrb3(k) =e= sum(m,ema('MA',m)*ps(m,k,'t1'));
eq_thrb3(k)..thrb3(k)*sum(i,xrb3(i)*qc(i))=e=sum(i,xrb3(i)*GS(k,'Q')*n(i,k));
eq_wrb3(k)..wrb3(k)=e=sum(m,thrb3(m)*ps(m,k,'t1'));
eq_lngrrb3..lngr_rb3=e=qma('MA')*(1-sum(k,thrb3(k)*bmrb3(k)/wrb3(k)-ema('MA',k)*(log(bmrb3(k))-log(wrb3(k)))));
eq_lngrb3..lng_rb3 =e=  lngc_rb3 + lngr_rb3;

eq_ratiob31(i)$(not sameas(i,'MA') and not sameas(i,'s1'))..x(i,'t2')*xrb3('s1') =e= x('s1','t2')*xrb3(i);
eq_xrb3sum..sum(i,xrb3(i))=e=1;

*MA in Stream 4
eq_JcMA..JcMA*sum(i,x(i,'t4')*rc(i))=e=rma('MA');
eq_LcMA..LcMA*sum(i,x(i,'t4')*qc(i))=e=qma('MA');
eq_lngccMA..lngc_cMA=e=1-JcMA+log(JcMA)-5*qma('MA')*(1-JcMA/LcMA+log(JcMA)-log(LcMA));
eq_bmcMA(k)..bmcMA(k) =e= sum(m,ema('MA',m)*ps(m,k,'t4'));
eq_thcMA(k)..thcMA(k)*sum(i,x(i,'t4')*qc(i))=e=sum(i,x(i,'t4')*GS(k,'Q')*n(i,k));
eq_wcMA(k)..wcMA(k)=e=sum(m,thcMA(m)*ps(m,k,'t4'));
eq_lngrcMA..lngr_cMA=e=qma('MA')*(1-sum(k,thcMA(k)*bmcMA(k)/wcMA(k)-ema('MA',k)*(log(bmcMA(k))-log(wcMA(k)))));
eq_lngcMA..lng_cMA =e=  lngc_cMA + lngr_cMA;

*Hypothetical c1
eq_Jcc1..Jcc1*sum(i,xcc1(i)*rc(i))=e=rma('CBA');
eq_Lcc1..Lcc1*sum(i,xcc1(i)*qc(i))=e=qma('CBA');
eq_lngccc1..lngc_cc1=e=1-Jcc1+log(Jcc1)-5*qma('CBA')*(1-Jcc1/Lcc1+log(Jcc1)-log(Lcc1));
eq_bmcc1(k)..bmcc1(k) =e= sum(m,ema('CBA',m)*ps(m,k,'t4'));
eq_thcc1(k)..thcc1(k)*sum(i,xcc1(i)*qc(i))=e=sum(i,xcc1(i)*GS(k,'Q')*n(i,k));
eq_wcc1(k)..wcc1(k)=e=sum(m,thcc1(m)*ps(m,k,'t4'));
eq_lngrcc1..lngr_cc1=e=qma('CBA')*(1-sum(k,thcc1(k)*bmcc1(k)/wcc1(k)-ema('CBA',k)*(log(bmcc1(k))-log(wcc1(k)))));
eq_lngcc1..lng_cc1 =e=  lngc_cc1 + lngr_cc1;

eq_ratioc11(i)$(not sameas(i,'CBA') and not sameas(i,'s1'))..x(i,'t4')*xcc1('s1') =e= x('s1','t4')*xcc1(i);
eq_xcc1sum..sum(i,xcc1(i))=e=1;

*Hypothetical c2
*eq_Jcc2..Jcc2*sum(i,xcc2(i)*rc(i))=e=rma('DMA');
*eq_Lcc2..Lcc2*sum(i,xcc2(i)*qc(i))=e=qma('DMA');
*eq_lngccc2..lngc_cc2=e=1-Jcc2+log(Jcc2)-5*qma('DMA')*(1-Jcc2/Lcc2+log(Jcc2)-log(Lcc2));
*eq_bmcc2(k)..bmcc2(k) =e= sum(m,ema('DMA',m)*ps(m,k,'t4'));
*eq_thcc2(k)..thcc2(k)*sum(i,xcc2(i)*qc(i))=e=sum(i,xcc2(i)*GS(k,'Q')*n(i,k));
*eq_wcc2(k)..wcc2(k)=e=sum(m,thcc2(m)*ps(m,k,'t4'));
*eq_lngrcc2..lngr_cc2=e=qma('DMA')*(1-sum(k,thcc2(k)*bmcc2(k)/wcc2(k)-ema('DMA',k)*(log(bmcc2(k))-log(wcc2(k)))));
*eq_lngcc2..lng_cc2 =e=  lngc_cc2 + lngr_cc2;

*eq_ratioc21(i)$(not sameas(i,'DMA') and not sameas(i,'s1'))..x(i,'t4')*xcc2('s1') =e= x('s1','t4')*xcc2(i);
*eq_xcc2sum..sum(i,xcc2(i))=e=1;

*Solubility Equations
eq_soluba1..log(xra1('CBA')) + lng_ra1 =e= Hm('CBA')/Rg *(1/Tm('CBA')-1/Tp('t1'));
*eq_soluba21..xra2('DMA')  =e= exp(Hm('DMA')/Rg *(1/Tm('DMA')-1/Tp('t1')) - lng_ra2);
*eq_soluba22..log(x('DMA','t1')) + lng_ra2 =l= Hm('DMA')/Rg *(1/Tm('DMA')-1/Tp('t1'));
eq_solubb1..log(xrb1('CBA')) + lng_rb1 =e= Hm('CBA')/Rg *(1/Tm('CBA')-1/Tp('t2'));
*eq_solubb21..xrb2('DMA') =e= exp(Hm('DMA')/Rg *(1/Tm('DMA')-1/Tp('t2')) - lng_rb2);
*eq_solubb22..log(x('DMA','t2')) + lng_rb2 =l= Hm('DMA')/Rg *(1/Tm('DMA')-1/Tp('t2'));
eq_solubb3..log(xrb3('MA')) + lng_rb3  =e= Hm('MA')/Rg *(1/Tm('MA')-1/Tp('t2'));

eq_solubc1..log(xcc1('CBA')) + lng_cc1 =e= Hm('CBA')/Rg *(1/Tm('CBA')-1/Tp('t4'));
*eq_solubc21..xcc2('DMA')  =e= exp(Hm('DMA')/Rg *(1/Tm('DMA')-1/Tp('t4')) - lng_cc2);
*eq_solubc22..log(x('DMA','t4')) + lng_cc2 =l= Hm('DMA')/Rg *(1/Tm('DMA')-1/Tp('t4'));

eq_solub1r..x('MA','t2') =l= xrb3('MA');
eq_solub2r..x('CBA','t1') =l= xra1('CBA');
eq_solub3r..x('CBA','t2') =l= xrb1('CBA');

eq_solubMA..log(x('MA','t4')) + lng_cMA =e= Hm('MA')/Rg *(1/Tm('MA')-1/Tp('t4'));
eq_solub1c..x('CBA','t4') =l= xcc1('CBA');

*INTEGER CUT
cut1(ic)$din(ic)..sum(k, abs( n('s1',k)-nk(ic,'s1',k) ) + abs( n('s2',k)-nk(ic,'s2',k) ) )=g= 1;
cut2(ic)$din(ic)..sum(k, abs( n('s1',k)-nk(ic,'s2',k) ) + abs( n('s2',k)-nk(ic,'s1',k) ) )=g= 1;

*****************Miscibility constraints between s1 & s2************************
eq_misc1(strM)..x12('s1',strM)*(x('s1',strM)+x('s2',strM))-x('s1',strM)=l=10*(1-sum(s,y('s2',s)));
eq_misc2(strM)..x12('s1',strM)*(x('s1',strM)+x('s2',strM))-x('s1',strM)=g=-10*(1-sum(s,y('s2',s)));

eq_misc3(strM)..x12('s1',strM) + x12('s2',strM)-1=l=10*(1-sum(s,y('s2',s)));
eq_misc4(strM)..x12('s1',strM) + x12('s2',strM)-1=g=-10*(1-sum(s,y('s2',s)));

eq_misc5(strM)..-sumr12(strM) + x12('s1',strM)*rc('s1')+(1-x12('s1',strM))*rc('s2')=l=10*(1-sum(s,y('s2',s)));
eq_misc6(strM)..-sumr12(strM) + x12('s1',strM)*rc('s1')+(1-x12('s1',strM))*rc('s2')=g=-10*(1-sum(s,y('s2',s)));

eq_misc7(strM)..-sumq12(strM) + x12('s1',strM)*qc('s1')+(1-x12('s1',strM))*qc('s2')=l=10*(1-sum(s,y('s2',s)));
eq_misc8(strM)..-sumq12(strM) + x12('s1',strM)*qc('s1')+(1-x12('s1',strM))*qc('s2')=g=-10*(1-sum(s,y('s2',s)));

*differ of combinatorial actistrMity coefficient, i.e. dlngc/dx(s1)
eq_misc9(strM)..-d_lngc12('s1',strM)*power(sumr12(strM),2)*sumq12(strM)+5*qc('s1')*(qc('s2')-qc('s1'))*power(sumr12(strM),2)
                                        +(rc('s1')-rc('s2'))*(5*qc('s1')-1)*sumr12(strM)*sumq12(strM)
                                        +5*rc('s1')*(qc('s1')-qc('s2'))*sumr12(strM)*sumq12(strM)
                                        +((rc('s1')-rc('s2'))*(rc('s1')-5*rc('s1')*(sumq12(strM))))*sumq12(strM)=l=100*(1-sum(s,y('s2',s)));
eq_misc10(strM)..-d_lngc12('s1',strM)*power(sumr12(strM),2)*sumq12(strM)+5*qc('s1')*(qc('s2')-qc('s1'))*power(sumr12(strM),2)
                                        +(rc('s1')-rc('s2'))*(5*qc('s1')-1)*sumr12(strM)*sumq12(strM)
                                        +5*rc('s1')*(qc('s1')-qc('s2'))*sumr12(strM)*sumq12(strM)
                                        +((rc('s1')-rc('s2'))*(rc('s1')-5*rc('s1')*(sumq12(strM))))*sumq12(strM)=g=-100*(1-sum(s,y('s2',s)));

eq_misc11(k,strM)..th12(k,strM)*sumq12(strM)=e=x12('s1',strM)*GS(k,'Q')*n('s1',k)+(1-x12('s1',strM))*GS(k,'Q')*n('s2',k);
eq_misc12(k,strM)..w12(k,strM)=e=sum(m,th12(m,strM)*ps(m,k,strM));
eq_misc13(k,strM)..d_th12(k,strM)*power(sumq12(strM),2)=e=((GS(k,'Q')*n('s1',k)- GS(k,'Q')*n('s2',k))*sumq12(strM))-(x12('s1',strM)*GS(k,'Q')*n('s1',k)+ x12('s2',strM)*GS(k,'Q')*n('s2',k))*(qc('s1')-qc('s2'));
eq_misc14(k,strM)..d_w12(k,strM)=e=sum(m,ps(m,k,strM)*d_th12(m,strM));
eq_misc15(k,strM)..a12(k,strM)*power(w12(k,strM),2)=e=d_th12(k,strM)*w12(k,strM)-th12(k,strM)*d_w12(k,strM);

eq_misc16(k,strM)..b12('s1',k,strM)-sum(m,GS(m,'Q')*n('s1',m)*ps(m,k,strM))=l=100*(1-sum(s,y('s2',s)));
eq_misc17(k,strM)..b12('s1',k,strM)-sum(m,GS(m,'Q')*n('s1',m)*ps(m,k,strM))=g=-100*(1-sum(s,y('s2',s)));

eq_misc18(k,strM)..c12(k,strM)*w12(k,strM)=e=d_w12(k,strM);

*differ of residual actistrMity coefficient, i.e. dlngr/dx(s1)
*simplier form, not the general form of unifac
eq_misc19(strM)..d_lngr12('s1',strM)+sum(k,a12(k,strM)*b12('s1',k,strM)+GS(k,'Q')*n('s1',k)*c12(k,strM))=l=100*(1-sum(s,y('s2',s)));
eq_misc20(strM)..d_lngr12('s1',strM)+sum(k,a12(k,strM)*b12('s1',k,strM)+GS(k,'Q')*n('s1',k)*c12(k,strM))=g=-100*(1-sum(s,y('s2',s)));

*differ of activity coefficient,i.e. dlng/dx(s1)
eq_misc21(strM)..d_lng12('s1',strM)-d_lngc12('s1',strM)-d_lngr12('s1',strM)=l=100*(1-sum(s,y('s2',s)));
eq_misc22(strM)..d_lng12('s1',strM)-d_lngc12('s1',strM)-d_lngr12('s1',strM)=g=-100*(1-sum(s,y('s2',s)));

eq_misc23(strM)..d_lng12('s1',strM)*x12('s1',strM)+1=g=-100*(1-sum(s,y('s2',s)));

*GSK Safety Constraint
eq_sc(ii,f).. sc(ii,f) =e= sum(s,gsk(s,f)*y(ii,s));

eq_safety(ii,f).. sc(ii,f) =g= GSK_lob - 100*(1-sum(s,y(ii,s)));

*******************************BOUNDS*******************************************
xra1.up(i)=1;
xra1.lo('CBA')=1e-10;
xra1.lo('DMA')=1e-10;
xra1.lo('MA')=0;
xra1.lo('s1')=0.001;
xra1.lo('s2')=0;
Jra1.lo=0.000001;
Jra1.up=30;
Lra1.lo=0.000001;
Lra1.up=30;
bmra1.up(k) = 100;
bmra1.lo(k) = -100;
thra1.up(k)=2;
thra1.lo(k)=0;
wra1.up(k)=20;
wra1.lo(k)=0;
lngc_ra1.lo=-100;
lngc_ra1.up=100;
lngr_ra1.lo=-100;
lngr_ra1.up=100;
lng_ra1.lo = -100;
lng_ra1.up = 100;

xrb1.up(i)=1;
xrb1.lo(jj)=1e-10;
xrb1.lo('s1')=0.001;
xrb1.lo('s2')=0;
Jrb1.lo=0.000001;
Jrb1.up=30;
Lrb1.lo=0.000001;
Lrb1.up=30;
bmrb1.up(k) = 100;
bmrb1.lo(k) = -100;
thrb1.up(k)=2;
thrb1.lo(k)=0;
wrb1.up(k)=20;
wrb1.lo(k)=0;
lngc_rb1.lo=-100;
lngc_rb1.up=100;
lngr_rb1.lo=-100;
lngr_rb1.up=100;
lng_rb1.lo = -100;
lng_rb1.up = 100;

xrb3.up(i)=1;
xrb3.lo(jj)=1e-10;
xrb3.lo('s1')=0.001;
xrb3.lo('s2')=0;
Jrb3.lo=0.000001;
Jrb3.up=30;
Lrb3.lo=0.000001;
Lrb3.up=30;
bmrb3.up(k) = 100;
bmrb3.lo(k) = -100;
thrb3.up(k)=2;
thrb3.lo(k)=0;
wrb3.up(k)=20;
wrb3.lo(k)=0;
lngc_rb3.lo=-100;
lngc_rb3.up=100;
lngr_rb3.lo=-100;
lngr_rb3.up=100;
lng_rb3.lo = -100;
lng_rb3.up = 100;

x.up(i,t)=1;
x.lo(jj,t)=1e-10;
x.lo('s1',t)=0.001;
x.lo('s2',t)=0;

x12.up(ii,strM)=0.9;
x12.lo('s1',strM)=0.1;
x12.lo('s2',strM)=0.1;

n.up(ii,k)=15;

Tp.up('t1')=403;
Tp.lo('t1')=358;
Tp.up('t2')=403;
Tp.lo('t2')=358;
*Tp.up('t3')=403;
*Tp.lo('t3')=358;
Tp.up('t4')=380;
Tp.lo('t4')=290;
Tp.up('t5')=380;
Tp.lo('t5')=290;

mass.lo('MA',t)=1e-10;
mass.lo('CBA',t)=1e-10;
mass.lo('DMA',t)=1e-10;
mass.lo('s1',t)=1e-10;
mass.lo('s2',t)=0;
mass.up(i,t)=500000;

z.lo=3.5;
z.up=11;

PEF.lo=3.5;
PEF.up=20;

rc.lo('s1')= 0.000001;
rc.lo('s2')= 0;
rc.up(i)= 30;
qc.lo('s1')= 0.000001;
qc.lo('s2')= 0;
qc.up(i)= 30;

Yield.lo('MA')=0.9;
Yield.up('MA')=1;

JcMA.lo=0.000001;
JcMA.up=30;
LcMA.lo=0.000001;
LcMA.up=30;
bmcMA.up(k) = 100;
bmcMA.lo(k) = -100;
thcMA.up(k)=2;
thcMA.lo(k)=0;
wcMA.up(k)=20;
wcMA.lo(k)=0;
lngc_cMA.lo=-100;
lngc_cMA.up=100;
lngr_cMA.lo=-100;
lngr_cMA.up=100;
lng_cMA.lo = -100;
lng_cMA.up = 100;

xcc1.up(i)=1;
xcc1.lo(jj)=1e-10;
xcc1.lo('s1')=0.001;
xcc1.lo('s2')=0;
Jcc1.lo=0.000001;
Jcc1.up=30;
Lcc1.lo=0.000001;
Lcc1.up=30;
bmcc1.up(k) = 100;
bmcc1.lo(k) = -100;
thcc1.up(k)=2;
thcc1.lo(k)=0;
wcc1.up(k)=20;
wcc1.lo(k)=0;
lngc_cc1.lo=-100;
lngc_cc1.up=100;
lngr_cc1.lo=-100;
lngr_cc1.up=100;
lng_cc1.lo = -100;
lng_cc1.up = 100;

*bounds for imiscibility calculations
*s1 & s2 bounds
*===============================================================================
th12.up(k,strM)=20;
th12.lo(k,strM)=0;
w12.up(k,strM)=20;
w12.lo(k,strM)=0;

sumr12.lo(strM)=0.000001;
sumr12.up(strM)=50;
sumq12.lo(strM)=0.000001;
sumq12.up(strM)=50;

d_lngc12.lo('s1',strM)=-100;
d_lngc12.up('s1',strM)=100;

d_th12.lo(k,strM)=-100;
d_th12.up(k,strM)=100;

d_w12.lo(k,strM)=-100;
d_w12.up(k,strM)= 100;

a12.lo(k,strM)=-100;
a12.up(k,strM)= 100;

b12.up(ii,k,strM)=100;

c12.lo(k,strM)=-100;
c12.up(k,strM)= 100;

d_lngr12.lo('s1',strM)=-100;
d_lngr12.up('s1',strM)=100;

d_lng12.lo('s1',strM)=-100;
d_lng12.up('s1',strM)=100;

*********************INITIAL POINTS*********************************************
qc.fx(jj)=qma(jj);
rc.fx(jj)=rma(jj);
n.fx(jj,k)=vma(jj,k);

nm.fx('MA','t5')=332;
nm.fx('MA','t1')=0;
mass.fx('MA','t1')=0;
x.fx('MA','t1')=0;
*nmr.fx('MA','t2')=373;
nm.l('CBA','t1')=408;
nm.l('DMA','t1')=816;

x.l('MA','t1')=0;
x.l('MA','t2')=0.2;

x.l('CBA','t1')=0.2;
x.l('CBA','t2')=0.02;

x.l('DMA','t1')=0.2;
x.l('DMA','t2')=0.02;

x.l('s2','t1')=0.1;
x.l('s2','t2')=0.15;

x.l('MA','t4')=0.04;
x.l('CBA','t4')=0.02;
x.l('DMA','t4')=0.02;
x.l('s2','t4')=0.15;

x.l('s1',t)=1-x.l('MA',t)-x.l('CBA',t)-x.l('DMA',t)-x.l('s2',t);

nmt.l('t1')=3000;
nmt.l('t2')=2500;
nmt.l('t3')=0;
nmt.l('t4')=1800;
nmt.l('t5')=332;
nm.l(i,t)=x.l(i,t)*nmt.l(t);

nm.l(i,'t2')=nm.l(i,'t4')+nm.l(i,'t5')-nm.l(i,'t3');

Yield.l(jj)=1-nm.l(jj,'t4')/nm.l(jj,'t2');

y.l('s1','Acetic-acid')=1;
y.l('s2','1-4-dioxane')=1;

Tp.l('t1')=403;
Tp.l('t2')=403;
Tp.l('t4')=290;
Tp.l('t5')=290;
n.l(ii,k)=sum(s,tb(s,k)*y.l(ii,s));
Mw.l(ii)=sum(s,prop(s,'p3')*y.l(ii,s));
mass.l(i,t)=nm.l(i,t)*Mw.l(i);

rc.l(ii)= sum(s,rs(s)*y.l(ii,s));
qc.l(ii)= sum(s,qs(s)*y.l(ii,s));

ps.l(k,m,strM)=exp(-a(k,m)/Tp.l(strM));

Tbs.l(ii)=sum(s,prop(s,'p1')*y.l(ii,s));
Tms.l(ii)=sum(s,prop(s,'p2')*y.l(ii,s));

xra1.l('MA')=0;
xra1.l('CBA')=0.3;
xra1.l('DMA')=0.1;
xra1.l('s1')=0.4;
xra1.l('s2')=1-xra1.l('MA')-xra1.l('CBA')-xra1.l('DMA')-xra1.l('s1');

Jra1.l=rma('CBA')/sum(i,xra1.l(i)*rc.l(i));
Lra1.l=qma('CBA')/sum(i,xra1.l(i)*qc.l(i));
lngc_ra1.l=1-Jra1.l+log(Jra1.l)-5*qma('CBA')*(1-Jra1.l/Lra1.l+log(Jra1.l)-log(Lra1.l));
bmra1.l(k) = sum(m,ema('CBA',m)*ps.l(m,k,'t1'));
thra1.l(k)=sum(i,xra1.l(i)*GS(k,'Q')*n.l(i,k))/sum(i,xra1.l(i)*qc.l(i));
wra1.l(k)=sum(m,thra1.l(m)*ps.l(m,k,'t1'));
lngr_ra1.l=qma('CBA')*(1-sum(k,thra1.l(k)*bmra1.l(k)/wra1.l(k)-ema('CBA',k)*(log(bmra1.l(k))-log(wra1.l(k)))));
lng_ra1.l =  lngc_ra1.l + lngr_ra1.l;
x.l('s2','t1') = x.l('s1','t1')*xra1.l('s2')/xra1.l('s1');
x.l('DMA','t1')= x.l('s1','t1')*xra1.l('DMA')/xra1.l('s1');
x.l('MA','t1')= x.l('s1','t1')*xra1.l('MA')/xra1.l('s1');

xrb1.l('MA')=0.1;
xrb1.l('CBA')=0.3;
xrb1.l('DMA')=0.1;
xrb1.l('s1')=0.3;
xrb1.l('s2')=1-xrb1.l('MA')-xrb1.l('CBA')-xrb1.l('DMA')-xrb1.l('s1');

Jrb1.l=rma('CBA')/sum(i,xrb1.l(i)*rc.l(i));
Lrb1.l=qma('CBA')/sum(i,xrb1.l(i)*qc.l(i));
lngc_rb1.l=1-Jrb1.l+log(Jrb1.l)-5*qma('CBA')*(1-Jrb1.l/Lrb1.l+log(Jrb1.l)-log(Lrb1.l));
bmrb1.l(k) = sum(m,ema('CBA',m)*ps.l(m,k,'t1'));
thrb1.l(k)=sum(i,xrb1.l(i)*GS(k,'Q')*n.l(i,k))/sum(i,xrb1.l(i)*qc.l(i));
wrb1.l(k)=sum(m,thrb1.l(m)*ps.l(m,k,'t1'));
lngr_rb1.l=qma('CBA')*(1-sum(k,thrb1.l(k)*bmrb1.l(k)/wrb1.l(k)-ema('CBA',k)*(log(bmrb1.l(k))-log(wrb1.l(k)))));
lng_rb1.l =  lngc_rb1.l + lngr_rb1.l;
x.l('s2','t2') = x.l('s1','t2')*xrb1.l('s2')/xrb1.l('s1');
x.l('DMA','t2')= x.l('s1','t2')*xrb1.l('DMA')/xrb1.l('s1');
x.l('MA','t2')= x.l('s1','t2')*xrb1.l('MA')/xrb1.l('s1');

xrb3.l('MA')=0.3;
xrb3.l('CBA')=0.1;
xrb3.l('DMA')=0.1;
xrb3.l('s1')=0.3;
xrb3.l('s2')=1-xrb3.l('MA')-xrb3.l('CBA')-xrb3.l('DMA')-xrb3.l('s1');

Jrb3.l=rma('MA')/sum(i,xrb3.l(i)*rc.l(i));
Lrb3.l=qma('MA')/sum(i,xrb3.l(i)*qc.l(i));
lngc_rb3.l=1-Jrb3.l+log(Jrb3.l)-5*qma('MA')*(1-Jrb3.l/Lrb3.l+log(Jrb3.l)-log(Lrb3.l));
bmrb3.l(k) = sum(m,ema('MA',m)*ps.l(m,k,'t1'));
thrb3.l(k)=sum(i,xrb3.l(i)*GS(k,'Q')*n.l(i,k))/sum(i,xrb3.l(i)*qc.l(i));
wrb3.l(k)=sum(m,thrb3.l(m)*ps.l(m,k,'t1'));
lngr_rb3.l=qma('MA')*(1-sum(k,thrb3.l(k)*bmrb3.l(k)/wrb3.l(k)-ema('MA',k)*(log(bmrb3.l(k))-log(wrb3.l(k)))));
lng_rb3.l =  lngc_rb3.l + lngr_rb3.l;
x.l('s2','t2') = x.l('s1','t2')*xrb3.l('s2')/xrb3.l('s1');
x.l('CBA','t2')= x.l('s1','t2')*xrb3.l('CBA')/xrb3.l('s1');
x.l('DMA','t2')= x.l('s1','t2')*xrb3.l('DMA')/xrb3.l('s1');

*initialisation of imiscibility calculations(s1,s2)
x12.l('s1',strM)=x.l('s1',strM)/(x.l('s1',strM)+x.l('s2',strM));
x12.l('s2',strM)=1-x12.l('s1',strM);

sumr12.l(strM)=x12.l('s1',strM)*rc.l('s1')+(1-x12.l('s1',strM))*rc.l('s2');
sumq12.l(strM)=x12.l('s1',strM)*qc.l('s1')+(1-x12.l('s1',strM))*qc.l('s2');

d_lngc12.l('s1',strM)=5*qc.l('s1')*(qc.l('s2')-qc.l('s1'))/sumq12.l(strM)
                  +(rc.l('s1')-rc.l('s2'))*(5*qc.l('s1')-1)/sumr12.l(strM)
                  +5*rc.l('s1')*(qc.l('s1')-qc.l('s2'))/sumr12.l(strM)
                  +((rc.l('s1')-rc.l('s2'))*(rc.l('s1')-5*rc.l('s1')*(sumq12.l(strM))))/power(sumr12.l(strM),2);

th12.l(k,strM)=(x12.l('s1',strM)*GS(k,'Q')*n.l('s1',k)+(1-x12.l('s1',strM))*GS(k,'Q')*n.l('s2',k))/sumq12.l(strM);

w12.l(k,strM)=sum(m,th12.l(m,strM)*ps.l(m,k,strM));

d_th12.l(k,strM)=((GS(k,'Q')*n.l('s1',k)- GS(k,'Q')*n.l('s2',k))*sumq12.l(strM)-(x12.l('s1',strM)*GS(k,'Q')*n.l('s1',k)+ x12.l('s2',strM)*GS(k,'Q')*n.l('s2',k))*(qc.l('s1')-qc.l('s2')))/power(sumq12.l(strM),2);

d_w12.l(k,strM)=sum(m,ps.l(m,k,strM)*d_th12.l(m,strM));

a12.l(k,strM)=(d_th12.l(k,strM)*w12.l(k,strM)-th12.l(k,strM)*d_w12.l(k,strM))/power(w12.l(k,strM),2);
b12.l(ii,k,strM)=sum(m,GS(m,'Q')*n.l(ii,m)*ps.l(m,k,strM));
c12.l(k,strM)=d_w12.l(k,strM)/w12.l(k,strM);

d_lngr12.l('s1',strM)=-sum(k,a12.l(k,strM)*b12.l('s1',k,strM)+GS(k,'Q')*n.l('s1',k)*c12.l(k,strM));

d_lng12.l('s1',strM)=d_lngc12.l('s1',strM)+d_lngr12.l('s1',strM);

*Crystallisation

JcMA.l=rma('MA')/sum(i,x.l(i,'t4')*rc.l(i));
LcMA.l=qma('MA')/sum(i,x.l(i,'t4')*qc.l(i));
lngc_cMA.l=1-JcMA.l+log(JcMA.l)-5*qma('MA')*(1-JcMA.l/LcMA.l+log(JcMA.l)-log(LcMA.l));
bmcMA.l(k) = sum(m,ema('MA',m)*ps.l(m,k,'t4'));
thcMA.l(k)=sum(i,x.l(i,'t4')*GS(k,'Q')*n.l(i,k))/sum(i,x.l(i,'t4')*qc.l(i));
wcMA.l(k)=sum(m,thcMA.l(m)*ps.l(m,k,'t4'));
lngr_cMA.l=qma('MA')*(1-sum(k,thcMA.l(k)*bmcMA.l(k)/wcMA.l(k)-ema('MA',k)*(log(bmcMA.l(k))-log(wcMA.l(k)))));
lng_cMA.l =  lngc_cMA.l + lngr_cMA.l;

xcc1.l('MA')=0.1;
xcc1.l('CBA')=0.3;
xcc1.l('DMA')=0.1;
xcc1.l('s1')=0.3;
xcc1.l('s2')=1-xcc1.l('MA')-xcc1.l('CBA')-xcc1.l('DMA')-xcc1.l('s1');

Jcc1.l=rma('CBA')/sum(i,xcc1.l(i)*rc.l(i));
Lcc1.l=qma('CBA')/sum(i,xcc1.l(i)*qc.l(i));
lngc_cc1.l=1-Jcc1.l+log(Jcc1.l)-5*qma('CBA')*(1-Jcc1.l/Lcc1.l+log(Jcc1.l)-log(Lcc1.l));
bmcc1.l(k) = sum(m,ema('CBA',m)*ps.l(m,k,'t4'));
thcc1.l(k)=sum(i,xcc1.l(i)*GS(k,'Q')*n.l(i,k))/sum(i,xcc1.l(i)*qc.l(i));
wcc1.l(k)=sum(m,thcc1.l(m)*ps.l(m,k,'t4'));
lngr_cc1.l=qma('CBA')*(1-sum(k,thcc1.l(k)*bmcc1.l(k)/wcc1.l(k)-ema('CBA',k)*(log(bmcc1.l(k))-log(wcc1.l(k)))));
lng_cc1.l =  lngc_cc1.l + lngr_cc1.l;
x.l('s2','t4') = x.l('s1','t4')*xcc1.l('s2')/xcc1.l('s1');
x.l('DMA','t4')= x.l('s1','t4')*xcc1.l('DMA')/xcc1.l('s1');
x.l('MA','t4')= x.l('s1','t4')*xcc1.l('MA')/xcc1.l('s1');

nm.fx(i,'t3')$(not sameas(i,'s2'))=0;
nm.fx(i,'t5')$(not sameas(i,'MA'))=0;
mass.fx(i,'t3')$(not sameas(i,'s2'))=0;
mass.fx(i,'t5')$(not sameas(i,'MA'))=0;
x.fx(i,'t3')$(not sameas(i,'s2'))=0;
x.fx(i,'t5')$(not sameas(i,'MA'))=0;

Mass_total.l = mass.l('s1','t4') + mass.l('s2','t4');
Ratio_react1.l = nm.l('s1','t1')/nm.l('s2','t1');
Ratio_react2.l = nm.l('s1','t4')/nm.l('s2','t4');
*PEF.l = (mass.l('MA','t4') + mass.l('DMA','t4') + mass.l('CBA','t4') + mass.l('s1','t4') + mass.l('s2','t4'))/mass.l('MA','t5');

MODEL N2 / ALL/;

  option nlp=conopt;
  option mip=cplex;
  option rminlp=conopt;
  option minlp=sbb;

  option decimals=7;
  option reslim=10000000;
  option iterlim=10000000;
  option domlim=100;
  option optca =1e-10;
  option optcr =1e-5;
  option  limrow=0;
  option limcol=0;
  N2.nodlim=100000;

option sysout=on;

din2(ep)=NO;

loop(epp,

GSK_lob=GSK_lo(epp);
din2(epp)=YES;

DIN(ic)=NO;
nk(ic,ii,k)=0;

loop(ics,

   SOLVE N2 using MINLP minimising PEF;

nk(ics,ii,k)= n.l(ii,k);
yk(ics,ii,s)= y.l(ii,s);
xk(ics,i,t) = x.l(i,t);
DIN(ics)=YES;

zk1(epp,ics)=z.l;
yk1(epp,ics,ii,s)=y.l(ii,s);
xk1(epp,ics,i)= x.l(i,'t1');
xk2(epp,ics,i)= x.l(i,'t2');
xk4(epp,ics,i)= x.l(i,'t4');
nm1(epp,ics,i)=nm.l(i,'t1');
nm2(epp,ics,i)=nm.l(i,'t2');
nm3(epp,ics,i)=nm.l(i,'t3');
nm4(epp,ics,i)=nm.l(i,'t4');
nm5(epp,ics,i)=nm.l(i,'t5');
mass1(epp,ics,i)=mass.l(i,'t1');
mass2(epp,ics,i)=mass.l(i,'t2');
mass3(epp,ics,i)=mass.l(i,'t3');
mass4(epp,ics,i)=mass.l(i,'t4');
mass5(epp,ics,i)=mass.l(i,'t5');
Yield1(epp,ics,jj)=Yield.l(jj);
T1(epp,ics)=Tp.l('t1');
T4(epp,ics)=Tp.l('t4');
xa1(epp,ics,i)=xra1.l(i);
xb1(epp,ics,i)=xrb1.l(i);
xb3(epp,ics,i)=xrb3.l(i);
xc1(epp,ics,i)=xcc1.l(i);
R11(epp,ics,i)=R1.l(i);
R21(epp,ics,i)=R2.l(i);
R31(epp,ics,i)=R3.l(i);
Mass_total1(epp,ics)=Mass_total.l;
Ratio_react11(epp,ics)=Ratio_react1.l;
Ratio_react21(epp,ics)=Ratio_react2.l;
PEF1(epp,ics)=PEF.l;
);
);


execute_unload "MOOPEF-Res.gdx" T1,T4,mass1,mass2,mass3,mass4,mass5,nm1,nm2,nm3,nm4,nm5,xk1,xk2,xk4,yk1,zk1,Yield1,xa1,xb1,xb3,xc1,R11,R21,R31,Mass_total1,Ratio_react11,Ratio_react21,PEF1;
