/**
 * 
 */
package core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Charles Winterhalter
 * Class defining most DNA/protein basic operations
 */
abstract public class DnaProteinOperator {
	
	// Returns codon optimised sequence for target codon to mutate
	// uses data from
	// Harwood & Cutting, Molecular Biological Methods for Bacillus, 1990
	public static String CodonOptimise (boolean isHighExpression, String aminoAcid) {
		String output="";
		if(isHighExpression){
			if(aminoAcid.equals("A"))	output = "GCA";
			if(aminoAcid.equals("C"))	output = "TGC";
			if(aminoAcid.equals("D"))	output = "GAT";
			if(aminoAcid.equals("E"))	output = "GAA";
			if(aminoAcid.equals("F"))	output = "TTC";
			if(aminoAcid.equals("G"))	output = "GGT";
			if(aminoAcid.equals("H"))	output = "CAC";
			if(aminoAcid.equals("I"))	output = "ATC";
			if(aminoAcid.equals("K"))	output = "AAA";
			if(aminoAcid.equals("L"))	output = "CTT";
			if(aminoAcid.equals("M"))	output = "ATG";
			if(aminoAcid.equals("N"))	output = "AAC";
			if(aminoAcid.equals("P"))	output = "CCT";
			if(aminoAcid.equals("Q"))	output = "CAA";
			if(aminoAcid.equals("R"))	output = "CGT";
			if(aminoAcid.equals("S"))	output = "TCT";
			if(aminoAcid.equals("T"))	output = "ACA";
			if(aminoAcid.equals("V"))	output = "GTT";
			if(aminoAcid.equals("Y"))	output = "TAC";
			if(aminoAcid.equals("W"))	output = "TGG";
		} else {
			if(aminoAcid.equals("A"))	output = "GCT";
			if(aminoAcid.equals("C"))	output = "TGC";
			if(aminoAcid.equals("D"))	output = "GAT";
			if(aminoAcid.equals("E"))	output = "GAA";
			if(aminoAcid.equals("F"))	output = "TTT";
			if(aminoAcid.equals("G"))	output = "GGC";
			if(aminoAcid.equals("H"))	output = "CAT";
			if(aminoAcid.equals("I"))	output = "ATT";
			if(aminoAcid.equals("K"))	output = "AAA";
			if(aminoAcid.equals("L"))	output = "CTG";
			if(aminoAcid.equals("M"))	output = "ATG";
			if(aminoAcid.equals("N"))	output = "AAT";
			if(aminoAcid.equals("P"))	output = "CCG";
			if(aminoAcid.equals("Q"))	output = "CAG";
			if(aminoAcid.equals("R"))	output = "AGA";
			if(aminoAcid.equals("S"))	output = "TCA";
			if(aminoAcid.equals("T"))	output = "ACA";
			if(aminoAcid.equals("V"))	output = "GTC";
			if(aminoAcid.equals("Y"))	output = "TAT";
			if(aminoAcid.equals("W"))	output = "TGG";
		}
		return output;
	}
	
	
	// Makes the translation table from DNA triplets to amino-acid
	public static Map<String, String> getCodonTable(){
		Map<String, String> output = new HashMap<String, String>();
		output.put("TTT", "F");
		output.put("TTC", "F");
		output.put("TTA", "L");
		output.put("TTG", "L");
		output.put("TCT", "S");
		output.put("TCC", "S");
		output.put("TCA", "S");
		output.put("TCG", "S");
		output.put("TAT", "Y");
		output.put("TAC", "Y");
		output.put("TAA", "X");
		output.put("TAG", "X");
		output.put("TGT", "C");
		output.put("TGC", "C");
		output.put("TGA", "X");
		output.put("TGG", "W");
		output.put("CTT", "L");
		output.put("CTC", "L");
		output.put("CTA", "L");
		output.put("CTG", "L");
		output.put("CCT", "P");
		output.put("CCC", "P");
		output.put("CCA", "P");
		output.put("CCG", "P");
		output.put("CAT", "H");
		output.put("CAC", "H");
		output.put("CAA", "Q");
		output.put("CAG", "Q");
		output.put("CGT", "R");
		output.put("CGC", "R");
		output.put("CGA", "R");
		output.put("CGG", "R");
		output.put("ATT", "I");
		output.put("ATC", "I");
		output.put("ATA", "I");
		output.put("ATG", "M");
		output.put("ACT", "T");
		output.put("ACC", "T");
		output.put("ACA", "T");
		output.put("ACG", "T");
		output.put("AAT", "N");
		output.put("AAC", "N");
		output.put("AAA", "K");
		output.put("AAG", "K");
		output.put("AGT", "S");
		output.put("AGC", "S");
		output.put("AGA", "R");
		output.put("AGG", "R");
		output.put("GTT", "V");
		output.put("GTC", "V");
		output.put("GTA", "V");
		output.put("GTG", "V");
		output.put("GCT", "A");
		output.put("GCC", "A");
		output.put("GCA", "A");
		output.put("GCG", "A");
		output.put("GAT", "D");
		output.put("GAC", "D");
		output.put("GAA", "E");
		output.put("GAG", "E");
		output.put("GGT", "G");
		output.put("GGC", "G");
		output.put("GGA", "G");
		output.put("GGG", "G");
		return output;
	}
	
	// Compiles a regular expression to screen for start/stop codons
	// and returns the whole protein coding sequence from DNA
	public static String[] findCodingSequence (String sequence, String search) {
		String args[] = new String[2];
		String protein = null;
		int startPos = sequence.indexOf(search);
		Pattern cds = Pattern.compile("(^(atg)([atgc]{3})+(taa|tga|tag))\\w*", Pattern.CASE_INSENSITIVE);
		Matcher match = cds.matcher(sequence.substring(startPos));
		if (match.find()) {
			protein = match.group(1);
		}
		args[0] = protein;
		args[1] = Integer.toString(startPos);
		return args;
	}
	
}
