DROP SCHEMA EBMJAVAUI cascade;
CREATE SCHEMA EBMJAVAUI;

-- modeldata
CREATE TABLE EBMJAVAUI.PREDICTION_MODEL
(
    ID                   BIGSERIAL NOT NULL,
    MODEL_IDENTIFIER     TEXT,
    VALIDATED            BOOL,
    INTERCEPT            DOUBLE PRECISION,
    MAX_ABS_RISK_1D      DOUBLE PRECISION,
    MAX_ABS_RISK_2D      DOUBLE PRECISION,
    MODEL_COMMENT        TEXT,
    PRIMARY KEY (ID)
);
CREATE TABLE EBMJAVAUI.COMPONENT
(
    ID                      BIGSERIAL NOT NULL,
    PREDICTION_MODEL_ID     BIGINT,
    INDEX                   INTEGER,
    FEATURE_NAME            TEXT,
    FEATURE_GROUP           TEXT,
    FEATURE_NAMES           TEXT,
    FEATURE_IMPORTANCE      FLOAT,
    ADDITIVE_TERMS          TEXT,
    TERM_STANDARD_DEVIATION TEXT,
    FEATURE_TYPES           TEXT,
    COL_BIN_COUNT           TEXT,
    COL_BIN_EDGES           TEXT,
    COL_MAPPING             TEXT,
    COL_MAX_                TEXT,
    COL_MIN_                TEXT,
    PRIMARY KEY (ID)
);


-- modeldata constraints
ALTER TABLE EBMJAVAUI.COMPONENT
    ADD CONSTRAINT FK_COMPONENT_PREDICTION_MODEL_ID FOREIGN KEY (PREDICTION_MODEL_ID) REFERENCES EBMJAVAUI.PREDICTION_MODEL (ID);

ALTER ROLE POSTGRES SET SEARCH_PATH TO EBMJAVAUI;
