---
layout: post
title: "4 Covered Criteria"
author: "Raffael Foidl, Lea Salome Brugger"
---

The tables in the following subsections depict which criteria from the evaluation rubric we were able to express via
SPARQL queries.

We want to stress that some queries could be formulated less strict, i.e. `OPTIONAL` blocks could be inserted for triple
patterns that join elements from the maDMP schema that are, by the schema definition, optional. However, as this project
is more of a proof-of-concept-kind, this could be easily be done when extending or building upon the work at hand - in
order not to "lose" any results/information about the corresponding maDMP.

The queries can be found in the corresponding [directory](https://github.com/raffaelfoidl/maDMP-evaluation/tree/main/queries)
in the GitHub repository. In the next subsections, the queries are referred to by their filename without extension, e.g.
a reference to `5-a-1` is points to the query file `5-a-1.sparql`.

### General Information

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>Administrative information</b></td>
    </tr>
    <tr>
        <td>Provide information such as name of applicant, project number, funding programme, version of DMP.Provide information such as name of applicant, project number, funding programme, version of DMP.</td>
        <td><code>0-1</code>, <code>0-2</code>, <code>0-3</code></td>
        <td>Query <code>0-1</code> returns the basic information, i.e. the author, title, created date and language of the maDMP as well as the ID of the corresponding DMP. Query <code>0-2</code> gathers all important information available for the corresponding project, whereas query <code>0-3</code> collects information about the funding of the project.</td>
    </tr>
</tbody>
</table>

### Data Description and Collection or Re-Use of Existing Data

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>1a How will new data be produced and/or how will existing data be re-used?</b></td>
    </tr>
    <tr>
        <td>Explain which methodologies or software will be used if new data are collected or produced.</td>
        <td>/</td>
        <td>Information provided by the <code>methodology</code> field in the <code>dataset</code> structure - however, this field is only specified in the funder extension and is not included in the RDA-DMP Common Standard; therefore, it can not be translated when converting the JSON files to a JSON-LD format and in consequence, not be queried.</td>
    </tr>
    <tr>
        <td>State any constraints on re-use of existing data if there are any.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td>Explain how data provenance will be documented.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td>Briefly state the reasons if the re-use of any existing data sources has been considered but discarded.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>1b What data (for example the kind, formats, and volumes) will be collected or produced?</b></td>
    </tr>
    <tr>
        <td>Give details on the kind of data: for example, numeric (databases, spreadsheets), textual (documents), image, audio, video, and/or mixed media.</td>
        <td><code>1-b-1</code></td>
        <td>Queries all declared datasets and displays their title, type and identifier.</td>
    </tr>
    <tr>
        <td>Give details on the data format: the way in which the data is encoded for storage, often reflected by the filename extension (for example pdf, xls, doc, txt, or rdf).</td>
        <td><code>1-b-2</code></td>
        <td>Returns the data formats of each specified distribution (including the respective access URL and description of the distribution).</td>
    </tr>
    <tr>
        <td>Justify the use of certain formats. For example, decisions may be based on staff expertise within the host organisation, a preference for open formats, standards accepted by data repositories, widespread usage within the research community, or on the software or equipment that will be used.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td>Give preference to open and standard formats as they facilitate sharing and long-term re-use of data (several repositories provide lists of such ‘preferred formats’).</td>
        <td>/</td>
        <td>Not directly covered by maDMP; difficult to cover with a simple SPARQL query.</td>
    </tr>
    <tr>
        <td>Give details on the volumes (they can be expressed in storage space required (bytes), and/or in numbers of objects, files, rows, and columns).</td>
        <td><code>1-b-3</code></td>
        <td>Displays for each defined distribution its size in bytes.</td>
    </tr>
</tbody>
</table>

### Documentation and Data Quality

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>2a What metadata and documentation (for example the methodology of data collection and way of organising data) will accompany the data?</b></td>
    </tr>
    <tr>
        <td>Indicate which metadata will be provided to help others identify and discover the data.</td>
        <td><code>2-a-1</code>, <code>2-a-2</code></td>
        <td><code>2-a-1</code> collects all information provided by the <code>metadata</code> field, i.e. a description (optional), the used standard and the language. <code>2-a-2</code> displays the specified keywords for each defined dataset.</td>
    </tr>
    <tr>
        <td>Indicate which metadata standards (for example DDI, TEI, EML, MARC, CMDI) will be used.</td>
        <td><code>2-a-1</code></td>
        <td>Information about the used metadata standards is covered in this query.</td>
    </tr>
    <tr>
        <td>Use community metadata standards where these are in place.</td>
        <td><code>2-a-3</code></td>
        <td>Example query for testing whether certain community standards (Dublin Core, DDI, EML, TEI or MARC) are used. This can be arbitrarily modified based on which standards are preferred.</td>
    </tr>
    <tr>
        <td>Indicate how the data will be organised during the project mentioning, for example, conventions, version control, and folder structures. Consistent, well-ordered research data will be easier to find, understand, and re-use.</td>
        <td><code>2-a-4</code></td>
        <td>Displays whether the given distribution hosts support versioning. The other information is not really covered by maDMP; if it is included in the maDMP, then probably in the <code>data_quality_assurance</code> field which is covered by query <code>2-b-1</code>.</td>
    </tr>
    <tr>
        <td>Consider what other documentation is needed to enable re-use. This may include information on the methodology used to collect the data, analytical and procedural information, definitions of variables, units of measurement, and so on.</td>
        <td>/</td>
        <td>This information would (if anything) probably be included in the <code>methodology</code> field in the <code>dataset</code> structure - however, this field is only specified in the funder extension and is not included in the RDA-DMP Common Standard; therefore, it can not be translated when converting the JSON files to a JSON-LD format and in consequence, not be queried.</td>
    </tr>
    <tr>
        <td>Consider how this information will be captured and where it will be recorded (for example in a database with links to each item, a 'readme' text file, file headers, code books, or lab notebooks).</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>2b What data quality control measures will be used?</b></td>
    </tr>
    <tr>
        <td>Explain how the consistency and quality of data collection will be controlled and documented. This may include processes such as calibration, repeated samples or measurements, standardised data capture, data entry validation, peer review of data, or representation with controlled vocabularies.</td>
        <td><code>2-b-1</code></td>
        <td>The best one can do is with the <code>data_quality_assurance</code> element.</td>
    </tr>
</tbody>
</table>

### Storage and Backup During the Research Process

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>3a How will data and metadata be stored and backed up during the research?</b></td>
    </tr>
    <tr>
        <td>Describe where the data will be stored and backed up during research activities and how often the backup will be performed. It is recommended to store data in least at two separate locations.</td>
        <td><code>3-a-1</code></td>
        <td>Retrieving information about backups is only possible by querying the <code>host</code> element. If provided, the query returns the backup type and frequency for each specified host, as well as some information about the host.</td>
    </tr>
    <tr>
        <td>Give preference to the use of robust, managed storage with automatic backup, such as provided by IT support services of the home institution. Storing data on laptops, stand-alone hard drives, or external storage devices such as USB sticks is not recommended.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>3b How will data security and protection of sensitive data be taken care of during the research?</b></td>
    </tr>
    <tr>
        <td>Explain how the data will be recovered in the event of an incident.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td>Explain who will have access to the data during the research and how access to data is controlled, especially in collaborative partnerships.</td>
        <td><code>3-b-1</code></td>
        <td>The best one can do is with the <code>security_and_privacy</code> field. Information about the availability of data hosts is included in query <code>3-a-1</code>.</td>
    </tr>
    <tr>
        <td>Consider data protection, particularly if your data is sensitive (for example containing personal data, politically sensitive information, or trade secrets). Describe the main risks and how these will be managed.</td>
        <td><code>3-b-2</code></td>
        <td>Description of risks and countermeasures are not really covered by maDMP. Information about whether data are sensitive is covered.</td>
    </tr>
    <tr>
        <td>Explain which institutional data protection policies are in place.</td>
        <td>/</td>
        <td>Information provided by the <code>related_policy</code> field in the <code>dmp</code> structure - however, this field is only specified in the funder extension and is not included in the RDA-DMP Common Standard; therefore, it can not be translated when converting the JSON files to a JSON-LD format and in consequence, not be queried.</td>
    </tr>
</tbody>
</table>

### Legal and Ethical Requirements, Code of Conduct

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>4a If personal data are processed, how will compliance with legislation on personal data and security be ensured?</b></td>
    </tr>
    <tr>
        <td>Ensure that when dealing with personal data, data protection laws (for example GDPR) are complied with.  <i>(including sub-points)</i></td>
        <td><code>5-a-2</code></td>
        <td>If anything, information about consent for preservation or sharing and anonymization would be included in the <code>preservation_statement</code> which is already covered by query <code>5-a-2</code>. The other aspects are not really covered by maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>4b How will other legal issues, such as intellectual property rights and ownership, be managed? What legislation is applicable?</b></td>
    </tr>
    <tr>
        <td>Explain who will be the owner of the data, meaning who will have the rights to control access. <i>(including sub-points)</i></td>
        <td><code>3-b-1</code>, <code>5-a-3</code></td>
        <td>If anything, access restrictions would be included in the <code>security_and_privacy</code> field which is already covered by query <code>3-b-1</code>. Descriptions of the licenses in place are queried with query <code>5-a-3</code>.</td>
    </tr>
    <tr>
        <td>Indicate whether intellectual property rights (for example Database Directive, sui generis rights) are affected. If so, explain which and how will they be dealt with.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td>Indicate whether there are any restrictions on the re-use of third-party data.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>4c What ethical issues and codes of conduct are there, and how will they be taken into account?</b></td>
    </tr>
    <tr>
        <td>Consider whether ethical issues can affect how data are stored and transferred, who can see or use them, and how long they are kept. Demonstrate awareness of these aspects and respective planning.</td>
        <td><code>4-c-1</code>, <code>4-c-2</code></td>
        <td>Query <code>4-c-1</code> checks whether ethical issues exist. Query <code>4-c-2</code> returns a description of the specified ethical issues, if there are any, as well as the ethical issues report, if there is one.</td>
    </tr>
    <tr>
        <td>Follow the national and international codes of conducts and institutional ethical guidelines, and check if ethical review (for example by an ethics committee) is required for data collection in the research project.</td>
        <td>/</td>
        <td>Not really covered by maDMP.</td>
    </tr>
</tbody>
</table>

### Data Sharing and Long-Term Preservation

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>5a How and when will data be shared? Are there possible restrictions to data sharing or embargo reasons?</b></td>
    </tr>
    <tr>
        <td>Explain how the data will be discoverable and shared (for example by deposit in a trustworthy data repository, indexed in a catalogue, use of a secure data service, direct handling of data requests, or use of another mechanism).</td>
        <td><code>5-a-1</code></td>
        <td>Displays information about distribution such as Host, access URL and distributed file formats.</td>
    </tr>
    <tr>
        <td>Outline the plan for data preservation and give information on how long the data will be retained.</td>
        <td><code>5-a-2</code></td>
        <td>The best one can do is with the preservation statement. However, note that this query does not return anything for our input files in JSON-LD format, probably because the <code>preservation_statement</code> field in the JSON files is ignored by the DCSO-JSON tool (see "Known issues" in <a href="https://raffaelfoidl.github.io/maDMP-evaluation/0007.html">the README of the tool</a>) and hence, not converted. In consequence, this field can obviously not be queried.</td>
    </tr>
    <tr>
        <td>Explain when the data will be made available. Indicate the expected timely release. Explain whether exclusive use of the data will be claimed and if so, why and for how long. Indicate whether data sharing will be postponed or restricted for example to publish, protect intellectual property, or seek patents.</td>
        <td><code>5-a-3</code></td>
        <td>Gathers information about the data usage constraints (license, embargo period, data access, release data).</td>
    </tr>
    <tr>
        <td>Indicate who will be able to use the data. If it is necessary to restrict access to certain communities or to apply a data sharing agreement, explain how and why. Explain what action will be taken to overcome or to minimise restrictions.</td>
        <td>/</td>
        <td>Not really covered by maDMP. Possible information contained in maDMP is already queried by <code>5-a-3</code>.</td>
    </tr>
    <tr>
        <td colspan="4"><b>5b How will data for preservation be selected, and where data will be preserved long-term (for example a data repository or archive)?</b></td>
    </tr>
    <tr>
        <td>Indicate what data must be retained or destroyed for contractual, legal, or regulatory purposes.</td>
        <td>/</td>
        <td>Not explicitly covered by maDMP; maybe with <code>5-a-2</code></td>
    </tr>
    <tr>
        <td>Indicate how it will be decided what data to keep. Describe the data to be preserved long-term.</td>
        <td>/</td>
        <td>Not explicitly covered by maDMP; maybe with <code>5-a-2</code></td>
    </tr>
    <tr>
        <td>Explain the foreseeable research uses (and/or users) for the data.</td>
        <td>/</td>
        <td>Not covered by maDMP.</td>
    </tr>
    <tr>
        <td>Indicate where the data will be deposited. If no established repository is proposed, demonstrate in the DMP that the data can be curated effectively beyond the lifetime of the grant. It is recommended to demonstrate that the repositories policies and procedures (including any metadata standards, and costs involved) have been checked.</td>
        <td><code>5-b-1</code></td>
        <td>Enumerates all information available about the hosts mentioned in the maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>5c What methods or software tools are needed to access and use data?</b></td>
    </tr>
    <tr>
        <td>Indicate whether potential users need specific tools to access and (re-)use the data. Consider the sustainability of software needed for accessing the data.</td>
        <td><code>5-c-1</code></td>
        <td>A stripped down version of <code>5-a-1</code>, with focus on the distributed file formats. This is the best we can get with the maDMP since file formats indicate software/tools to be used to read the files.</td>
    </tr>
    <tr>
        <td>Indicate whether data will be shared via a repository, requests handled directly, or whether another mechanism will be used?</td>
        <td><code>5-a-1</code></td>
        <td>There is no dedicated field in the maDMP for this. However, <code>5-a-1</code> obtains data the requested information can inferred from.</td>
    </tr>
    <tr>
        <td colspan="4"><b>5d How will the application of a unique and persistent identifier (such as a Digital Object Identifier (DOI)) to each data set be ensured?</b></td>
    </tr>
    <tr>
        <td>Explain how the data might be re-used in other contexts. Persistent identifiers (PIDs) should be applied so that data can be reliably and efficiently located and referred to. PIDs also help to track citations and re-use.</td>
        <td><code>5-d-1</code></td>
        <td>This is a slightly modified version of <code>5-a-1</code>, with an emphasis on the employed PID system.</td>
    </tr>
    <tr>
        <td>Indicate whether a PID for the data will be pursued. Typically, a trustworthy, long-term repository will provide a persistent identifier.</td>
        <td><code>5-d-2</code></td>
        <td>Tests whether there exists a distribution with a host that specifies the use of a PID system.</td>
    </tr>
</tbody>
</table>

### Data Management Responsibilities and Resources

<table class="rtable">
<thead>
    <tr>
        <th>Requirement</th>
        <th>Covered In</th>
        <th>Remarks</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="4"><b>6a Who (for example role, position, and institution) will be responsible for data management (i.e. the data steward)?</b></td>
    </tr>
    <tr>
        <td>Outline the roles and responsibilities for data management/ stewardship activities for example data capture, metadata production, data quality, storage and backup, data archiving, and data sharing. Name responsible individual(s) where possible.</td>
        <td><code>6-a-1</code>, <code>6-a-2</code></td>
        <td>The queries show all available information about the contact person and contributors.</td>
    </tr>
    <tr>
        <td>For collaborative projects, explain the co-ordination of data management responsibilities across partners</td>
        <td><code>6-a-2</code></td>
        <td>Depicts information about contributors defined by the maDMP.</td>
    </tr>
    <tr>
        <td>Indicate who is responsible for implementing the DMP, and for ensuring it is reviewed and, if necessary, revised.</td>
        <td>/</td>
        <td>Not explicitly covered by maDMP, but <code>6-a-1</code> and <code>6-a-2</code> give a good indicator of who might be responsible.</td>
    </tr>
    <tr>
        <td>Consider regular updates of the DMP.</td>
        <td>/</td>
        <td>Not covered by maDMP.</td>
    </tr>
    <tr>
        <td colspan="4"><b>6b What resources (for example financial and time) will be dedicated to data management and ensuring that data will be FAIR (Findable, Accessible, Interoperable, Re-usable)?</b></td>
    </tr>
    <tr>
        <td>Explain how the necessary resources (for example time) to prepare the data for sharing/preservation (data curation) have been costed in.</td>
        <td><code>6-b-1</code></td>
        <td>Not explicitly covered by maDMP; related information may be found by <code>6-b-1</code>.</td>
    </tr>
    <tr>
        <td>Carefully consider and justify any resources needed to deliver the data. These may include storage costs, hardware, staff time, costs of preparing data for deposit, and repository charges.</td>
        <td><code>6-b-1</code></td>
        <td>Lists everything related to costs that is captured by the maDMP.</td>
    </tr>
    <tr>
        <td>Indicate whether additional resources will be needed to prepare data for deposit or to meet any charges from data repositories. If yes, explain how much is needed and how such costs will be covered.</td>
        <td><code>6-b-2</code></td>
        <td>Specifies equipment needed or used to create or process the data.</td>
    </tr>
</tbody>
</table>

### Summary

Overall, the Science Europe Evaluation Rubric defines 6 broad categories in its assessment guideline. The following
table gives of the spectrum we were able to cover with our queries.

<table class="rtable">
<thead>
  <tr>
    <th>Category</th>
    <th>Number Of Subitems</th>
    <th>Largely Covered Subitems</th>
    <th>Percentage</th>
  </tr>
</thead>
<tbody>
  <tr>
    <td>0 General Information</td>
    <td>1</td>
    <td>1</td>
    <td>100 %</td>
  </tr>
  <tr>
    <td>1 Data Description and Collection or Re-Use of Existing Data</td>
    <td>9</td>
    <td>3</td>
    <td>33 %</td>
  </tr>
  <tr>
    <td>2 Documentation and Data Quality</td>
    <td>7</td>
    <td>5</td>
    <td>71 %</td>
  </tr>
  <tr>
    <td>3 Storage and Backup During the Research Process</td>
    <td>6</td>
    <td>3</td>
    <td>50 %</td>
  </tr>
  <tr>
    <td>4 Legal and Ethical Requirements, Code of Conduct</td>
    <td>6</td>
    <td>3</td>
    <td>50 %</td>
  </tr>
  <tr>
    <td>5 Data Sharing and Long-Term Preservation</td>
    <td>12</td>
    <td>8</td>
    <td>67 %</td>
  </tr>
  <tr>
    <td>6 Data Management Responsibilities and Resources</td>
    <td>7</td>
    <td>5</td>
    <td>71 %</td>
  </tr>
</tbody>
<tfoot>
  <tr>
    <td>Sum</td>
    <td>48</td>
    <td>28</td>
    <td>58 %</td>
  </tr>
</tfoot>
</table>

