---
layout: post
title: "2 Repository Structure"
author: "Raffael Foidl, Lea Salome Brugger"
---

```shell
.
├── app-bin
├── dcso-json
│   ├── src
│   ├── target
│   ├── README.md
│   ├── dcso-json.iml
│   └── pom.xml
├── docs
├── maDMPs
│   ├── 1-community
│   ├── 2-preprocessed
│   ├── 3-normalized
│   ├── 4-json-ld-converted
│   ├── 5-json-ld-postprocessed
│   └── convert.sh
├── queries
└── generate_docs.sh
```

* `app-bin`: distribution directory of the `dcso-json` tool (built and distributed upon `mvn install`, refer to its
  [documentation](https://raffaelfoidl.github.io/maDMP-evaluation/0007.html) for more information)
* `dcso-json`: the source code of the `dcso-json` tool, bundled as a `maven` project
* `docs`: the content of the [documentation webpage](https://raffaelfoidl.github.io/maDMP-evaluation/); served via
  GitHub pages and the static site generator [Jekyll](https://jekyllrb.com/).
* `maDMPs`: different versions of the machine-actionable DMPs assessed during this project, from raw input data to
  normalized JSON-LD [DCSO](https://github.com/RDA-DMP-Common/RDA-DMP-Common-Standard/tree/master/ontologies)
  serializations (see also [Methodology](https://raffaelfoidl.github.io/maDMP-evaluation/0003.html)).
* `queries`: SPARQL queries conceived during this project to assess the quality of maDMPs
* `generate_docs.sh`: regenerates the content of the `docs` folder based on the README files in this repository

The regeneration of the documentation webpage is triggered and automatically executed on the `docs` branch using a
GitHub Action at every push to the `main` branch. In other words, the `docs` branch is the source of truth
for [https://raffaelfoidl.github.io/maDMP-evaluation/](https://raffaelfoidl.github.io/maDMP-evaluation/)
and is updated at every push to `main` using a
dedicated [GitHub Action](https://docs.github.com/en/actions/learn-github-actions/introduction-to-github-actions).

The `docs` folder on the `main` branch is only updated sporadically, e.g. at releases (commits with a release tag).

