import os
import shutil
from PIL import Image
import imageio
imgnamelist = ["0_1","0_2","0_3","0_4","5_1","5_2","5_3","5_4","15_1","15_2","15_3","15_4","45_1","45_2","45_3","45_4","45_5","45_6","60_1","60_2","60_3","60_4"]

path1 = "../SubImages/" #path of folder of subimages
pathlr = "DIV2K/pooled/LR/X2/"
pathhr = 'DIV2K/pooled/HR/'
pathbi = 'DIV2K/pooled/BI/X1/'

if not os.path.exists(pathlr):
    os.makedirs(pathlr)
if not os.path.exists(pathhr):
    os.makedirs(pathhr)
if not os.path.exists(pathbi):
    os.makedirs(pathbi)


def gen_name(n):
    s = str(n)
    if len(s) == 1:
        name = '000' + s
    elif len(s) == 2:
        name = '00' + s
    elif len(s) == 3:
        name = '0' + s
    else:
        name = s
    return name

# get LR and HR images from subimages folder
n = 1
for img in imgnamelist:
    for i in range(1,10):
        old = "{}_InSample_{}.bmp".format(img,i)
        oldhr = "{}_InSample_{}_GT.bmp".format(img,i)
        new = gen_name(n) + 'x2.bmp'
        newhr = gen_name(n) + '.bmp'
        n += 1
#         print(old,new)
        shutil.copyfile(path1+old, pathlr+new)
        shutil.copyfile(path1+oldhr, pathhr+newhr)
for img in imgnamelist:
    for i in range(1,4):
        old = "{}_OutSample_{}.bmp".format(img,i)
        oldhr = "{}_OutSample_{}_GT.bmp".format(img,i)
        new = gen_name(n) + 'x2.bmp'
        newhr = gen_name(n) + '.bmp'
        n += 1
#         print(old,new)
        shutil.copyfile(path1+old, pathlr+new)
        shutil.copyfile(path1+oldhr, pathhr+newhr)
# get BI images from LR folder just built
listing = os.listdir(pathlr)
for file in listing:
    im_b = Image.open(pathlr + file)
    im_b = im_b.resize((320,314), Image.BICUBIC)
    file = file.replace('x2','x1')
#     print(file)
    imageio.imwrite(pathbi+file,im_b)

for img in imgnamelist:
    pathlr = 'DIV2K/'+ img + '/LR/X2/'
    pathhr = 'DIV2K/'+ img + '/HR/'
    pathbi = 'DIV2K/'+ img + '/BI/X1/'
    if not os.path.exists(pathlr):
        os.makedirs(pathlr)
    if not os.path.exists(pathhr):
        os.makedirs(pathhr)
    if not os.path.exists(pathbi):
        os.makedirs(pathbi)

    n = 1

    for i in range(1,10):
        old = "{}_InSample_{}.bmp".format(img,i)
        oldhr = "{}_InSample_{}_GT.bmp".format(img,i)
        new = gen_name(n) + 'x2.bmp'
        newhr = gen_name(n) + '.bmp'
        n += 1
    #         print(old,new)
        shutil.copyfile(path1+old, pathlr+new)
        shutil.copyfile(path1+oldhr, pathhr+newhr)

    for i in range(1,4):
        old = "{}_OutSample_{}.bmp".format(img,i)
        oldhr = "{}_OutSample_{}_GT.bmp".format(img,i)
        new = gen_name(n) + 'x2.bmp'
        newhr = gen_name(n) + '.bmp'
        n += 1
    #         print(old,new)
        shutil.copyfile(path1+old, pathlr+new)
        shutil.copyfile(path1+oldhr, pathhr+newhr)

    listing = os.listdir(pathlr)
    for file in listing:
        im_b = Image.open(pathlr + file)
        im_b = im_b.resize((320,314), Image.BICUBIC)
        file = file.replace('x2','x1')
    #     print(file)
        imageio.imwrite(pathbi+file,im_b)
