clear; clc; close all
th_canny = .2;


image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

acc_bi = zeros(12, length(image_list));
acc_sr = zeros(12, length(image_list));

fprintf("Calculate Canny detection improvement:\n");

% Bicubic interpolation
fprintf("Bicubic Interpolation:\n");
fprintf("Testing image: ");
for ii = 1:length(image_list)
        
        image_name = image_list{ii};
        if ii < length(image_list)
            fprintf(" %s,", image_name);
        else
            fprintf(" %s.\n", image_name);
        end
        
        for index = 1:12
            if index <= 9
                basename = sprintf('%s_InSample_%d', image_name, index);
            else
                basename = sprintf('%s_OutSample_%d', image_name, index-9);
            end
            
            filename = ['./SubImages/' basename '_GT.bmp'];
            image_high = imread(filename, 'bmp');
            if ~ismatrix(image_high)
                image_high = rgb2gray(image_high);
            end
            image_high = double(image_high);

            
            filename = ['./SubImages/' basename '.bmp'];
            % image_sr = imresize(uint8(image_high), .5, 'bicubic');
            image_low = imread(filename, 'bmp');
            image_bi = imresize(image_low, 2., 'bicubic');
            image_bi = double(image_bi);
            if ~ismatrix(image_bi)
                image_bi = rgb2gray(image_bi);
            end
            image_bi = double(image_bi);
            
            BW_high = edge(uint8(image_high), 'Canny', th_canny);
            % figure
            % imshow(uint8(BW_high .* 255))
            filename = ['./Result/Edge/' basename '_Edge_HR.bmp'];
            imwrite(uint8(BW_high .* 255), filename, 'bmp');
            
            BW_bi = edge(uint8(image_bi), 'Canny', th_canny);
            % figure
            % imshow(uint8(BW_bi .* 255))
            filename = ['./Result/Edge/' basename '_Edge_BI.bmp'];
            imwrite(uint8(BW_bi .* 255), filename, 'bmp');
        
            % Calculating consistancy
            acc_bi(index, ii) = 1 - sum(abs(double(BW_high(:)) - double(BW_bi(:))))/double(sum(BW_high(:)) + sum(BW_bi(:)));
           
            
        end
end
    fprintf('In-Sample: The accuracy of the BI detection is %.2f%%.\n', 100.0 * mean(mean(acc_bi(1:9, :))));
    fprintf('Out-of-Sample: The accuracy of the BI detection is %.2f%%.\n\n', 100.0 * mean(mean(acc_bi(10:12, :))));

for jj = 3%1:4
    switch jj
        case 1
            results_folder = './Result/VDSR/Self Training/';
            fprintf("VDSR with self-training:\n");
        case 2
            results_folder = './Result/VDSR/Pooled Training/';
            fprintf("VDSR with pooled-training:\n");
        case 4
            results_folder = './Result/LBNLM/';
            fprintf("Paired LB-NLM with self-training:\n");
        case 3
            results_folder = './Result/SRSW/Pooled/';
            fprintf("SRSW with self-training:\n");
    end
    fprintf("Testing image: ");
    SR_results = zeros(12, 4);
    
    for ii = 1:length(image_list)
        
        image_name = image_list{ii};
        if ii < length(image_list)
            fprintf(" %s,", image_name);
        else
            fprintf(" %s.\n", image_name);
        end
        
        for index = 1:12
            if index <= 9
                basename = sprintf('%s_InSample_%d', image_name, index);
            else
                basename = sprintf('%s_OutSample_%d', image_name, index-9);
            end
            
            filename = ['./SubImages/' basename '_GT.bmp'];
            image_high = imread(filename, 'bmp');
            if ~ismatrix(image_high)
                image_high = rgb2gray(image_high);
            end
            image_high = double(image_high);
            
            switch jj
                case 1
                    filename = [results_folder basename '_VDSR.bmp'];
                case 2
                    filename = [results_folder basename '_VDSR.bmp'];
                case 4
                    filename = [results_folder basename '_LBNLM_self.bmp'];
                case 3
                    filename = [results_folder basename '_SRSW.bmp'];
            end
            image_sr = imread(filename, 'bmp');
            if ~ismatrix(image_sr)
                image_sr = rgb2gray(image_sr);
            end
            image_sr = double(image_sr);
            
           
            % figure
            % imshow(uint8(BW_high .* 255))
            filename = ['./Result/Edge/' basename '_Edge_HR.bmp'];
            BW_high = imread(filename, 'bmp');
            BW_high = BW_high > 127;
            
            BW_sr = edge(uint8(image_sr), 'Canny', th_canny);
            % figure
            % imshow(uint8(BW_sr .* 255))
            if jj == 4
                filename = ['./Result/Edge/' basename '_Edge_SR.bmp'];
                imwrite(uint8(BW_sr .* 255), filename, 'bmp');
            end
            
            % Calculating consistancy
            acc_sr(index, ii) = 1 - sum(abs(double(BW_high(:)) - double(BW_sr(:))))/double(sum(BW_high(:)) + sum(BW_sr(:)));        
        end
    end
    
    fprintf('In-Sample: The accuracy of the SR detection is %.2f%%.\n', 100.0 * mean(mean(acc_sr(1:9, :))));  
    fprintf('Out-of-Sample: The accuracy of the SR detection is %.2f%%.\n\n', 100.0 * mean(mean(acc_sr(10:12, :))));
end
