clear; clc; close all

ratio = 2.0;

image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

improve_psnr_fg_all = zeros(12, length(image_list));
improve_psnr_bg_all = zeros(12, length(image_list));
fprintf("Calculate foreground/background improvement:\n");

for jj = 1:4
    switch jj
        case 1
            results_folder = './Result/VDSR/Self Training/';
            fprintf("VDSR with self-training:\n");
        case 2
            results_folder = './Result/VDSR/Pooled Training/';
            fprintf("VDSR with pooled-training:\n");
        case 4
            results_folder = './Result/LBNLM/';
            fprintf("Paired LB-NLM with self-training:\n");
        case 3
            results_folder = './Result/SRSW/Self/';
            fprintf("SRSW with self-training:\n");
    end
    fprintf("Testing image: ");
    SR_results = zeros(12, 4);
    
    for ii = 1:length(image_list)
        image_name = image_list{ii};
        if ii < length(image_list)
            fprintf(" %s,", image_name);
        else
            fprintf(" %s.\n", image_name);
        end
        
        for i = 1:12    
            if i <= 9
                basename = sprintf('%s_InSample_%d', image_name, i);
            else
                basename = sprintf('%s_OutSample_%d', image_name, i - 9);
            end
            % fprintf('Testing image name: %s.\n', basename);
            
            filename = ['./SubImages/' basename '.bmp'];
            image_low = imread(filename, 'bmp');
            if ~ismatrix(image_low)
                image_low = rgb2gray(image_low);
            end
            image_low = double(image_low);
            % [n_height, n_width] = size(image_low);
            
            image_bi = imresize(uint8(image_low), ratio, 'bicubic');
            image_bi = double(image_bi);
            % filename = [results_folder basename '_BI.bmp'];
            % imwrite(uint8(image_up),filename, 'bmp');
            
            % Load ground truth
            filename = ['./SubImages/' basename '_GT.bmp'];
            image_high = imread(filename, 'bmp');
            if ~ismatrix(image_high)
                image_high = rgb2gray(image_high);
            end
            image_high = double(image_high);
            % filename = [results_folder basename '_GT.bmp'];
            % imwrite(uint8(image_high),filename, 'bmp');
            
            % Load Results
            switch jj
                case 1
                    filename = [results_folder basename '_VDSR.bmp'];
                case 2
                    filename = [results_folder basename '_VDSR.bmp'];
                case 4
                    filename = [results_folder basename '_LBNLM_self.bmp'];
                case 3
                    filename = [results_folder basename '_SRSW.bmp'];
            end
            % filename = [results_folder basename '_EDSR.bmp'];
            % filename = [results_folder basename '_RCAN.bmp'];
            image_sr = imread(filename, 'bmp');
            if ~ismatrix(image_sr)
                image_sr = rgb2gray(image_sr);
            end
            image_sr = double(image_sr);
            
            % Load binary image
            filename = ['./SubImages/' basename '_binary.bmp'];
            BW_high = imread(filename, 'bmp');
            BW_high = BW_high > 127;
            
            % Foreground psnr increase
            SE_image = (image_bi - image_high).^2;
            rmse = sqrt(mean(SE_image(BW_high)));
            % fprintf('MSE before LB-NLM filter: %.3f.\n', rmse^2)
            psnr_input = 20.0 * log10(255.0 / rmse);
            
            SE_image = (image_sr - image_high).^2;
            rmse = sqrt(mean(SE_image(BW_high)));
            % fprintf('MSE after LB-NLM filter: %.3f.\n', rmse^2);
            psnr_filtered = 20.0 * log10(255.0 / rmse);
            % fprintf('PSNR before and after LB-NLM filter of the foreground: %.3f dB and %.3f dB.\n', psnr_input, psnr_filtered);
            improve_psnr_fg_all(i, ii) = psnr_filtered - psnr_input;
            
            % Foreground psnr increase
            SE_image = (image_bi - image_high).^2;
            rmse = sqrt(mean(SE_image(~BW_high)));
            % fprintf('MSE before LB-NLM filter: %.3f.\n', rmse^2)
            psnr_input = 20.0 * log10(255.0 / rmse);
            
            SE_image = (image_sr - image_high).^2;
            rmse = sqrt(mean(SE_image(~BW_high)));
            % fprintf('MSE after LB-NLM filter: %.3f.\n', rmse^2);
            psnr_filtered = 20.0 * log10(255.0 / rmse);
            % fprintf('PSNR before and after LB-NLM filter of the foreground: %.3f dB and %.3f dB.\n', psnr_input, psnr_filtered);
            improve_psnr_bg_all(i, ii) = psnr_filtered - psnr_input;
        end
        
    end
    
    fprintf('Increase of PSNR in in-sample foreground: %.3f.\n', mean(mean(improve_psnr_fg_all(1:9, :))));
    fprintf('Increase of PSNR in in-sample background: %.3f.\n', mean(mean(improve_psnr_bg_all(1:9, :))));
    fprintf('Increase of PSNR in out-of-sample foreground: %.3f.\n', mean(mean(improve_psnr_fg_all(10:12, :))));
    fprintf('Increase of PSNR in out-of-sample background: %.3f.\n\n', mean(mean(improve_psnr_bg_all(10:12, :))));
end