clear; clc; close all;

image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

for kk = 1:length(image_list)
    common_name = image_list{kk};
    
    fprintf("Segment Image Pair: %s.\n", common_name);
    
    image_name = sprintf('%s_LR2', common_name);
    image_low_all = imread([ './SubImages/', image_name, '.bmp']);
    if ~ismatrix(image_low_all)
        image_low_all = rgb2gray(image_low_all);
    end
    image_name = sprintf('%s_HR', common_name);
    image_high_all = imread([ './SubImages/', image_name, '.bmp']);
    if ~ismatrix(image_high_all)
        image_high_all = rgb2gray(image_high_all);
    end
    
    % SR factors and test image sizes
    ratio = 2.;
    
    [n_height_low, n_width_low] = size(image_low_all);
    n_height_high = round(n_height_low * ratio);
    n_width_high = round(n_width_low * ratio);
    
    n_width_test = round(n_width_low / 4.0);
    n_height_test = round(n_height_low / 3.0);
    n_width_GT = round(n_width_test * ratio);
    n_height_GT = round(n_height_test * ratio);
    
    % Cut and save testing images
    ii_insample = 0;
    ii_outsample = 0;
    
    for ii = 0:3
        for jj = 0:2
            
            if ii < 3
                image_test_name = sprintf(['./SubImages/' common_name '_InSample_%d.bmp'], ii*3+jj+1);
                image_GT_name = sprintf(['./SubImages/' common_name '_InSample_%d_GT.bmp'], ii*3+jj+1);
            else
                image_test_name = sprintf(['./SubImages/' common_name '_OutSample_%d.bmp'], jj+1);
                image_GT_name = sprintf(['./SubImages/' common_name '_OutSample_%d_GT.bmp'], jj+1);
            end
            
            image_test = image_low_all((jj * n_height_test + 1):(jj + 1) * n_height_test, (ii * n_width_test + 1):(ii + 1) * n_width_test);
            image_GT = image_high_all((jj * n_height_GT + 1):(jj + 1) * n_height_GT, (ii * n_width_GT + 1):(ii + 1) * n_width_GT);
            
            imwrite(image_test, image_test_name, 'bmp');
            imwrite(image_GT, image_GT_name, 'bmp');
        end
    end
    
end



