clear; clc; close all

image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};


improve_psnr_fg_all = zeros(12, length(image_list));
improve_psnr_bg_all = zeros(12, length(image_list));
level_all = zeros(12, length(image_list));

for ii = 1:1%length(image_list)
    
    image_name = image_list{ii};
    fprintf("Testing image: %s.\n", image_name);
    
    for index = 1:12
        if index <= 9
            basename = sprintf('%s_InSample_%d', image_name, index);
        else
            basename = sprintf('%s_OutSample_%d', image_name, index-9);
        end
        
        filename = ['./SubImages/' basename '_GT.bmp'];
        image_high = imread(filename, 'bmp');
        if ~ismatrix(image_high)
            image_high = rgb2gray(image_high);
        end
        level = graythresh(image_high) - 0.06;
        level_all(index, ii) = level;
    end
    
    level = mean(level_all(:, ii));
    
    for index = 1:12
        
        if index <= 9
            basename = sprintf('%s_InSample_%d', image_name, index);
        else
            basename = sprintf('%s_OutSample_%d', image_name, index-9);
        end
        % fprintf('The name of the image: %s.\n', basename);
        
        filename = ['./SubImages/' basename '_GT.bmp'];
        image_high = imread(filename, 'bmp');
        if ~ismatrix(image_high)
            image_high = rgb2gray(image_high);
        end
        image_high = double(image_high);
        
        % Segment FG and BG
        
        BW_high = imbinarize(uint8(image_high), level);
        BW_high = imfill(BW_high, 'holes');
        
        % Remove noise
        se = strel('disk',4);
        closeBW = imclose(~BW_high, se);
        BW_high = ~closeBW;
        
        % Add boundaries
        se = strel('disk',6);
        BW_high = imdilate(BW_high, se);
       
        filename = ['./SubImages/' basename '_binary.bmp'];
        imwrite(uint8(BW_high .* 255), filename, 'bmp')
        
    end
    
end
