function [Xh, Xl] = rnd_smp_patch_self(img_path, type, patch_size, num_patch, upscale, index_name)

img_dir = dir(fullfile(img_path, [index_name type]));

Xh = [];
Xl = [];

img_num = length(img_dir);
nper_img = zeros(1, img_num);

for ii = 1:length(img_dir),
    if isempty(strfind(img_dir(ii).name, '_GT'))
        % im_l = imread(fullfile(img_path, img_dir(ii).name));
        
        [~, image_name, image_ext] = fileparts(img_dir(ii).name);
        im_h = imread(fullfile(img_path, [image_name, '_GT', image_ext])); % HR images
        nper_img(ii) = prod(size(im_h));
        
    end
end

nper_img = floor(nper_img*num_patch/sum(nper_img));

for ii = 1:img_num,
    if isempty(strfind(img_dir(ii).name, '_GT'))  
        patch_num = nper_img(ii);
        im_l = imread(fullfile(img_path, img_dir(ii).name)); % LR images
        [~, image_name, image_ext] = fileparts(img_dir(ii).name);
        im_h = imread(fullfile(img_path, [image_name, '_GT', image_ext])); % HR images
        
        [H, L] = sample_patches_paired(im_h, im_l, patch_size, patch_num);
        Xh = [Xh, H];
        Xl = [Xl, L];
    end
end

patch_path = ['Training/rnd_patches_' num2str(patch_size) '_' num2str(num_patch) '_s' num2str(upscale) '_' image_name '.mat'];
save(patch_path, 'Xh', 'Xl');