% ========================================================================
% Demo codes for dictionary training by joint sparse coding
%
% Reference
%   J. Yang et al. Image super-resolution as sparse representation of raw
%   image patches. CVPR 2008.
%   J. Yang et al. Image super-resolution via sparse representation. IEEE
%   Transactions on Image Processing, Vol 19, Issue 11, pp2861-2873, 2010
%
% Jianchao Yang
% ECE Department, University of Illinois at Urbana-Champaign
% For any questions, send email to jyang29@uiuc.edu
% =========================================================================

clear all; clc; close all;
addpath(genpath('RegularizedSC'));

TR_IMG_PATH = 'Data/Training_All';

dict_size   = 1024;          % dictionary size
lambda      = 0.15;         % sparsity regularization
patch_size  = 5;            % image patch size
nSmp        = 80000;       % number of patches to sample
upscale     = 2;            % upscaling factor

image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

for ii = 1:length(image_list)
    % randomly sample image patches
    fprintf('Building library for %s\n', image_list{ii})
    [Xh, Xl] = rnd_smp_patch_self(TR_IMG_PATH, '*.bmp', patch_size, nSmp, upscale, image_list{ii});
    % return;
    % prune patches with small variances, threshould chosen based on the
    % training data
    [Xh, Xl] = patch_pruning(Xh, Xl, 5);
    
    % joint sparse coding
    [Dh, Dl] = train_coupled_dict(Xh, Xl, dict_size, lambda);
    %c = clock;
    dict_path = ['Dictionary/D_' num2str(dict_size) '_' num2str(lambda) '_' num2str(patch_size) ...
        '_' image_list{ii} '.mat' ];
    save(dict_path, 'Dh', 'Dl');
end