clear variables; clc;

% This function is to sample patches from high-resolution images
% The training sample is in the folder 'Training'

N_p = 9; % The size of each patch (should be odd number)
N_l = 80000; % The number of patches in the library
n_class = 50;
N_p_radius = round(double(N_p - 1) / 2.0);
ratio = 2.0;

% Use 75% part of the HR image to train the patch
image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

for kk = 1:length(image_list)
    common_name = image_list{kk};
    fprintf("Build a library for: %s.\n", common_name);
    
    image_name = sprintf('%s_HR', common_name);
    image_high_all = imread([ './SubImages/', image_name, '.bmp']);
    if ~ismatrix(image_high_all)
        image_high_all = rgb2gray(image_high_all);
    end
    [n_height, n_width] = size(image_high_all);
    n_width = round(.75 * n_width);
    image_high = image_high_all(:, 1:n_width);
    
    % Load the LR image
    image_name2 = sprintf('%s_LR2', common_name);
    image_low_all = imread([ './SubImages/', image_name2, '.bmp']);
    if ~ismatrix(image_low_all)
        image_low_all = rgb2gray(image_low_all);
    end
    image_up_all = imresize(image_low_all, ratio, 'bicubic');
    image_up = image_up_all(:, 1:n_width);
    image_up = double(image_up);
    
    % Load local shift maps
    filename = ['./SubImages/', common_name, '_Shift_Map.mat'];
    load(filename);
    
    % Sample N_l*20 patches
    sample_rate = 10;
    N_sample = N_l * sample_rate;
    Patch_high = zeros(N_p * N_p, N_sample);
    Patch_up = zeros(N_p * N_p, N_sample);
    
    tic
    % Generate random samples
    x = randperm(n_height - 2 * N_p + 1) + N_p_radius;
    y = randperm(n_width - 2 * N_p + 1) + N_p_radius;
    [X,Y] = meshgrid(x,y);
    xrow = X(:); ycol = Y(:);
    
    if N_sample < length(xrow)
        random_idx = randperm(length(xrow), N_sample);
        xrow = xrow(random_idx);
        ycol = ycol(random_idx);
    end
    
    image_high = double(image_high);
    % load('Shift_Map_UPvsHR.mat');
    
    for jj = 1:length(xrow)
        shift_row = Shift_map_y(xrow(jj) + N_p_radius, ycol(jj) + N_p_radius);
        shift_col = Shift_map_x(xrow(jj) + N_p_radius, ycol(jj) + N_p_radius);
        
        Patch_temp = image_high(xrow(jj) + shift_row:(xrow(jj) + shift_row + N_p - 1), (ycol(jj) + shift_col:ycol(jj) + shift_col + N_p - 1));
        Patch_high(:, jj) = Patch_temp(:);
        
        % Load upsampled upsampled image
        Patch_temp = image_up(xrow(jj):(xrow(jj) + N_p - 1), (ycol(jj):ycol(jj) + N_p - 1));
        Patch_up(:, jj) = Patch_temp(:);
    end
    
    Patch_high = Patch_high(:, 1:length(xrow));
    Patch_up = Patch_up(:, 1:length(xrow));
    
    % Use k-means to select representative
    [idx, C] = kmeans(Patch_up', n_class, 'MaxIter', 1000);
    
    % hist_patch = histogram(idx, 0.5:(n_class + 0.5), 'LineWidth', 2);
    % set(gca,'FontName','Times New Roman','FontSize',20,'FontWeight','bold')
    % saveas(hist_patch, 'histogram_patch.bmp', 'bmp');
    % return;
    
    num_sample = round(double(N_l) / n_class);
    Patch_dictionary_high = zeros(N_p * N_p, N_l);
    Patch_dictionary_up = zeros(N_p * N_p, N_l);
    ii_start = 0;
    for ii = 1:n_class
        
        Patch_class_high = Patch_high(:, (idx == ii));
        Patch_class_up = Patch_up(:, (idx == ii));
        [~, num_class] = size(Patch_class_high);
        
        
        if num_class >= num_sample
            random_idx = randperm(num_class, num_sample);
        else
            random_idx = randi(num_class, 1, num_sample);
        end
        
        Patch_dictionary_high(:, (ii_start + 1):(ii_start + num_sample)) = Patch_class_high(:, random_idx);
        Patch_dictionary_up(:, (ii_start + 1):(ii_start + num_sample)) = Patch_class_up(:, random_idx);
        ii_start = ii_start + num_sample;
    end
    
    Patch_center = C';
    filename = sprintf('./Libraries/Library_%s_P%d_S%d_paired_shift.mat', common_name, N_p, N_l);
    save(filename, 'Patch_dictionary_high', 'Patch_dictionary_up', 'Patch_center')
end

