clc
clear all
close all

addpath('Code')
par.k = 2;                  % size of the low-resolution patch is (2k+1)x(2k+1)
par.factor=2;               % factor upscale s=2;
par.maxNumBlocks = 80000;   % Number of block in the Database.
par.epsilon = 2;

image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4',...
    '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

% thr = 0.9995; % For 0, 5, & 15
thr = 0.998; % For 45 & 60

for ii = 1:length(image_list)
    
    base_name = image_list{ii};
    fprintf('Construct a library for: %s.\n', base_name);
    image_name = sprintf('Images/Train/%s_HR.bmp', base_name);
    stdImage  =   imread(image_name);
    if size(size(stdImage),2)>2
        stdImage = rgb2gray(stdImage);
    end
    stdImage = double(stdImage);
    
    % Use left 75% image
    [~, n_width] = size(stdImage);
    n_width = round(0.75 * n_width);
    stdImage = stdImage(:, 1:n_width);
    
    image_name = sprintf('Images/Train/%s_LR2.bmp', base_name);
    stdImage2  =   imread(image_name);
    if size(size(stdImage2),2)>2
        stdImage2 = rgb2gray(stdImage2);
    end
    stdImage2 = imresize(stdImage2, par.factor);
    stdImage2 = double(stdImage2);
    stdImage2 = stdImage2(:, 1:n_width);
    
    [HR_Data, US_Data] = DataSetRandom(stdImage,2*par.k*par.k+1, par.maxNumBlocks, stdImage2);
    %% Operators: Down-scale
    D=DownScale(2*par.k*par.k+1);
    %% Low-resolution database
    LR_Data=D*US_Data;
    
    Norm = zeros(1,size(LR_Data,2));
    for i=1:size(LR_Data,2)
        Norm(i) = norm(LR_Data(:,i));
    end
    idx=find(Norm>par.epsilon);
    
    Norm = Norm(:,idx);
    HR_Data = HR_Data(:,idx);
    LR_Data = LR_Data(:,idx);
    N = size(HR_Data,2);
    
    %% Normalize database: ( ||u_i^L||=1 for all i=1,...,N)
    for i=1:N
        H_Data(:,i) = HR_Data(:,i)/Norm(i);
        L_Data(:,i) = LR_Data(:,i)/Norm(i);
    end
    % size(L_Data)
    count= 1;
    
    while count < N
        x= L_Data(:,count);
        cos = x'*L_Data;
        cos(count)= 0;
        ix = find(cos < thr);
        L_Data = L_Data(:,ix);
        H_Data = H_Data(:,ix);
        count = count +1;
        N = size(L_Data,2);
    end
    %%
    [~, n_patch] = size(L_Data);
    fprintf('Library size:%d.\n\n', n_patch);
    
    filename1 = sprintf('./Database/LR_Data_SR_%s_all.txt', base_name);
    filename2 = sprintf('./Database/HR_Data_SR_%s_all.txt', base_name);
    
    save(filename1, 'L_Data', '-ascii');
    save(filename2, 'H_Data', '-ascii');
end