%% Demo for the paper: "Novel Example-based Method for Super-Resolution and Denoising of Medical Images"
% Written by Dinh Hoan TRINH
% Version 2.0. November 11, 2013
%%-------------------------------------------------------------------------

clc
close all;
clear all;
addpath('Code');
if isempty(gcp('nocreate'))
    parpool
end

%% Setting parameters:
par.sigma=10;                % standard deviation of Gaussian noise
par.k = 2;                   % size of the low resolution block is (2k+1)x(2k+1)
par.factor=2;               % factor upscale s=2;
par.K=100;                  % K nearest neighbors
par.maxIter = 15;           % Number of back projection iterations
par.lambda = 0.001;
par.gamma =44;
%%

%%

%%

%% MAIN
image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
              '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', ...
              '45_3', '45_4', '45_5', '45_6',...
              '60_1', '60_2', '60_3', '60_4'};

improve_psnr_insample_all = zeros(9, length(image_list));
improve_psnr_outofsample_all = zeros(3, length(image_list));
improve_ssim_insample_all = zeros(9, length(image_list));
improve_ssim_outofsample_all = zeros(3, length(image_list));

SR_results = zeros(12, 4);

for ii = 1:length(image_list)
    image_name = image_list{ii};
    fprintf("Testing image: %s.\n", image_name);
    
    file_path = sprintf('./Database/LR_Data_SR_Pooled2.txt');
    LR_Data = load(file_path);
    file_path = sprintf('./Database/HR_Data_SR_Pooled2.txt');
    HR_Data = load(file_path);
    
    for i = 1:12
        
        if i <= 9
            basename = sprintf('%s_InSample_%d', image_name, i);
        else
            basename = sprintf('%s_OutSample_%d', image_name, i - 9);
        end
        % fprintf('Testing image name: %s.\n', basename);
        if i < 12
            fprintf('%d ', i);
        else
            fprintf('%d\n', i);
        end
        
        % basename = '0_1_OutSample_1';
        filename = ['./Images/Test/' basename '.bmp'];
        image_low = imread(filename, 'bmp');
        if ~ismatrix(image_low)
            image_low = rgb2gray(image_low);
        end
        image_low = double(image_low);
        % [n_height, n_width] = size(image_low);
        
        image_up = imresize(uint8(image_low), par.factor, 'bicubic');
        image_up = double(image_up);
        filename = ['../Result/SWSR/Pooled/' basename '_BI.bmp'];
        imwrite(uint8(image_up),filename, 'bmp');
        
        % Load ground truth
        filename = ['./Images/Test/' basename '_GT.bmp'];
        image_high = imread(filename, 'bmp');
        if ~ismatrix(image_high)
            image_high = rgb2gray(image_high);
        end
        image_high = double(image_high);
        filename = ['../Result/SWSR/Pooled/' basename '_GT.bmp'];
        imwrite(uint8(image_high),filename, 'bmp');
        
        % SR
        [~,image_filtered] = SRSW(image_low, HR_Data, LR_Data, par);
        filename = ['../Result/SWSR/Pooled/' basename '_SRSW.bmp'];
        imwrite(uint8(image_filtered),filename, 'bmp');
        
        psnr_up = psnr(uint8(image_high), uint8(image_up));
        psnr_filtered = psnr(uint8(image_high), uint8(image_filtered));
        % fprintf('PSNR before and after LB-NLM filter: %.3f dB and %.3f dB.\n', psnr_up, psnr_filtered);
        
        ssim_up = ssim(uint8(image_high), uint8(image_up));
        ssim_filtered = ssim(uint8(image_high), uint8(image_filtered));
        % fprintf('SSIM before and after LB-NLM filter: %.3f and %.3f.\n\n', ssim_up, ssim_filtered);
        
        SR_results(i, 1) = psnr_up;
        SR_results(i, 2) = psnr_filtered;
        SR_results(i, 3) = ssim_up;
        SR_results(i, 4) = ssim_filtered;
        
        % fprintf('\nImprovemnt of PSNR:%.4f.\n', psnr_filtered - psnr_up);
        % fprintf('Improvemnt of SSIM:%.4f.\n', ssim_filtered - ssim_up);
        
    end
    
    % filename = ['./Images/Results_Pooled/' image_name '_SRSW', '.mat'];
    % save(filename, 'SR_results');
    
    improve_psnr_insample_all(:, ii) = SR_results(1:9, 2) - SR_results(1:9, 1);
    improve_ssim_insample_all(:, ii) = SR_results(1:9, 4) - SR_results(1:9, 3);
    
    improve_psnr_insample = mean(SR_results(1:9, 2)) - mean(SR_results(1:9, 1));
    improve_ssim_insample = mean(SR_results(1:9, 4)) - mean(SR_results(1:9, 3));
    fprintf("The improvement of the PSNR for the in-sample images is %.4f.\n", improve_psnr_insample);
    fprintf("The improvement of the SSIM for the in-sample images is %.4f.\n", improve_ssim_insample);
    
    improve_psnr_outofsample_all(:, ii) = SR_results(10:12, 2) - SR_results(10:12, 1);
    improve_ssim_outofsample_all(:, ii) = SR_results(10:12, 4) - SR_results(10:12, 3);
    
    improve_psnr_outofsample = mean(SR_results(10:12, 2)) - mean(SR_results(10:12, 1));
    improve_ssim_outofsample = mean(SR_results(10:12, 4)) - mean(SR_results(10:12, 3));
    fprintf("The improvement of the PSNR for the out-of-sample images is %.4f.\n", improve_psnr_outofsample);
    fprintf("The improvement of the SSIM for the out-of-sample images is %.4f.\n\n", improve_ssim_outofsample);
    
end

fprintf("All testing images completed.\n");
fprintf("The improvement of the PSNR for the in-sample images is %.4f.\n", mean(improve_psnr_insample_all(:)));
fprintf("The improvement of the SSIM for the in-sample images is %.4f.\n", mean(improve_ssim_insample_all(:)));
fprintf("The improvement of the PSNR for the out-of-sample images is %.4f.\n", mean(improve_psnr_outofsample_all(:)));
fprintf("The improvement of the SSIM for the out-of-sample images is %.4f.\n\n", mean(improve_ssim_outofsample_all(:)));

