function [Denoised_im, output] = SRSW(LR,HR_Data,LR_Data, par)

Mask = gaussMask(1,2*par.k);
[r,c] =   size(LR);
%algorithm = 'OMP';
algorithm = 'NQP';

inMatrix    =   im2col(LR,[2*par.k+1,2*par.k+1],'sliding');   
Weight      =   zeros(par.factor*r-1,par.factor*c-1);
output      =   zeros(par.factor*r-1,par.factor*c-1);
    
Denoised_im = zeros(size(LR));
Weightt = zeros(size(LR));
    
%Upsample via factor 2:
d=0;
wb=waitbar(0,'Super resolution in process...');
for i=par.k+1:(c-par.k)
    waitbar(i/(c-par.k),wb);
    for j=par.k+1:r-par.k   
            d=d+1;
            y= inMatrix(:,d);
            if algorithm == 'NQP'
                yy = y/norm(y);
                U = yy'*LR_Data;
                [U,IX] = sort(U,'descend');

                 A = LR_Data(:,IX(1:200));
                 G = HR_Data(:,IX(1:200));
                 [W,Ind]=SimilarSearch(A,y,par.sigma,par.K);
                 %HH = max(W)/(length(y)*par.sigma^2)
                A = A(:,Ind);
                G = G(:,Ind);
                if par.sigma>0
                inx = find(W>(par.gamma*length(y)*par.sigma^2));       
                W(inx)=exp(W(inx));
                end
                x = NQP(A,y,W,par.sigma,par.lambda);
            else
                A = LR_Data;
                G = HR_Data;
                x = OMPerr(A,y,par.sigma);
            end
%%
            P1 = A*x;
            P1 = reshape(P1,2*par.k+1,2*par.k+1);
            Denoised_im(j-par.k:j+par.k,i-par.k:i+par.k)=Denoised_im(j-par.k:j+par.k,i-par.k:i+par.k)+reshape(P1,2*par.k+1,2*par.k+1).*ones(2*par.k+1,2*par.k+1);
            Weightt(j-par.k:j+par.k,i-par.k:i+par.k)=Weightt(j-par.k:j+par.k,i-par.k:i+par.k)+ ones(2*par.k+1,2*par.k+1);
            
            P=G * x;
            P = reshape(P,2*par.k*par.k+1,2*par.k*par.k+1);     
            output(2*j-1-2*par.k:2*j-1+2*par.k,2*i-1-2*par.k:2*i-1+2*par.k)=output(2*j-1-2*par.k:2*j-1+2*par.k,2*i-1-2*par.k:2*i-1+2*par.k)+P.*Mask;
            Weight(2*j-1-2*par.k:2*j-1+2*par.k,2*i-1-2*par.k:2*i-1+2*par.k)=Weight(2*j-1-2*par.k:2*j-1+2*par.k,2*i-1-2*par.k:2*i-1+2*par.k)+ Mask;
   end 
end
close(wb);
Denoised_im = Denoised_im./Weightt;
output = output./Weight; 
output = imresize(output,[par.factor*r par.factor*c]);
%output(end,:)=output(end-1,:);
%output(:,end)= output(:,end-1);

