function [blkMatrix, blkMatrix2]=DataSetRandom(image,block_size,maxNumBlocks, image2)

[NN1,NN2] = size(image);

if(prod([NN1,NN2]- block_size+1)> maxNumBlocks)
    randPermutation =  randperm(prod([NN1,NN2]- block_size +1));
    selectedBlocks = randPermutation(1:maxNumBlocks);

    blkMatrix = zeros(block_size^2,maxNumBlocks);
    blkMatrix2 = blkMatrix;
    for i = 1:maxNumBlocks
        [row,col] = ind2sub(size(image)-block_size+1,selectedBlocks(i));
        currBlock = image(row:row+ block_size -1,col:col+ block_size -1);
        blkMatrix(:,i) = currBlock(:);
        currBlock = image2(row:row+ block_size -1,col:col+ block_size -1);
        blkMatrix2(:,i) = currBlock(:);
    end
else
    blkMatrix = im2col(image,[block_size,block_size],'sliding');
    blkMatrix2 = im2col(image2,[block_size,block_size],'sliding');
end

