clear; close all

% SR factors
ratio = 2.;

image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};
diff_thr = 25;

for kk = 1:length(image_list)
    general_name = image_list{kk};
    fprintf("Local Registration: %s.\n", general_name);
    
    % Match the position of patches
    filename = ['./SubImages/', general_name, '_HR.bmp'];
    image_high = imread(filename, 'bmp');
    if ~ismatrix(image_high)
        image_high = rgb2gray(image_high);
    end
    image_high = double(image_high);
    [n_height, n_width] = size(image_high);
    
    filename = ['./SubImages/', general_name, '_LR2.bmp'];
    image_low = imread(filename, 'bmp');
    if ~ismatrix(image_low)
        image_low = rgb2gray(image_low);
    end
    image_up = imresize(image_low, ratio, 'bicubic');
    image_up = double(image_up);
    % return;
    
    % Patch size
    N_p = 9;
    N_p_radius = round(double(N_p - 1) / 2.0);
    
    % Match each patch
    Shift_map_x = zeros(n_height, n_width);
    Shift_map_y = zeros(n_height, n_width);
    search_range = 1;
    CoMatrix = zeros(2 * search_range + 1, 2 * search_range + 1);
    DisMatrix = zeros(2 * search_range + 1, 2 * search_range + 1);
    patch_up = zeros(N_p, N_p);
    patch_high = zeros(N_p, N_p);
    % StdMatrix = ones(n_height, n_width);
    
    [n_height, n_width] = size(image_high);
    for ii = 1 + N_p_radius + search_range : n_height - N_p_radius - search_range
        for jj = 1 + N_p_radius + search_range: n_width - N_p_radius - search_range
            
            patch_up = image_up(ii - N_p_radius:ii + N_p_radius, jj - N_p_radius:jj + N_p_radius);
            
            var_patch = std(patch_up(:));
            % StdMatrix(ii, jj) = var_patch;
            
            % Find a match
            if var_patch > 10
                
                CoMatrix = 0 .* CoMatrix;
                DisMatrix = 0 .* DisMatrix;
                for ii_offset = ii - search_range: ii + search_range
                    for jj_offset = jj - search_range: jj + search_range
                        
                        patch_high = image_high(ii_offset - N_p_radius:ii_offset + N_p_radius, jj_offset - N_p_radius:jj_offset + N_p_radius);
                        Temp_Matrix = corrcoef(patch_up(:),  patch_high(:));
                        CoMatrix(ii_offset - ii + search_range + 1, jj_offset - jj + search_range + 1) = Temp_Matrix(1,2);
                        
                        DisMatrix(ii_offset - ii + search_range + 1, jj_offset - jj + search_range + 1) = sum((patch_up(:)-patch_high(:)).^2);
                        
                    end
                end
                
                maximum = max(max(CoMatrix));
                minimum = min(min(DisMatrix));
                av_diff = sqrt(minimum / (N_p * N_p));
                
                if maximum > .9 && av_diff < diff_thr
                    [ii_max, jj_max] = find(CoMatrix == maximum, 1);
                    [ii_min, jj_min] = find(DisMatrix == minimum, 1);
                    
                    if (ii_max == ii_min) && (jj_max == jj_min)
                        Shift_map_y(ii, jj) = ii_max - search_range - 1;
                        Shift_map_x(ii, jj) = jj_max - search_range - 1;
                    end
                end
            end
            
        end
    end
    
    % % Draw the results
    % Shift_all = abs(Shift_map_x) + abs(Shift_map_y);
    % [y_arrow, x_arrow] = find(Shift_all >= 1);
    %
    % m_sample = 8;
    % figure
    % h = imshow(uint8(image_up), 'Border', 'tight');
    % hold on
    % for ii = 1:length(x_arrow)
    %     if mod(x_arrow(ii), m_sample) == 0 && mod(y_arrow(ii), m_sample) == 0
    %         x_end = x_arrow(ii) + m_sample * Shift_map_x(y_arrow(ii), x_arrow(ii));
    %         y_end = y_arrow(ii) + m_sample * Shift_map_y(y_arrow(ii), x_arrow(ii));
    %         if y_end < 1 || y_end > n_height || x_end < 1 || x_end > n_width
    %             continue;
    %         end
    %         % fprintf('Locacation: %d, %d. End: %d, %d. \n', y_arrow(ii), x_arrow(ii), y_end, x_end);
    %         arrow([x_arrow(ii) y_arrow(ii)], [x_end  y_end], 5, 'EdgeColor','r', 'FaceColor', 'r')
    %
    %     end
    % end
    % hold off
    % savename = ['./Data/', general_name, '_LocalReg.bmp'];
    % saveas(h, savename, 'bmp');
    
    savename = ['./SubImages/', general_name, '_Shift_Map.mat'];
    save(savename, 'Shift_map_x', 'Shift_map_y');
end
