close all; clc; clear variables


theta_offset = 0;
image_list = {'0_1', '0_2', '0_3', '0_4', '5_1', '5_2', '5_3', '5_4',...
    '15_1', '15_2', '15_3', '15_4', '45_1', '45_2', '45_3', '45_4', '45_5', '45_6',...
    '60_1', '60_2', '60_3', '60_4'};

for jj = 1:length(image_list)
    filename = image_list{jj};
    
    fprintf("Register Image Pair: %s.\n", filename);
    
    image_low = imread(['./RawData/', filename, '_10000.bmp']);
    image_high = imread(['./RawData/', filename, '_20000.bmp']);
    
    bottom_margin = 80;
    [n_height, n_width] = size(image_high);
    n_height = n_height - bottom_margin;
    image_low = image_low(1:n_height, :);
    image_high = image_high(1:n_height, :);
    
    ratio = 2.0;
    
    % Find initial value
    n_height_bench = 100;
    ratio_bench = double(n_height_bench) / double(n_height);
    image_low_bench = imresize(image_low, ratio_bench);
    image_high_bench = imresize(image_high, ratio_bench ./ ratio);
    [n_height_bench_low, n_width_bench_low] = size(image_low_bench);
    [n_height_bench_high, n_width_bench_high] = size(image_high_bench);
    
    se_matrix_bench = zeros(n_height_bench_low - n_height_bench_high + 1, n_width_bench_low - n_width_bench_high + 1);
    for i_height = 1:n_height_bench_low - n_height_bench_high + 1
        for i_width = 1:n_width_bench_low - n_width_bench_high + 1
            image_diff = double(image_high_bench) - double(image_low_bench(i_height: i_height + n_height_bench_high - 1, i_width:i_width + n_width_bench_high - 1));
            se_matrix_bench(i_height, i_width) = mean(image_diff(:).^2);
        end
    end
%     surf(se_matrix_bench)
%     pause(.5)
    [min_SE,I] = min(se_matrix_bench(:));
    [I_height, I_width] = ind2sub(size(se_matrix_bench),I);
    offset_height = round(double(I_height) / ratio_bench);
    offset_width = round(double(I_width) / ratio_bench);
    
    rmse = sqrt(min_SE);
    psnr = 20*log10(255/rmse);
    fprintf('Find the initial offset; location: %d, %d; PSNR: %.4f.\n', offset_height, offset_width, psnr);
    
    image_high_resize = imresize(image_high, 1/ratio);
    [n_height_resize, n_width_resize] = size(image_high_resize);
    
    begin_height = -25;
    begin_width = -25;
    range_height = 51;
    range_width = 51;
    se_matrix = zeros(range_height, range_width);
    
    for i_height = begin_height:begin_height + range_height - 1
        for i_width = begin_width:begin_width + range_width - 1
            
            se_matrix(i_height - begin_height + 1, i_width - begin_width + 1) = 2e3;
            if offset_height + i_height >= 1 && offset_height + i_height + n_height_resize - 1 <= n_height
                if offset_width + i_width >= 1 && offset_width + i_width + n_width_resize - 1 <= n_width
                    image_diff = double(image_high_resize) - double(image_low(offset_height + i_height: offset_height + i_height + n_height_resize - 1, offset_width + i_width:offset_width + i_width + n_width_resize - 1));
                    se_matrix(i_height - begin_height + 1, i_width - begin_width + 1) = mean(image_diff(:).^2);
                end
            end
        end
    end
    
%     figure
%     surf(se_matrix)
%     pause(.5)
    [min_SE,I] = min(se_matrix(:));
    [I_height, I_width] = ind2sub(size(se_matrix),I);
    
    offset_height = offset_height + begin_width + I_height - 1;
    offset_width = offset_width + begin_width + I_width - 1;
    rmse = sqrt(min_SE);
    psnr1 = 20*log10(255/rmse);
    fprintf('Find the downsampled offset; location: %d, %d; PSNR: %.4f.\n', offset_height, offset_width, psnr1);
    
    % Match in the enlarged image
    n_edge = 5;
    
    image_low_field_or = image_low(offset_height:offset_height + n_height_resize - 1, offset_width:offset_width+ n_width_resize - 1);
    image_low_field = image_low(offset_height - n_edge:offset_height + n_height_resize - 1 + n_edge, offset_width - n_edge:offset_width+ n_width_resize - 1 + n_edge);
    image_low_field_enlarged = imresize(image_low_field, ratio);
    
    
    [n_height_enlarged, n_width_enlarged] = size(image_low_field_enlarged);
    
    theta_candi = ((-10:1:10) + theta_offset) .* 0.01;
    psnr_candi = zeros(1, length(theta_candi));
    offset_candi = zeros(2, length(theta_candi));
    
    for ii = 1:length(theta_candi)
        theta_rotate = theta_candi(ii);
        image_low_field_rotated = imrotate(image_low_field_enlarged,  theta_rotate, 'bilinear', 'crop');
        
        se_matrix_2 = zeros(n_height_enlarged - n_height + 1, n_width_enlarged - n_width + 1);
        for i_height = 1 : n_height_enlarged - n_height + 1
            for i_width = 1 : n_width_enlarged - n_width + 1
                
                image_diff = double(image_high) - double(image_low_field_rotated(i_height: i_height + n_height - 1, i_width:i_width + n_width - 1));
                se_matrix_2(i_height, i_width) = mean(image_diff(:).^2);
                
            end
        end
        
        [min_SE_2,I] = min(se_matrix_2(:));
        [I_height_2, I_width_2] = ind2sub(size(se_matrix_2),I);
        
        rmse = sqrt(min_SE_2);
        psnr = 20*log10(255/rmse);
        fprintf('Find the refined offset; oritation: %.2f; location: %d, %d; PSNR: %.4f.\n', theta_rotate, I_height_2, I_width_2, psnr);
        
        psnr_candi(ii) = psnr;
        offset_candi(:, ii) = [I_height_2, I_width_2]';
    end
    
    [~, II] = max(psnr_candi);
    image_low_field_rotated = imrotate(image_low_field_enlarged,  theta_candi(II), 'bilinear', 'crop');
    image_low_field_enlarged = image_low_field_rotated(offset_candi(1, II): offset_candi(1, II) + n_height - 1, offset_candi(2, II):offset_candi(2, II) + n_width - 1);
    image_low_field_new = imresize(image_low_field_enlarged, 1/ratio);
    image_diff = double(image_high_resize) - double(image_low_field_new);
    rmse = sqrt(mean(image_diff(:).^2));
    psnr2 = 20*log10(255/rmse);
    offset_height_final = offset_height + double(offset_candi(1, II) - 1) ./ ratio - n_edge;
    offset_width_final = offset_width + double(offset_candi(2, II) - 1) ./ ratio - n_edge;
    fprintf('Find the final offset; oritation: %f; location: %.1f, %.1f; PSNR: %.4f; improvement: %.4f.\n\n', theta_candi(II), offset_height_final, offset_width_final, psnr2, psnr2 - psnr1);
    
    image_high_color =  cat(3, image_high, image_high, image_high);
    image_high_resize_color =  cat(3, image_high_resize, image_high_resize, image_high_resize);
    image_low_field_color = cat(3, image_low_field_or, image_low_field_or, image_low_field_or);
    image_low_field_new_color = cat(3, image_low_field_new, image_low_field_new, image_low_field_new);
    
    
    
    imwrite(image_high_color, ['./SubImages/', filename, '_HR.bmp'], 'bmp')
    % imwrite(image_high_resize_color, ['./Data/', filename, '_DS.bmp'], 'bmp')
    % imwrite(image_low_field_color, ['./Data/', filename, '_LR.bmp'], 'bmp')
    imwrite(image_low_field_new_color, ['./SubImages/', filename, '_LR2.bmp'], 'bmp')
end