function [mu,s2,elapsed] = pic_pred(x, model)

% pic_pred: predictive distribution for PIC given hyperparameters
% and pseudo-inputs
%
% x        test inputs
% model    trained model
% mu       predictive mean
% s2       predictive variance of latent function
% elapsed  the total time spent on prediction
%
% Copyright (c) by Chiwoo Park, 2011-06-07

param      = model.param;
hyp        = param.hyp;
subdomains = model.subdomains;

D = sq_dist(x', model.cpt');
[dum, blockid] = min(D,[],2);
ngrp = size(subdomains, 1);
ns = size(x,1);
mu = zeros(ns, 1); s2 = zeros(ns, 1);
tic;
for i = 1:ngrp
    sd   = subdomains{i};
    segI = logical(blockid == i);
    [mu_i, s2_i] = local_pic_pred(x(segI, :), model, sd, hyp);
    mu(segI, :)  = mu_i; s2(segI, :) = s2_i;
end
elapsed = toc;
end
