function [mu,s2] = local_pic_pred(sx, model, sd, hyp)

% local_pic_pred: predictive distribution for PIC given hyperparameters
% and pseudo-inputs
%
% sx       test inputs
% model    trained model
% mu       predictive mean
% s2       predictive variance of latent function
%
% Copyright (c) by Chiwoo Park, 2011-06-07

xb      = model.xb;

% test predictions
K_tM = kern(sx,xb,hyp);
K_tt = kern(sx,sx,hyp);
K_tB = kern(sx,sd.x,hyp);

% complexity O(M+B) and O(M+B)^2
K_tB1 = K_tM * model.iK_M * sd.K_BM';
mu = K_tM * model.iKy + (K_tB - K_tB1) * sd.Dy;
s2 = kdiag(sx, hyp) + diag(K_tt - K_tM * model.iK * K_tM' - 2*(K_tB - K_tB1) * sd.DK * K_tM' - (K_tB - K_tB1) * sd.DD * (K_tB - K_tB1)');

% Can replace with whatever kernel function you want:
function K = kern(x1,x2,hyp)

n1 = size(x1, 1); n2 = size(x2,1);
b = exp(hyp(1:end-2)); c = exp(hyp(end-1));

x1 = x1.*repmat(sqrt(b)',n1,1);
x2 = x2.*repmat(sqrt(b)',n2,1);

K = -2*x1*x2' + repmat(sum(x2.*x2,2)',n1,1) + repmat(sum(x1.*x1,2),1,n2);
K = c*exp(-0.5*K);

function Kd = kdiag(x,hyp)

c = exp(hyp(end));
Kd = repmat(c,size(x,1),1);