function [model, subdomains] = learn_pic(x, subdomains, param)

%
% learn_pic: learning a pic model
%
% x              :training inputs (N x dim)
% param.xb       :pseudo inputs (n x dim)
% param.covfunc  :prior covariance function 
% param.logtheta :log hyperparameters of the prior covariance function
%
% Copyright (c) by Chiwoo Park, 2011-06-07

del = 1e-3; % default jitter

hyp = param.hyp;
xb  = param.xb;
M   = size(xb,1); 

% precomputations
K_M  = sqexp(xb,xb, hyp) + del*eye(M);  %noiseless cov + jitter
K_M  = (K_M + K_M')./2;
K_NM = sqexp(x, xb, hyp);               
L_M  = chol(K_M)';
iLK  = L_M\K_NM';

nGrp    = size(subdomains, 1);
P_M     = eye(M);
X       = zeros(M, 1);
for i = 1:nGrp
    sd    = subdomains{i};
    K_B   = noise(sd.x, hyp) + sqexp(sd.x, sd.x, hyp);
    K_B   = (K_B + K_B')./2;
    D_B   = K_B - iLK(:,sd.segI)'*iLK(:,sd.segI);
    D_B   = (D_B + D_B')./2;
    sd.iD = inv(D_B);
    K_BM  = K_NM(sd.segI,:);
    sd.K_BM = K_BM;
    sd.iDK = sd.iD * K_BM;
    
    P_M = P_M + K_BM' * sd.iD * K_BM;
    X     = X   + K_BM' * sd.iD * sd.y;
    subdomains{i} = sd;
end

%  
Q_M = K_M + P_M;
Q_M = (Q_M+Q_M')./2;  
C_L = chol(Q_M)';
iQ_M = inv(Q_M);
iK_M = inv(K_M);

b1 = C_L \ X;
b2 = C_L \ P_M;
model.iKy = iK_M * (X - b2' * b1);
model.iK  = iK_M * (P_M - b2' * b2) * iK_M; 
model.iK_M = iK_M;
model.xb = xb;

for i = 1:nGrp
    sd     = subdomains{i};
    sd.DD  = sd.iD - sd.iDK * iQ_M * sd.iDK';
    sd.DK  = (sd.iDK - sd.iDK * iQ_M * P_M) * iK_M; 
    sd.Dy  = sd.iD * sd.y - sd.iDK * iQ_M * X;
    subdomains{i} = sd;
end
end

function K = sqexp(x1,x2,hyp)
n1 = size(x1, 1); n2 = size(x2,1);
b = exp(hyp(1:end-2)); c = exp(hyp(end-1));

x1 = x1.*repmat(sqrt(b)',n1,1);
x2 = x2.*repmat(sqrt(b)',n2,1);

K = -2*x1*x2' + repmat(sum(x2.*x2,2)',n1,1) + repmat(sum(x1.*x1,2),1,n2);
K = c*exp(-0.5*K);
end 

function Kd = noise(x,hyp)
sig2 = exp(hyp(end));
Kd   = sig2 * eye(size(x,1));
end 