function [subdomains, cpt] = kmeansMesh(K, x, y, idx)
%
%  partition the training inputs into K local blocks by k-means clustering 
%  usage:
%     [subdomains, cpt] = kmeansMesh(K, x, y, idx)
%  where 
%
%     K         : the number of subdomains
%     x         : n by d matrix of training inputs
%     y         : column vector of length n of training targets
%     idx       : logical mask to indicate the subset of training data
%                 used for learning the hyperparameters.
%     subdomains: N-by-1 cell array, containing the information about 
%                 a partition of training inputs by k-means clustering
%     cpt       : center locations of the K local blocks
%
% Copyright (c) by Chiwoo Park, 2011-06-07

%[blockid, cpt] = kmeans(x,K);
kmeansopt = [0 1e-5 1e-4 0 0 0 0 0 0 0 0 0 0 100];
r = randperm(size(x,1));
[cpt,opt,post] = kmeans(x(r(1:K),:),x,kmeansopt);
[m, blockid] = max(post,[],2);

subdomains = cell(K, 1);
for i = 1:K
    segI    = logical(blockid == i);
    sd.segI = segI;
    sd.x    = x(sd.segI, :);
    sd.n    = size(sd.x, 1);
    sd.y    = y(sd.segI, :);
    sd.hx   = x(sd.segI & idx, :);
    sd.hy   = y(sd.segI & idx, :);
    subdomains{i} = sd;
end