% unit testing for gen_random_subset

addpath('./pddm-multinode')
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

global comm; % communication channel
global my_rank
global comm_size
global sp_task
global ep_task
global ntask

% Initialize MPI (Message Passing Interface) for MATLAB or Octave.
MPI_Init;

% Create communicator.
comm = MPI_COMM_WORLD;

% Get size and rank.
comm_size = MPI_Comm_size(comm);
my_rank   = MPI_Comm_rank(comm);

N = 200;

% parallelize the loop with the size of N
[sp_task, ep_task, ntask] = splitTask(N, comm_size);
tic
% perform local updates
loglike = 0; dloglike = zeros(4,1);
for i = sp_task(my_rank+1):ep_task(my_rank+1)
    loglike = loglike + rand(1,1);
    dloglike = dloglike + rand(4,1);
end

% combine local results into a global one & re-distribute the global one to
% all slave nodes.
tag2 = 50000;
tag4 = 70000;
mycenter = floor(my_rank/8) * 8;

if (my_rank ~= mycenter)  %for slave nodes
    MPI_Send(mycenter, tag2, comm, loglike, dloglike);
    [loglike,dloglike] = MPI_Recv(mycenter, tag4, comm);
else % for master nodes
    for j = 1:7
        src_loc = my_rank+j;
        [loglike1, dloglike1] = MPI_Recv(src_loc, tag2, comm);
        loglike = loglike+loglike1;
        dloglike = dloglike+dloglike1;
    end
    
    for j = 1:7
        src_loc = my_rank+j;
        MPI_Send(my_rank, tag4, comm, loglike, dloglike);
    end
end

disp('SUCCESS');
disp(loglike);
disp(dloglike);
toc
MPI_Finalize;
