% unit testing for gen_random_subset

addpath('./pddm-multinode')
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

global comm; % communication channel
global my_rank
global comm_size
global sp_task
global ep_task
global ntask

% Initialize MPI (Message Passing Interface) for MATLAB or Octave.
MPI_Init;

% Create communicator.
comm = MPI_COMM_WORLD;

% Get size and rank.
comm_size = MPI_Comm_size(comm);
my_rank   = MPI_Comm_rank(comm);

% make jobs
N = 200;
for i = 1:N
    sd.a = i*100;
    sd.b = i*eye(10);
    sd.c = i*ones(10, 10);
    subdomains{i, 1} = sd;
end

% parallelize the loop with the size of N
[sp_task, ep_task, ntask] = splitTask(N, comm_size);

% perform precomputation necessary for training local models
names = {'a', 'b', 'c'};
nFields = size(names, 2);
localData = cell(ntask(my_rank+1), nFields+1);
for i = sp_task(my_rank+1):ep_task(my_rank+1)
    sd = subdomains{i, 1};
    task_id = i - sp_task(my_rank+1) + 1;
    for j = 1:nFields
        localData{task_id, j} = sd.(names{j});
    end
    localData{task_id, nFields+1} = i;
end 
% send local computation results to a master node for update
collectLocalDataToCenter('11000', localData, names);
disp('SUCCESS');

MPI_Finalize;