% unit testing for gen_random_subset

addpath('./pddm-multinode')
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

global comm; % communication channel
global my_rank

% Initialize MPI (Message Passing Interface) for MATLAB or Octave.
MPI_Init;

% Create communicator.
comm = MPI_COMM_WORLD;

% Get rank.
my_rank = MPI_Comm_rank(comm);

n = 1000;
fracs = [0.2];
tic
[indices] = gen_random_subset(n, fracs);
toc
disp(sum(indices{1})/n);


MPI_Finalize;
