function [sp_task, ep_task, ntask] = splitTask(N, comm_size)
% This function allocates a part of tasks to each node in the cluster
% sp_task:  the starting index of task ids to be performed by 
%           the current node
% ep_task:  the ending index of task ids to be performed by 
%           the current node
% n_task:   the number of tasks to be performed by the current node
%
% Copyright (c) by Chiwoo Park, 2011-06-07

rlp     = round(N / comm_size);
sp_task = (0:comm_size-1)*rlp + 1;
ep_task = (1:comm_size)*rlp; 
ep_task(end) = N;
ntask = ep_task - sp_task + 1;
end