function [] = shareLocalData(tag_s, tag_b, localData, names)
%
% MatMPI wrappter function
% 
% If this function is executed at a slave node, this function sends 
% 'localData' to the master node. If this function is executed at a master
% node, the function receives 'localData' from all slave nodes and update the 
% fields (specified by 'names' input parameter) of subdomains. Then, the
% function broadcasts all the collected 'localData' to every slave node so
% that the slave nodes can update their own local copies. 
% 
% tag_s:    message identifier used by a slave node to send its localData 
% tag_b:    message identifier used by a master node to broadcast all the
%           collected localDatas
% localData: local data to be updated to a master node
% names:     the field names in 'subdomain' structure, which are updated
%            via localData
% Copyright (c) by Chiwoo Park, 2011-06-07

global my_rank  % node id
global comm     % communication channel
global comm_size % the total number of nodes in the cluster
global ntask     % the total number of tasks to be done
global subdomains 
global N
global sp_task   % the starting index of task ids to be performed by 
                 %                                      the current node

nFields = size(names, 2);
if (my_rank ~= 0) % each slave node reports its update to the master node
    MPI_Send(0, tag_s, comm, localData);
    %receive the updates from the other slave nodes via the master node
    globalData1 = MPI_Recv(0, tag_b, comm); 
    for i = 1:N
        for m = 1:nFields
            subdomains{i}.(names{m}) = globalData1{i,m};
        end
    end
else 
    % the master node compile all 'localData' from the slave nodes
    globalData = cell(N, nFields);
    for k = 1:ntask(1)
        for m = 1:nFields
            globalData{k, m} = localData{k, m};
        end
    end
    
    for j = 1:comm_size-1
        localData1 = MPI_Recv(j, tag_s, comm);
        for k = 1:ntask(j+1)
            l = sp_task(j+1) + k - 1;
            for m = 1:nFields
                subdomains{l}.(names{m}) = localData1{k,m};
                globalData{l, m} = localData1{k, m};
            end
        end
    end
   % broadcast the compiled 'localData' to the slave nodes
   MPI_Bcast(0, tag_b, comm, globalData);
end