function [loglike, dloglike] = loglikelihood_ddm_mn(logtheta, covfunc, subdomains)
%
% loglikelihood_ddm_mn - The function returns minus the log likelihood and its 
% partial derivatives with respect to the hyperparameters; this mode is 
% used to fit the hyperparameters.
%
% where:
%   logtheta:  a (column) vector of log hyperparameters
%   covfunc:   prior covariance function
%   subdomains: N-by-1 cell array, containing the information about 
%               the structure of domain decomposition
% 
% Copyright (c) by Chiwoo Park, 2011-06-07

global affine
global comm
global my_rank
global sp_task
global ep_task
global mycenter
global nproc

loglike = 0; dloglike = zeros(size(logtheta));
for i = sp_task(my_rank+1):ep_task(my_rank+1)
    sd = subdomains{i};
    [LL, dLL] = loglikelihood(logtheta, covfunc, affine(sd.hx, sd), sd.hy);
    loglike = loglike + LL;
    dloglike = dloglike + dLL;
end

%combine local results into a global one & re-distribute the global one to
%all slave nodes.
tag2 = 50000;
tag4 = 70000;
if (my_rank ~= mycenter)  %for slave nodes
    MPI_Send(mycenter, tag2, comm, loglike, dloglike);
    [loglike,dloglike] = MPI_Recv(mycenter, tag4, comm);
else % for master nodes
    for j = 1:nproc-1
        src_loc = my_rank+j;
        [loglike1, dloglike1] = MPI_Recv(src_loc, tag2, comm);
        loglike = loglike+loglike1;
        dloglike = dloglike+dloglike1;
    end
    
    for j = 1:nproc-1
        src_loc = my_rank+j;
        MPI_Send(src_loc, tag4, comm, loglike, dloglike);
    end
end
% if (my_rank ~= 0)  %for slave nodes
%     MPI_Send(0, tag2, comm, loglike, dloglike);
%     [loglike,dloglike] = MPI_Recv(0, tag4, comm);
% else % for master nodes
%     for j = 1:comm_size-1
%         [loglike1, dloglike1] = MPI_Recv(j, tag2, comm);
%         loglike = loglike+loglike1;
%         dloglike = dloglike+dloglike1;
%     end
%     MPI_Bcast( 0, tag4, comm, loglike, dloglike);
% end