function [indices] = gen_random_subset(n, fracs)
%
% Generate random subsets of [1:n] having 'fracs' proportion of n original
% numbers (1:n). 
%
% Copyright (c) by Chiwoo Park, 2011-06-07

global my_rank
global comm

tag1 = 11100;
nf = length(fracs);
if my_rank == 0
    indices = cell(nf, 1);
    for i = 1:nf
        [dum,I]    = sort(rand(n,1)); clear dum;
        indices{i} = I(1:round(n * fracs(i)));
    end
    MPI_Bcast(0, tag1, comm, indices);
else
    indices = MPI_Recv(0, tag1, comm);
end

for i =1:nf
    I      = indices{i};
    idx    = zeros(n,1); 
    idx(I) = 1; 
    indices{i} = logical(idx);
end