function [mu, s2, elapsed] = ddm_pred_mn(xs, model)

% ddm_pred: predictive distribution for the domain decomposition approach
% given hyperparameters
%
% xs       test inputs
% model    trained model
% mu       predictive mean
% s2       predictive variance of latent function
% elapsed  the total time spent on prediction
%
% Copyright (c) by Chiwoo Park, 2011-06-07

global my_rank
global sp_task
global ep_task
global comm_size
global comm

cv_param = model.cv_param;

subdomains = addTestSet(model.subdomains, model.memberFunc, xs);
ns = size(xs,1);
mu = zeros(ns, 1); s2 = zeros(ns, 1);
tic;
for i = sp_task(my_rank+1):ep_task(my_rank+1)
    sd = subdomains{i};
    if sum(sd.tsegI) > 0   %update if there are test inputs in the current 
                           %                                     subdomain
        [mu_i, s2_i] = ddm_pred2(sd, cv_param.covfunc);
        mu(sd.tsegI, :) = mu_i; s2(sd.tsegI, :) = s2_i;
    end
end
upd_idx = find(mu);

% send the result to the master node for update
tag2 = 20000;
tag3 = 30000;
tag4 = 40000;
if (my_rank ~= 0)
    MPI_Send(0, tag2, comm, mu(upd_idx, :));
    MPI_Send(0, tag3, comm, s2(upd_idx, :));
    MPI_Send(0, tag4, comm, upd_idx);
else
    for j = 1:comm_size-1
        mu_i = MPI_Recv(j, tag2, comm);
        s2_i = MPI_Recv(j, tag3, comm);
        upd_idx = MPI_Recv(j, tag4, comm);
        mu(upd_idx, :) = mu_i;
        s2(upd_idx, :) = s2_i;
    end
    elapsed = toc;
end