function [] = collectLocalDataToCenter2(tag_s, msg)
%
% MatMPI wrappter function
% 
% If this function is executed at a slave node, this function sends 
% 'localData' to the master node. If this function is executed at a master
% node, the function receives 'localData' from all slave nodes and update the 
% fields (specified by 'names' input parameter) of subdomains. 
% 
% tag_s:    message identifier used by a slave node to send its localData 
% localData: local data to be updated to a master node
% names:     the field names in 'subdomain' structure, which are updated
%            via localData
% Copyright (c) by Chiwoo Park, 2011-06-07


global my_rank
global comm
global comm_size

if (my_rank ~= 0) % each slave node reports its update to the master node
    MPI_Send(0, tag_s, comm, msg);
else
    % the master node updates the corresponding fields of subdomains with
    % the received 'localData'.
    for j = 1:comm_size-1
        msg = MPI_Recv(j, tag_s, comm);
        fprintf('msg from %d is %s', j, msg);
    end
end