function [] = collectLocalDataToCenter(tag_s, localData, names)
%
% MatMPI wrappter function
% 
% If this function is executed at a slave node, this function sends 
% 'localData' to the master node. If this function is executed at a master
% node, the function receives 'localData' from all slave nodes and update the 
% fields (specified by 'names' input parameter) of subdomains. 
% 
% tag_s:    message identifier used by a slave node to send its localData 
% localData: local data to be updated to a master node
% names:     the field names in 'subdomain' structure, which are updated
%            via localData
% Copyright (c) by Chiwoo Park, 2011-06-07


global my_rank
global comm
global comm_size
global ntask
global subdomains
global sp_task

nFields = size(names, 2);

if (my_rank ~= 0) % each slave node reports its update to the master node
    MPI_Send(0, tag_s, comm, localData);
else
    % the master node updates the corresponding fields of subdomains with
    % the received 'localData'.
    for j = 1:comm_size-1
        localData1 = MPI_Recv(j, tag_s, comm);
        for k = 1:ntask(j+1)
            l = sp_task(j+1) + k - 1;
            for m = 1:nFields
                subdomains{l}.(names{m}) = localData1{k,m};
            end
        end
    end
end