function [subdomains, cp_subdomains, interfaces, vertices, memberFunc, affine] = meshFunc_mc(x, y, idx, dd_param)
%
% This is a wrapper function to enable the use of a non-parallel version of
% mesh generation function in the parallel version.
%
% where 
%     x         : n by 2 matrix of training inputs
%     y         : column vector of length n of training targets
%     idx       : logical mask to indicate the subset of training data
%                 used for learning the hyperparameters.
%     dd_param.meshfunc: the string name of the function used to decompose the
%                     domain into subdomains.
%     dd_param.mparam:  input parameters for meshfunc (e.g. the size of
%                     subdomains)
%     subdomains: N by 1 cell array of structures containing information
%                 regarding all the subdomains obtained by the decomposition
%     cp_subdomains: N by 1 cell array of structures containing only 
%                    subsets of training inputs necessary for learning
%                    hyperparameters
%     interfaces: M by 1 cell array of structures containing information
%                 regarding all the polygonal boundaries of the subdomains 
%     vertices  : V by 2 matrix of the vertex coordinates of the
%                 polygons representing the subdomain boundaries.
%     memberFunc: a membership function to check if data x belongs to 
%                 subdomain sd (usage: memberFunc(x, sd))
%     affine    : affine transformation that transforms the global coordinates
%                 into the local coordinates
%
% Copyright (c) by Chiwoo Park, 2011-06-07

% execute the non-parallel version of the mesh generation function
meshfunc = dd_param.meshfunc; mparam = dd_param.mparam;
[subdomains, interfaces, vertices, memberFunc, affine] = feval(meshfunc,...
                                                        mparam, x, y, idx);
% add information necessary for parallel computation
N = size(subdomains, 1);
cp_subdomains = cell(N, 1);
for i = 1:N
    sd = subdomains{i};
    n_intf   = sd.int_idx(length(sd.int_idx));
    sd.interface = cell(n_intf, 1);
    sd.box  = vertices(sd.T, :);
    for j = 1:n_intf
        k = sd.int_idx(j);
        sd.interface{j} = interfaces{k};
    end
    cp_sd.hx = affine(sd.hx, sd); 
    cp_sd.hy = sd.hy;
    cp_subdomains{i} = cp_sd;
    subdomains{i} = sd;
end