function [loglike, dloglike] = loglikelihood_ddm_mc(logtheta, covfunc, subdomains)
%
% loglikelihood_ddm - The function returns minus the log likelihood and its 
% partial derivatives with respect to the hyperparameters; this mode is 
% used to fit the hyperparameters.
%
% where:
%   logtheta:   a (column) vector of log hyperparameters
%   covfunc:    prior covariance function
%   subdomains: N-by-1 cell array, containing the information about 
%               the structure of domain decomposition
% Copyright (c) by Chiwoo Park, 2011-06-07

N = size(subdomains, 1); 
D = size(logtheta, 1); 
loglike = zeros(N, 1); dloglike = zeros(N, D);
parfor i = 1:N
    sd = subdomains{i};
    [loglike(i,1), dloglike(i,:)] = loglikelihood(logtheta, covfunc, sd.hx, sd.hy);
end
loglike = sum(loglike);
dloglike = sum(dloglike)';