function [me, s2] = localGP_pred_mc(xt, sd, covfunc, affine)
%
% Predict the regression values at test inputs, based on standard 
% Gaussian process regression. Usage:
%     [me, s2] = localGP_pred_mc(xt, sd, covfunc, affine)
% where 
%     xt:      test inputs
%     sd:      a structure containing information about a subdomain 
%     covfunc: prior covariance function 
%     affine:  affine transformation function that transforms the global
%              coordinates into the local coordinates in sd
%     me:      prediction mean values
%     s2:      prediction variances
% 
% Copyright (c) by Chiwoo Park, 2011-06-07x    = affine(sd.x,sd);
x    = sd.x;
[Kxx, K_ix] = feval(covfunc{:}, sd.logtheta, affine(x, sd), affine(xt, sd));
me   = sd.h_i' * K_ix;
me   = me';

if nargout > 1
    sig2 = exp(2*sd.logtheta(end));
    s2   = sig2 + Kxx - diag(K_ix' *  sd.isigK * K_ix);
end